/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.wisdom.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetContentSummaryResponse extends WisdomResponse implements
        ToCopyableBuilder<GetContentSummaryResponse.Builder, GetContentSummaryResponse> {
    private static final SdkField<ContentSummary> CONTENT_SUMMARY_FIELD = SdkField
            .<ContentSummary> builder(MarshallingType.SDK_POJO).memberName("contentSummary")
            .getter(getter(GetContentSummaryResponse::contentSummary)).setter(setter(Builder::contentSummary))
            .constructor(ContentSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentSummary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ContentSummary contentSummary;

    private GetContentSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.contentSummary = builder.contentSummary;
    }

    /**
     * <p>
     * The content summary.
     * </p>
     * 
     * @return The content summary.
     */
    public final ContentSummary contentSummary() {
        return contentSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contentSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetContentSummaryResponse)) {
            return false;
        }
        GetContentSummaryResponse other = (GetContentSummaryResponse) obj;
        return Objects.equals(contentSummary(), other.contentSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetContentSummaryResponse").add("ContentSummary", contentSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentSummary":
            return Optional.ofNullable(clazz.cast(contentSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("contentSummary", CONTENT_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetContentSummaryResponse, T> g) {
        return obj -> g.apply((GetContentSummaryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WisdomResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetContentSummaryResponse> {
        /**
         * <p>
         * The content summary.
         * </p>
         * 
         * @param contentSummary
         *        The content summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentSummary(ContentSummary contentSummary);

        /**
         * <p>
         * The content summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContentSummary.Builder} avoiding the need
         * to create one manually via {@link ContentSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContentSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #contentSummary(ContentSummary)}.
         * 
         * @param contentSummary
         *        a consumer that will call methods on {@link ContentSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contentSummary(ContentSummary)
         */
        default Builder contentSummary(Consumer<ContentSummary.Builder> contentSummary) {
            return contentSummary(ContentSummary.builder().applyMutation(contentSummary).build());
        }
    }

    static final class BuilderImpl extends WisdomResponse.BuilderImpl implements Builder {
        private ContentSummary contentSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(GetContentSummaryResponse model) {
            super(model);
            contentSummary(model.contentSummary);
        }

        public final ContentSummary.Builder getContentSummary() {
            return contentSummary != null ? contentSummary.toBuilder() : null;
        }

        public final void setContentSummary(ContentSummary.BuilderImpl contentSummary) {
            this.contentSummary = contentSummary != null ? contentSummary.build() : null;
        }

        @Override
        public final Builder contentSummary(ContentSummary contentSummary) {
            this.contentSummary = contentSummary;
            return this;
        }

        @Override
        public GetContentSummaryResponse build() {
            return new GetContentSummaryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
