/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeResourcePermissionsResponse extends WorkDocsResponse implements
        ToCopyableBuilder<DescribeResourcePermissionsResponse.Builder, DescribeResourcePermissionsResponse> {
    private static final SdkField<List<Principal>> PRINCIPALS_FIELD = SdkField
            .<List<Principal>> builder(MarshallingType.LIST)
            .memberName("Principals")
            .getter(getter(DescribeResourcePermissionsResponse::principals))
            .setter(setter(Builder::principals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Principal> builder(MarshallingType.SDK_POJO)
                                            .constructor(Principal::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeResourcePermissionsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PRINCIPALS_FIELD, MARKER_FIELD));

    private final List<Principal> principals;

    private final String marker;

    private DescribeResourcePermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.principals = builder.principals;
        this.marker = builder.marker;
    }

    /**
     * Returns true if the Principals property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPrincipals() {
        return principals != null && !(principals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The principals.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPrincipals()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The principals.
     */
    public final List<Principal> principals() {
        return principals;
    }

    /**
     * <p>
     * The marker to use when requesting the next set of results. If there are no additional results, the string is
     * empty.
     * </p>
     * 
     * @return The marker to use when requesting the next set of results. If there are no additional results, the string
     *         is empty.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPrincipals() ? principals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourcePermissionsResponse)) {
            return false;
        }
        DescribeResourcePermissionsResponse other = (DescribeResourcePermissionsResponse) obj;
        return hasPrincipals() == other.hasPrincipals() && Objects.equals(principals(), other.principals())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeResourcePermissionsResponse").add("Principals", hasPrincipals() ? principals() : null)
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Principals":
            return Optional.ofNullable(clazz.cast(principals()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeResourcePermissionsResponse, T> g) {
        return obj -> g.apply((DescribeResourcePermissionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkDocsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeResourcePermissionsResponse> {
        /**
         * <p>
         * The principals.
         * </p>
         * 
         * @param principals
         *        The principals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(Collection<Principal> principals);

        /**
         * <p>
         * The principals.
         * </p>
         * 
         * @param principals
         *        The principals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(Principal... principals);

        /**
         * <p>
         * The principals.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Principal>.Builder} avoiding the need to
         * create one manually via {@link List<Principal>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Principal>.Builder#build()} is called immediately and its
         * result is passed to {@link #principals(List<Principal>)}.
         * 
         * @param principals
         *        a consumer that will call methods on {@link List<Principal>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #principals(List<Principal>)
         */
        Builder principals(Consumer<Principal.Builder>... principals);

        /**
         * <p>
         * The marker to use when requesting the next set of results. If there are no additional results, the string is
         * empty.
         * </p>
         * 
         * @param marker
         *        The marker to use when requesting the next set of results. If there are no additional results, the
         *        string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends WorkDocsResponse.BuilderImpl implements Builder {
        private List<Principal> principals = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResourcePermissionsResponse model) {
            super(model);
            principals(model.principals);
            marker(model.marker);
        }

        public final List<Principal.Builder> getPrincipals() {
            List<Principal.Builder> result = PrincipalListCopier.copyToBuilder(this.principals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder principals(Collection<Principal> principals) {
            this.principals = PrincipalListCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(Principal... principals) {
            principals(Arrays.asList(principals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(Consumer<Principal.Builder>... principals) {
            principals(Stream.of(principals).map(c -> Principal.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPrincipals(Collection<Principal.BuilderImpl> principals) {
            this.principals = PrincipalListCopier.copyFromBuilder(principals);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeResourcePermissionsResponse build() {
            return new DescribeResourcePermissionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
