/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUserRequest extends WorkDocsRequest implements
        ToCopyableBuilder<CreateUserRequest.Builder, CreateUserRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationId").getter(getter(CreateUserRequest::organizationId))
            .setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(CreateUserRequest::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailAddress").getter(getter(CreateUserRequest::emailAddress)).setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()).build();

    private static final SdkField<String> GIVEN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GivenName").getter(getter(CreateUserRequest::givenName)).setter(setter(Builder::givenName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GivenName").build()).build();

    private static final SdkField<String> SURNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Surname")
            .getter(getter(CreateUserRequest::surname)).setter(setter(Builder::surname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Surname").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Password").getter(getter(CreateUserRequest::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final SdkField<String> TIME_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeZoneId").getter(getter(CreateUserRequest::timeZoneId)).setter(setter(Builder::timeZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZoneId").build()).build();

    private static final SdkField<StorageRuleType> STORAGE_RULE_FIELD = SdkField
            .<StorageRuleType> builder(MarshallingType.SDK_POJO).memberName("StorageRule")
            .getter(getter(CreateUserRequest::storageRule)).setter(setter(Builder::storageRule))
            .constructor(StorageRuleType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageRule").build()).build();

    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationToken").getter(getter(CreateUserRequest::authenticationToken))
            .setter(setter(Builder::authenticationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD,
            USERNAME_FIELD, EMAIL_ADDRESS_FIELD, GIVEN_NAME_FIELD, SURNAME_FIELD, PASSWORD_FIELD, TIME_ZONE_ID_FIELD,
            STORAGE_RULE_FIELD, AUTHENTICATION_TOKEN_FIELD));

    private final String organizationId;

    private final String username;

    private final String emailAddress;

    private final String givenName;

    private final String surname;

    private final String password;

    private final String timeZoneId;

    private final StorageRuleType storageRule;

    private final String authenticationToken;

    private CreateUserRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.username = builder.username;
        this.emailAddress = builder.emailAddress;
        this.givenName = builder.givenName;
        this.surname = builder.surname;
        this.password = builder.password;
        this.timeZoneId = builder.timeZoneId;
        this.storageRule = builder.storageRule;
        this.authenticationToken = builder.authenticationToken;
    }

    /**
     * <p>
     * The ID of the organization.
     * </p>
     * 
     * @return The ID of the organization.
     */
    public final String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * The login name of the user.
     * </p>
     * 
     * @return The login name of the user.
     */
    public final String username() {
        return username;
    }

    /**
     * <p>
     * The email address of the user.
     * </p>
     * 
     * @return The email address of the user.
     */
    public final String emailAddress() {
        return emailAddress;
    }

    /**
     * <p>
     * The given name of the user.
     * </p>
     * 
     * @return The given name of the user.
     */
    public final String givenName() {
        return givenName;
    }

    /**
     * <p>
     * The surname of the user.
     * </p>
     * 
     * @return The surname of the user.
     */
    public final String surname() {
        return surname;
    }

    /**
     * <p>
     * The password of the user.
     * </p>
     * 
     * @return The password of the user.
     */
    public final String password() {
        return password;
    }

    /**
     * <p>
     * The time zone ID of the user.
     * </p>
     * 
     * @return The time zone ID of the user.
     */
    public final String timeZoneId() {
        return timeZoneId;
    }

    /**
     * <p>
     * The amount of storage for the user.
     * </p>
     * 
     * @return The amount of storage for the user.
     */
    public final StorageRuleType storageRule() {
        return storageRule;
    }

    /**
     * <p>
     * Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.
     * </p>
     * 
     * @return Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the
     *         API.
     */
    public final String authenticationToken() {
        return authenticationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(givenName());
        hashCode = 31 * hashCode + Objects.hashCode(surname());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(timeZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(storageRule());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserRequest)) {
            return false;
        }
        CreateUserRequest other = (CreateUserRequest) obj;
        return Objects.equals(organizationId(), other.organizationId()) && Objects.equals(username(), other.username())
                && Objects.equals(emailAddress(), other.emailAddress()) && Objects.equals(givenName(), other.givenName())
                && Objects.equals(surname(), other.surname()) && Objects.equals(password(), other.password())
                && Objects.equals(timeZoneId(), other.timeZoneId()) && Objects.equals(storageRule(), other.storageRule())
                && Objects.equals(authenticationToken(), other.authenticationToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateUserRequest").add("OrganizationId", organizationId()).add("Username", username())
                .add("EmailAddress", emailAddress()).add("GivenName", givenName()).add("Surname", surname())
                .add("Password", password() == null ? null : "*** Sensitive Data Redacted ***").add("TimeZoneId", timeZoneId())
                .add("StorageRule", storageRule())
                .add("AuthenticationToken", authenticationToken() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "EmailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "GivenName":
            return Optional.ofNullable(clazz.cast(givenName()));
        case "Surname":
            return Optional.ofNullable(clazz.cast(surname()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        case "TimeZoneId":
            return Optional.ofNullable(clazz.cast(timeZoneId()));
        case "StorageRule":
            return Optional.ofNullable(clazz.cast(storageRule()));
        case "AuthenticationToken":
            return Optional.ofNullable(clazz.cast(authenticationToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUserRequest, T> g) {
        return obj -> g.apply((CreateUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkDocsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateUserRequest> {
        /**
         * <p>
         * The ID of the organization.
         * </p>
         * 
         * @param organizationId
         *        The ID of the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * The login name of the user.
         * </p>
         * 
         * @param username
         *        The login name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The email address of the user.
         * </p>
         * 
         * @param emailAddress
         *        The email address of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * The given name of the user.
         * </p>
         * 
         * @param givenName
         *        The given name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder givenName(String givenName);

        /**
         * <p>
         * The surname of the user.
         * </p>
         * 
         * @param surname
         *        The surname of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder surname(String surname);

        /**
         * <p>
         * The password of the user.
         * </p>
         * 
         * @param password
         *        The password of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * The time zone ID of the user.
         * </p>
         * 
         * @param timeZoneId
         *        The time zone ID of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeZoneId(String timeZoneId);

        /**
         * <p>
         * The amount of storage for the user.
         * </p>
         * 
         * @param storageRule
         *        The amount of storage for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageRule(StorageRuleType storageRule);

        /**
         * <p>
         * The amount of storage for the user.
         * </p>
         * This is a convenience that creates an instance of the {@link StorageRuleType.Builder} avoiding the need to
         * create one manually via {@link StorageRuleType#builder()}.
         *
         * When the {@link Consumer} completes, {@link StorageRuleType.Builder#build()} is called immediately and its
         * result is passed to {@link #storageRule(StorageRuleType)}.
         * 
         * @param storageRule
         *        a consumer that will call methods on {@link StorageRuleType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageRule(StorageRuleType)
         */
        default Builder storageRule(Consumer<StorageRuleType.Builder> storageRule) {
            return storageRule(StorageRuleType.builder().applyMutation(storageRule).build());
        }

        /**
         * <p>
         * Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the
         * API.
         * </p>
         * 
         * @param authenticationToken
         *        Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access
         *        the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationToken(String authenticationToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkDocsRequest.BuilderImpl implements Builder {
        private String organizationId;

        private String username;

        private String emailAddress;

        private String givenName;

        private String surname;

        private String password;

        private String timeZoneId;

        private StorageRuleType storageRule;

        private String authenticationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserRequest model) {
            super(model);
            organizationId(model.organizationId);
            username(model.username);
            emailAddress(model.emailAddress);
            givenName(model.givenName);
            surname(model.surname);
            password(model.password);
            timeZoneId(model.timeZoneId);
            storageRule(model.storageRule);
            authenticationToken(model.authenticationToken);
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        public final String getGivenName() {
            return givenName;
        }

        @Override
        public final Builder givenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public final void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        public final String getSurname() {
            return surname;
        }

        @Override
        public final Builder surname(String surname) {
            this.surname = surname;
            return this;
        }

        public final void setSurname(String surname) {
            this.surname = surname;
        }

        public final String getPassword() {
            return password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final String getTimeZoneId() {
            return timeZoneId;
        }

        @Override
        public final Builder timeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return this;
        }

        public final void setTimeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
        }

        public final StorageRuleType.Builder getStorageRule() {
            return storageRule != null ? storageRule.toBuilder() : null;
        }

        @Override
        public final Builder storageRule(StorageRuleType storageRule) {
            this.storageRule = storageRule;
            return this;
        }

        public final void setStorageRule(StorageRuleType.BuilderImpl storageRule) {
            this.storageRule = storageRule != null ? storageRule.build() : null;
        }

        public final String getAuthenticationToken() {
            return authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUserRequest build() {
            return new CreateUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
