/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeActivitiesResponse extends WorkDocsResponse implements
        ToCopyableBuilder<DescribeActivitiesResponse.Builder, DescribeActivitiesResponse> {
    private static final SdkField<List<Activity>> USER_ACTIVITIES_FIELD = SdkField
            .<List<Activity>> builder(MarshallingType.LIST)
            .memberName("UserActivities")
            .getter(getter(DescribeActivitiesResponse::userActivities))
            .setter(setter(Builder::userActivities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserActivities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Activity> builder(MarshallingType.SDK_POJO)
                                            .constructor(Activity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeActivitiesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ACTIVITIES_FIELD,
            MARKER_FIELD));

    private final List<Activity> userActivities;

    private final String marker;

    private DescribeActivitiesResponse(BuilderImpl builder) {
        super(builder);
        this.userActivities = builder.userActivities;
        this.marker = builder.marker;
    }

    /**
     * Returns true if the UserActivities property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasUserActivities() {
        return userActivities != null && !(userActivities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of activities for the specified user and time period.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserActivities()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of activities for the specified user and time period.
     */
    public final List<Activity> userActivities() {
        return userActivities;
    }

    /**
     * <p>
     * The marker for the next set of results.
     * </p>
     * 
     * @return The marker for the next set of results.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUserActivities() ? userActivities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActivitiesResponse)) {
            return false;
        }
        DescribeActivitiesResponse other = (DescribeActivitiesResponse) obj;
        return hasUserActivities() == other.hasUserActivities() && Objects.equals(userActivities(), other.userActivities())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeActivitiesResponse")
                .add("UserActivities", hasUserActivities() ? userActivities() : null).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserActivities":
            return Optional.ofNullable(clazz.cast(userActivities()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeActivitiesResponse, T> g) {
        return obj -> g.apply((DescribeActivitiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkDocsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeActivitiesResponse> {
        /**
         * <p>
         * The list of activities for the specified user and time period.
         * </p>
         * 
         * @param userActivities
         *        The list of activities for the specified user and time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userActivities(Collection<Activity> userActivities);

        /**
         * <p>
         * The list of activities for the specified user and time period.
         * </p>
         * 
         * @param userActivities
         *        The list of activities for the specified user and time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userActivities(Activity... userActivities);

        /**
         * <p>
         * The list of activities for the specified user and time period.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Activity>.Builder} avoiding the need to
         * create one manually via {@link List<Activity>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Activity>.Builder#build()} is called immediately and its
         * result is passed to {@link #userActivities(List<Activity>)}.
         * 
         * @param userActivities
         *        a consumer that will call methods on {@link List<Activity>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userActivities(List<Activity>)
         */
        Builder userActivities(Consumer<Activity.Builder>... userActivities);

        /**
         * <p>
         * The marker for the next set of results.
         * </p>
         * 
         * @param marker
         *        The marker for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends WorkDocsResponse.BuilderImpl implements Builder {
        private List<Activity> userActivities = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeActivitiesResponse model) {
            super(model);
            userActivities(model.userActivities);
            marker(model.marker);
        }

        public final List<Activity.Builder> getUserActivities() {
            List<Activity.Builder> result = UserActivitiesCopier.copyToBuilder(this.userActivities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder userActivities(Collection<Activity> userActivities) {
            this.userActivities = UserActivitiesCopier.copy(userActivities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userActivities(Activity... userActivities) {
            userActivities(Arrays.asList(userActivities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userActivities(Consumer<Activity.Builder>... userActivities) {
            userActivities(Stream.of(userActivities).map(c -> Activity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUserActivities(Collection<Activity.BuilderImpl> userActivities) {
            this.userActivities = UserActivitiesCopier.copyFromBuilder(userActivities);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeActivitiesResponse build() {
            return new DescribeActivitiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
