/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the upload.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UploadMetadata implements SdkPojo, Serializable, ToCopyableBuilder<UploadMetadata.Builder, UploadMetadata> {
    private static final SdkField<String> UPLOAD_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UploadUrl").getter(getter(UploadMetadata::uploadUrl)).setter(setter(Builder::uploadUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadUrl").build()).build();

    private static final SdkField<Map<String, String>> SIGNED_HEADERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("SignedHeaders")
            .getter(getter(UploadMetadata::signedHeaders))
            .setter(setter(Builder::signedHeaders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SignedHeaders").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPLOAD_URL_FIELD,
            SIGNED_HEADERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String uploadUrl;

    private final Map<String, String> signedHeaders;

    private UploadMetadata(BuilderImpl builder) {
        this.uploadUrl = builder.uploadUrl;
        this.signedHeaders = builder.signedHeaders;
    }

    /**
     * <p>
     * The URL of the upload.
     * </p>
     * 
     * @return The URL of the upload.
     */
    public final String uploadUrl() {
        return uploadUrl;
    }

    /**
     * Returns true if the SignedHeaders property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSignedHeaders() {
        return signedHeaders != null && !(signedHeaders instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The signed headers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSignedHeaders()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The signed headers.
     */
    public final Map<String, String> signedHeaders() {
        return signedHeaders;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(uploadUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasSignedHeaders() ? signedHeaders() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadMetadata)) {
            return false;
        }
        UploadMetadata other = (UploadMetadata) obj;
        return Objects.equals(uploadUrl(), other.uploadUrl()) && hasSignedHeaders() == other.hasSignedHeaders()
                && Objects.equals(signedHeaders(), other.signedHeaders());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UploadMetadata")
                .add("UploadUrl", uploadUrl() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SignedHeaders", hasSignedHeaders() ? signedHeaders() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UploadUrl":
            return Optional.ofNullable(clazz.cast(uploadUrl()));
        case "SignedHeaders":
            return Optional.ofNullable(clazz.cast(signedHeaders()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UploadMetadata, T> g) {
        return obj -> g.apply((UploadMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UploadMetadata> {
        /**
         * <p>
         * The URL of the upload.
         * </p>
         * 
         * @param uploadUrl
         *        The URL of the upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadUrl(String uploadUrl);

        /**
         * <p>
         * The signed headers.
         * </p>
         * 
         * @param signedHeaders
         *        The signed headers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signedHeaders(Map<String, String> signedHeaders);
    }

    static final class BuilderImpl implements Builder {
        private String uploadUrl;

        private Map<String, String> signedHeaders = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UploadMetadata model) {
            uploadUrl(model.uploadUrl);
            signedHeaders(model.signedHeaders);
        }

        public final String getUploadUrl() {
            return uploadUrl;
        }

        @Override
        public final Builder uploadUrl(String uploadUrl) {
            this.uploadUrl = uploadUrl;
            return this;
        }

        public final void setUploadUrl(String uploadUrl) {
            this.uploadUrl = uploadUrl;
        }

        public final Map<String, String> getSignedHeaders() {
            if (signedHeaders instanceof SdkAutoConstructMap) {
                return null;
            }
            return signedHeaders;
        }

        @Override
        public final Builder signedHeaders(Map<String, String> signedHeaders) {
            this.signedHeaders = SignedHeaderMapCopier.copy(signedHeaders);
            return this;
        }

        public final void setSignedHeaders(Map<String, String> signedHeaders) {
            this.signedHeaders = SignedHeaderMapCopier.copy(signedHeaders);
        }

        @Override
        public UploadMetadata build() {
            return new UploadMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
