/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a comment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Comment implements SdkPojo, Serializable, ToCopyableBuilder<Comment.Builder, Comment> {
    private static final SdkField<String> COMMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CommentId").getter(getter(Comment::commentId)).setter(setter(Builder::commentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommentId").build()).build();

    private static final SdkField<String> PARENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentId").getter(getter(Comment::parentId)).setter(setter(Builder::parentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentId").build()).build();

    private static final SdkField<String> THREAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThreadId").getter(getter(Comment::threadId)).setter(setter(Builder::threadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreadId").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Text")
            .getter(getter(Comment::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final SdkField<User> CONTRIBUTOR_FIELD = SdkField.<User> builder(MarshallingType.SDK_POJO)
            .memberName("Contributor").getter(getter(Comment::contributor)).setter(setter(Builder::contributor))
            .constructor(User::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Contributor").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(Comment::createdTimestamp)).setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Comment::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(Comment::visibilityAsString)).setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final SdkField<String> RECIPIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecipientId").getter(getter(Comment::recipientId)).setter(setter(Builder::recipientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipientId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_ID_FIELD,
            PARENT_ID_FIELD, THREAD_ID_FIELD, TEXT_FIELD, CONTRIBUTOR_FIELD, CREATED_TIMESTAMP_FIELD, STATUS_FIELD,
            VISIBILITY_FIELD, RECIPIENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String commentId;

    private final String parentId;

    private final String threadId;

    private final String text;

    private final User contributor;

    private final Instant createdTimestamp;

    private final String status;

    private final String visibility;

    private final String recipientId;

    private Comment(BuilderImpl builder) {
        this.commentId = builder.commentId;
        this.parentId = builder.parentId;
        this.threadId = builder.threadId;
        this.text = builder.text;
        this.contributor = builder.contributor;
        this.createdTimestamp = builder.createdTimestamp;
        this.status = builder.status;
        this.visibility = builder.visibility;
        this.recipientId = builder.recipientId;
    }

    /**
     * <p>
     * The ID of the comment.
     * </p>
     * 
     * @return The ID of the comment.
     */
    public final String commentId() {
        return commentId;
    }

    /**
     * <p>
     * The ID of the parent comment.
     * </p>
     * 
     * @return The ID of the parent comment.
     */
    public final String parentId() {
        return parentId;
    }

    /**
     * <p>
     * The ID of the root comment in the thread.
     * </p>
     * 
     * @return The ID of the root comment in the thread.
     */
    public final String threadId() {
        return threadId;
    }

    /**
     * <p>
     * The text of the comment.
     * </p>
     * 
     * @return The text of the comment.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * The details of the user who made the comment.
     * </p>
     * 
     * @return The details of the user who made the comment.
     */
    public final User contributor() {
        return contributor;
    }

    /**
     * <p>
     * The time that the comment was created.
     * </p>
     * 
     * @return The time that the comment was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The status of the comment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CommentStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the comment.
     * @see CommentStatusType
     */
    public final CommentStatusType status() {
        return CommentStatusType.fromValue(status);
    }

    /**
     * <p>
     * The status of the comment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CommentStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the comment.
     * @see CommentStatusType
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The visibility of the comment. Options are either PRIVATE, where the comment is visible only to the comment
     * author and document owner and co-owners, or PUBLIC, where the comment is visible to document owners, co-owners,
     * and contributors.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link CommentVisibilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of the comment. Options are either PRIVATE, where the comment is visible only to the
     *         comment author and document owner and co-owners, or PUBLIC, where the comment is visible to document
     *         owners, co-owners, and contributors.
     * @see CommentVisibilityType
     */
    public final CommentVisibilityType visibility() {
        return CommentVisibilityType.fromValue(visibility);
    }

    /**
     * <p>
     * The visibility of the comment. Options are either PRIVATE, where the comment is visible only to the comment
     * author and document owner and co-owners, or PUBLIC, where the comment is visible to document owners, co-owners,
     * and contributors.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link CommentVisibilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of the comment. Options are either PRIVATE, where the comment is visible only to the
     *         comment author and document owner and co-owners, or PUBLIC, where the comment is visible to document
     *         owners, co-owners, and contributors.
     * @see CommentVisibilityType
     */
    public final String visibilityAsString() {
        return visibility;
    }

    /**
     * <p>
     * If the comment is a reply to another user's comment, this field contains the user ID of the user being replied
     * to.
     * </p>
     * 
     * @return If the comment is a reply to another user's comment, this field contains the user ID of the user being
     *         replied to.
     */
    public final String recipientId() {
        return recipientId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(commentId());
        hashCode = 31 * hashCode + Objects.hashCode(parentId());
        hashCode = 31 * hashCode + Objects.hashCode(threadId());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(contributor());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(recipientId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Comment)) {
            return false;
        }
        Comment other = (Comment) obj;
        return Objects.equals(commentId(), other.commentId()) && Objects.equals(parentId(), other.parentId())
                && Objects.equals(threadId(), other.threadId()) && Objects.equals(text(), other.text())
                && Objects.equals(contributor(), other.contributor())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(visibilityAsString(), other.visibilityAsString())
                && Objects.equals(recipientId(), other.recipientId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Comment").add("CommentId", commentId()).add("ParentId", parentId()).add("ThreadId", threadId())
                .add("Text", text() == null ? null : "*** Sensitive Data Redacted ***").add("Contributor", contributor())
                .add("CreatedTimestamp", createdTimestamp()).add("Status", statusAsString())
                .add("Visibility", visibilityAsString()).add("RecipientId", recipientId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CommentId":
            return Optional.ofNullable(clazz.cast(commentId()));
        case "ParentId":
            return Optional.ofNullable(clazz.cast(parentId()));
        case "ThreadId":
            return Optional.ofNullable(clazz.cast(threadId()));
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        case "Contributor":
            return Optional.ofNullable(clazz.cast(contributor()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        case "RecipientId":
            return Optional.ofNullable(clazz.cast(recipientId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Comment, T> g) {
        return obj -> g.apply((Comment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Comment> {
        /**
         * <p>
         * The ID of the comment.
         * </p>
         * 
         * @param commentId
         *        The ID of the comment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commentId(String commentId);

        /**
         * <p>
         * The ID of the parent comment.
         * </p>
         * 
         * @param parentId
         *        The ID of the parent comment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentId(String parentId);

        /**
         * <p>
         * The ID of the root comment in the thread.
         * </p>
         * 
         * @param threadId
         *        The ID of the root comment in the thread.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threadId(String threadId);

        /**
         * <p>
         * The text of the comment.
         * </p>
         * 
         * @param text
         *        The text of the comment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * The details of the user who made the comment.
         * </p>
         * 
         * @param contributor
         *        The details of the user who made the comment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contributor(User contributor);

        /**
         * <p>
         * The details of the user who made the comment.
         * </p>
         * This is a convenience that creates an instance of the {@link User.Builder} avoiding the need to create one
         * manually via {@link User#builder()}.
         *
         * When the {@link Consumer} completes, {@link User.Builder#build()} is called immediately and its result is
         * passed to {@link #contributor(User)}.
         * 
         * @param contributor
         *        a consumer that will call methods on {@link User.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contributor(User)
         */
        default Builder contributor(Consumer<User.Builder> contributor) {
            return contributor(User.builder().applyMutation(contributor).build());
        }

        /**
         * <p>
         * The time that the comment was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The time that the comment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The status of the comment.
         * </p>
         * 
         * @param status
         *        The status of the comment.
         * @see CommentStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommentStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the comment.
         * </p>
         * 
         * @param status
         *        The status of the comment.
         * @see CommentStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommentStatusType
         */
        Builder status(CommentStatusType status);

        /**
         * <p>
         * The visibility of the comment. Options are either PRIVATE, where the comment is visible only to the comment
         * author and document owner and co-owners, or PUBLIC, where the comment is visible to document owners,
         * co-owners, and contributors.
         * </p>
         * 
         * @param visibility
         *        The visibility of the comment. Options are either PRIVATE, where the comment is visible only to the
         *        comment author and document owner and co-owners, or PUBLIC, where the comment is visible to document
         *        owners, co-owners, and contributors.
         * @see CommentVisibilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommentVisibilityType
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * The visibility of the comment. Options are either PRIVATE, where the comment is visible only to the comment
         * author and document owner and co-owners, or PUBLIC, where the comment is visible to document owners,
         * co-owners, and contributors.
         * </p>
         * 
         * @param visibility
         *        The visibility of the comment. Options are either PRIVATE, where the comment is visible only to the
         *        comment author and document owner and co-owners, or PUBLIC, where the comment is visible to document
         *        owners, co-owners, and contributors.
         * @see CommentVisibilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommentVisibilityType
         */
        Builder visibility(CommentVisibilityType visibility);

        /**
         * <p>
         * If the comment is a reply to another user's comment, this field contains the user ID of the user being
         * replied to.
         * </p>
         * 
         * @param recipientId
         *        If the comment is a reply to another user's comment, this field contains the user ID of the user being
         *        replied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipientId(String recipientId);
    }

    static final class BuilderImpl implements Builder {
        private String commentId;

        private String parentId;

        private String threadId;

        private String text;

        private User contributor;

        private Instant createdTimestamp;

        private String status;

        private String visibility;

        private String recipientId;

        private BuilderImpl() {
        }

        private BuilderImpl(Comment model) {
            commentId(model.commentId);
            parentId(model.parentId);
            threadId(model.threadId);
            text(model.text);
            contributor(model.contributor);
            createdTimestamp(model.createdTimestamp);
            status(model.status);
            visibility(model.visibility);
            recipientId(model.recipientId);
        }

        public final String getCommentId() {
            return commentId;
        }

        public final void setCommentId(String commentId) {
            this.commentId = commentId;
        }

        @Override
        @Transient
        public final Builder commentId(String commentId) {
            this.commentId = commentId;
            return this;
        }

        public final String getParentId() {
            return parentId;
        }

        public final void setParentId(String parentId) {
            this.parentId = parentId;
        }

        @Override
        @Transient
        public final Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public final String getThreadId() {
            return threadId;
        }

        public final void setThreadId(String threadId) {
            this.threadId = threadId;
        }

        @Override
        @Transient
        public final Builder threadId(String threadId) {
            this.threadId = threadId;
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        @Transient
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final User.Builder getContributor() {
            return contributor != null ? contributor.toBuilder() : null;
        }

        public final void setContributor(User.BuilderImpl contributor) {
            this.contributor = contributor != null ? contributor.build() : null;
        }

        @Override
        @Transient
        public final Builder contributor(User contributor) {
            this.contributor = contributor;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        @Transient
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(CommentStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        @Transient
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        @Transient
        public final Builder visibility(CommentVisibilityType visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final String getRecipientId() {
            return recipientId;
        }

        public final void setRecipientId(String recipientId) {
            this.recipientId = recipientId;
        }

        @Override
        @Transient
        public final Builder recipientId(String recipientId) {
            this.recipientId = recipientId;
            return this;
        }

        @Override
        public Comment build() {
            return new Comment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
