/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCommentRequest extends WorkDocsRequest implements
        ToCopyableBuilder<CreateCommentRequest.Builder, CreateCommentRequest> {
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationToken").getter(getter(CreateCommentRequest::authenticationToken))
            .setter(setter(Builder::authenticationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()).build();

    private static final SdkField<String> DOCUMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentId").getter(getter(CreateCommentRequest::documentId)).setter(setter(Builder::documentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DocumentId").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionId").getter(getter(CreateCommentRequest::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("VersionId").build()).build();

    private static final SdkField<String> PARENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentId").getter(getter(CreateCommentRequest::parentId)).setter(setter(Builder::parentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentId").build()).build();

    private static final SdkField<String> THREAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThreadId").getter(getter(CreateCommentRequest::threadId)).setter(setter(Builder::threadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreadId").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Text")
            .getter(getter(CreateCommentRequest::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()).build();

    private static final SdkField<String> VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Visibility").getter(getter(CreateCommentRequest::visibilityAsString))
            .setter(setter(Builder::visibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()).build();

    private static final SdkField<Boolean> NOTIFY_COLLABORATORS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NotifyCollaborators").getter(getter(CreateCommentRequest::notifyCollaborators))
            .setter(setter(Builder::notifyCollaborators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotifyCollaborators").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TOKEN_FIELD,
            DOCUMENT_ID_FIELD, VERSION_ID_FIELD, PARENT_ID_FIELD, THREAD_ID_FIELD, TEXT_FIELD, VISIBILITY_FIELD,
            NOTIFY_COLLABORATORS_FIELD));

    private final String authenticationToken;

    private final String documentId;

    private final String versionId;

    private final String parentId;

    private final String threadId;

    private final String text;

    private final String visibility;

    private final Boolean notifyCollaborators;

    private CreateCommentRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.documentId = builder.documentId;
        this.versionId = builder.versionId;
        this.parentId = builder.parentId;
        this.threadId = builder.threadId;
        this.text = builder.text;
        this.visibility = builder.visibility;
        this.notifyCollaborators = builder.notifyCollaborators;
    }

    /**
     * <p>
     * Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.
     * </p>
     * 
     * @return Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the
     *         API.
     */
    public final String authenticationToken() {
        return authenticationToken;
    }

    /**
     * <p>
     * The ID of the document.
     * </p>
     * 
     * @return The ID of the document.
     */
    public final String documentId() {
        return documentId;
    }

    /**
     * <p>
     * The ID of the document version.
     * </p>
     * 
     * @return The ID of the document version.
     */
    public final String versionId() {
        return versionId;
    }

    /**
     * <p>
     * The ID of the parent comment.
     * </p>
     * 
     * @return The ID of the parent comment.
     */
    public final String parentId() {
        return parentId;
    }

    /**
     * <p>
     * The ID of the root comment in the thread.
     * </p>
     * 
     * @return The ID of the root comment in the thread.
     */
    public final String threadId() {
        return threadId;
    }

    /**
     * <p>
     * The text of the comment.
     * </p>
     * 
     * @return The text of the comment.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * The visibility of the comment. Options are either PRIVATE, where the comment is visible only to the comment
     * author and document owner and co-owners, or PUBLIC, where the comment is visible to document owners, co-owners,
     * and contributors.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link CommentVisibilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of the comment. Options are either PRIVATE, where the comment is visible only to the
     *         comment author and document owner and co-owners, or PUBLIC, where the comment is visible to document
     *         owners, co-owners, and contributors.
     * @see CommentVisibilityType
     */
    public final CommentVisibilityType visibility() {
        return CommentVisibilityType.fromValue(visibility);
    }

    /**
     * <p>
     * The visibility of the comment. Options are either PRIVATE, where the comment is visible only to the comment
     * author and document owner and co-owners, or PUBLIC, where the comment is visible to document owners, co-owners,
     * and contributors.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #visibility} will
     * return {@link CommentVisibilityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #visibilityAsString}.
     * </p>
     * 
     * @return The visibility of the comment. Options are either PRIVATE, where the comment is visible only to the
     *         comment author and document owner and co-owners, or PUBLIC, where the comment is visible to document
     *         owners, co-owners, and contributors.
     * @see CommentVisibilityType
     */
    public final String visibilityAsString() {
        return visibility;
    }

    /**
     * <p>
     * Set this parameter to TRUE to send an email out to the document collaborators after the comment is created.
     * </p>
     * 
     * @return Set this parameter to TRUE to send an email out to the document collaborators after the comment is
     *         created.
     */
    public final Boolean notifyCollaborators() {
        return notifyCollaborators;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(documentId());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(parentId());
        hashCode = 31 * hashCode + Objects.hashCode(threadId());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(notifyCollaborators());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCommentRequest)) {
            return false;
        }
        CreateCommentRequest other = (CreateCommentRequest) obj;
        return Objects.equals(authenticationToken(), other.authenticationToken())
                && Objects.equals(documentId(), other.documentId()) && Objects.equals(versionId(), other.versionId())
                && Objects.equals(parentId(), other.parentId()) && Objects.equals(threadId(), other.threadId())
                && Objects.equals(text(), other.text()) && Objects.equals(visibilityAsString(), other.visibilityAsString())
                && Objects.equals(notifyCollaborators(), other.notifyCollaborators());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCommentRequest")
                .add("AuthenticationToken", authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DocumentId", documentId()).add("VersionId", versionId()).add("ParentId", parentId())
                .add("ThreadId", threadId()).add("Text", text() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Visibility", visibilityAsString()).add("NotifyCollaborators", notifyCollaborators()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationToken":
            return Optional.ofNullable(clazz.cast(authenticationToken()));
        case "DocumentId":
            return Optional.ofNullable(clazz.cast(documentId()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        case "ParentId":
            return Optional.ofNullable(clazz.cast(parentId()));
        case "ThreadId":
            return Optional.ofNullable(clazz.cast(threadId()));
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        case "Visibility":
            return Optional.ofNullable(clazz.cast(visibilityAsString()));
        case "NotifyCollaborators":
            return Optional.ofNullable(clazz.cast(notifyCollaborators()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCommentRequest, T> g) {
        return obj -> g.apply((CreateCommentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkDocsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCommentRequest> {
        /**
         * <p>
         * Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the
         * API.
         * </p>
         * 
         * @param authenticationToken
         *        Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access
         *        the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationToken(String authenticationToken);

        /**
         * <p>
         * The ID of the document.
         * </p>
         * 
         * @param documentId
         *        The ID of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentId(String documentId);

        /**
         * <p>
         * The ID of the document version.
         * </p>
         * 
         * @param versionId
         *        The ID of the document version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * <p>
         * The ID of the parent comment.
         * </p>
         * 
         * @param parentId
         *        The ID of the parent comment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentId(String parentId);

        /**
         * <p>
         * The ID of the root comment in the thread.
         * </p>
         * 
         * @param threadId
         *        The ID of the root comment in the thread.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threadId(String threadId);

        /**
         * <p>
         * The text of the comment.
         * </p>
         * 
         * @param text
         *        The text of the comment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * The visibility of the comment. Options are either PRIVATE, where the comment is visible only to the comment
         * author and document owner and co-owners, or PUBLIC, where the comment is visible to document owners,
         * co-owners, and contributors.
         * </p>
         * 
         * @param visibility
         *        The visibility of the comment. Options are either PRIVATE, where the comment is visible only to the
         *        comment author and document owner and co-owners, or PUBLIC, where the comment is visible to document
         *        owners, co-owners, and contributors.
         * @see CommentVisibilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommentVisibilityType
         */
        Builder visibility(String visibility);

        /**
         * <p>
         * The visibility of the comment. Options are either PRIVATE, where the comment is visible only to the comment
         * author and document owner and co-owners, or PUBLIC, where the comment is visible to document owners,
         * co-owners, and contributors.
         * </p>
         * 
         * @param visibility
         *        The visibility of the comment. Options are either PRIVATE, where the comment is visible only to the
         *        comment author and document owner and co-owners, or PUBLIC, where the comment is visible to document
         *        owners, co-owners, and contributors.
         * @see CommentVisibilityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommentVisibilityType
         */
        Builder visibility(CommentVisibilityType visibility);

        /**
         * <p>
         * Set this parameter to TRUE to send an email out to the document collaborators after the comment is created.
         * </p>
         * 
         * @param notifyCollaborators
         *        Set this parameter to TRUE to send an email out to the document collaborators after the comment is
         *        created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notifyCollaborators(Boolean notifyCollaborators);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkDocsRequest.BuilderImpl implements Builder {
        private String authenticationToken;

        private String documentId;

        private String versionId;

        private String parentId;

        private String threadId;

        private String text;

        private String visibility;

        private Boolean notifyCollaborators;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCommentRequest model) {
            super(model);
            authenticationToken(model.authenticationToken);
            documentId(model.documentId);
            versionId(model.versionId);
            parentId(model.parentId);
            threadId(model.threadId);
            text(model.text);
            visibility(model.visibility);
            notifyCollaborators(model.notifyCollaborators);
        }

        public final String getAuthenticationToken() {
            return authenticationToken;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        @Override
        @Transient
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final String getDocumentId() {
            return documentId;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        @Override
        @Transient
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final String getVersionId() {
            return versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        @Transient
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final String getParentId() {
            return parentId;
        }

        public final void setParentId(String parentId) {
            this.parentId = parentId;
        }

        @Override
        @Transient
        public final Builder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public final String getThreadId() {
            return threadId;
        }

        public final void setThreadId(String threadId) {
            this.threadId = threadId;
        }

        @Override
        @Transient
        public final Builder threadId(String threadId) {
            this.threadId = threadId;
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        @Transient
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getVisibility() {
            return visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        @Transient
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        @Transient
        public final Builder visibility(CommentVisibilityType visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final Boolean getNotifyCollaborators() {
            return notifyCollaborators;
        }

        public final void setNotifyCollaborators(Boolean notifyCollaborators) {
            this.notifyCollaborators = notifyCollaborators;
        }

        @Override
        @Transient
        public final Builder notifyCollaborators(Boolean notifyCollaborators) {
            this.notifyCollaborators = notifyCollaborators;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCommentRequest build() {
            return new CreateCommentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
