/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNotificationSubscriptionRequest extends WorkDocsRequest implements
        ToCopyableBuilder<CreateNotificationSubscriptionRequest.Builder, CreateNotificationSubscriptionRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationId").getter(getter(CreateNotificationSubscriptionRequest::organizationId))
            .setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("OrganizationId").build()).build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Endpoint").getter(getter(CreateNotificationSubscriptionRequest::endpoint))
            .setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(CreateNotificationSubscriptionRequest::protocolAsString))
            .setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<String> SUBSCRIPTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionType").getter(getter(CreateNotificationSubscriptionRequest::subscriptionTypeAsString))
            .setter(setter(Builder::subscriptionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD,
            ENDPOINT_FIELD, PROTOCOL_FIELD, SUBSCRIPTION_TYPE_FIELD));

    private final String organizationId;

    private final String endpoint;

    private final String protocol;

    private final String subscriptionType;

    private CreateNotificationSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.endpoint = builder.endpoint;
        this.protocol = builder.protocol;
        this.subscriptionType = builder.subscriptionType;
    }

    /**
     * <p>
     * The ID of the organization.
     * </p>
     * 
     * @return The ID of the organization.
     */
    public final String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * The endpoint to receive the notifications. If the protocol is HTTPS, the endpoint is a URL that begins with
     * <code>https</code>.
     * </p>
     * 
     * @return The endpoint to receive the notifications. If the protocol is HTTPS, the endpoint is a URL that begins
     *         with <code>https</code>.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The protocol to use. The supported value is https, which delivers JSON-encoded messages using HTTPS POST.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link SubscriptionProtocolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol to use. The supported value is https, which delivers JSON-encoded messages using HTTPS POST.
     * @see SubscriptionProtocolType
     */
    public final SubscriptionProtocolType protocol() {
        return SubscriptionProtocolType.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol to use. The supported value is https, which delivers JSON-encoded messages using HTTPS POST.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link SubscriptionProtocolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol to use. The supported value is https, which delivers JSON-encoded messages using HTTPS POST.
     * @see SubscriptionProtocolType
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * The notification type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #subscriptionType}
     * will return {@link SubscriptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #subscriptionTypeAsString}.
     * </p>
     * 
     * @return The notification type.
     * @see SubscriptionType
     */
    public final SubscriptionType subscriptionType() {
        return SubscriptionType.fromValue(subscriptionType);
    }

    /**
     * <p>
     * The notification type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #subscriptionType}
     * will return {@link SubscriptionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #subscriptionTypeAsString}.
     * </p>
     * 
     * @return The notification type.
     * @see SubscriptionType
     */
    public final String subscriptionTypeAsString() {
        return subscriptionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNotificationSubscriptionRequest)) {
            return false;
        }
        CreateNotificationSubscriptionRequest other = (CreateNotificationSubscriptionRequest) obj;
        return Objects.equals(organizationId(), other.organizationId()) && Objects.equals(endpoint(), other.endpoint())
                && Objects.equals(protocolAsString(), other.protocolAsString())
                && Objects.equals(subscriptionTypeAsString(), other.subscriptionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateNotificationSubscriptionRequest").add("OrganizationId", organizationId())
                .add("Endpoint", endpoint()).add("Protocol", protocolAsString())
                .add("SubscriptionType", subscriptionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "SubscriptionType":
            return Optional.ofNullable(clazz.cast(subscriptionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNotificationSubscriptionRequest, T> g) {
        return obj -> g.apply((CreateNotificationSubscriptionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkDocsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateNotificationSubscriptionRequest> {
        /**
         * <p>
         * The ID of the organization.
         * </p>
         * 
         * @param organizationId
         *        The ID of the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * The endpoint to receive the notifications. If the protocol is HTTPS, the endpoint is a URL that begins with
         * <code>https</code>.
         * </p>
         * 
         * @param endpoint
         *        The endpoint to receive the notifications. If the protocol is HTTPS, the endpoint is a URL that begins
         *        with <code>https</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * The protocol to use. The supported value is https, which delivers JSON-encoded messages using HTTPS POST.
         * </p>
         * 
         * @param protocol
         *        The protocol to use. The supported value is https, which delivers JSON-encoded messages using HTTPS
         *        POST.
         * @see SubscriptionProtocolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionProtocolType
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol to use. The supported value is https, which delivers JSON-encoded messages using HTTPS POST.
         * </p>
         * 
         * @param protocol
         *        The protocol to use. The supported value is https, which delivers JSON-encoded messages using HTTPS
         *        POST.
         * @see SubscriptionProtocolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionProtocolType
         */
        Builder protocol(SubscriptionProtocolType protocol);

        /**
         * <p>
         * The notification type.
         * </p>
         * 
         * @param subscriptionType
         *        The notification type.
         * @see SubscriptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionType
         */
        Builder subscriptionType(String subscriptionType);

        /**
         * <p>
         * The notification type.
         * </p>
         * 
         * @param subscriptionType
         *        The notification type.
         * @see SubscriptionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionType
         */
        Builder subscriptionType(SubscriptionType subscriptionType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkDocsRequest.BuilderImpl implements Builder {
        private String organizationId;

        private String endpoint;

        private String protocol;

        private String subscriptionType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNotificationSubscriptionRequest model) {
            super(model);
            organizationId(model.organizationId);
            endpoint(model.endpoint);
            protocol(model.protocol);
            subscriptionType(model.subscriptionType);
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        @Transient
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        @Transient
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        @Transient
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        @Transient
        public final Builder protocol(SubscriptionProtocolType protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getSubscriptionType() {
            return subscriptionType;
        }

        public final void setSubscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
        }

        @Override
        @Transient
        public final Builder subscriptionType(String subscriptionType) {
            this.subscriptionType = subscriptionType;
            return this;
        }

        @Override
        @Transient
        public final Builder subscriptionType(SubscriptionType subscriptionType) {
            this.subscriptionType(subscriptionType == null ? null : subscriptionType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNotificationSubscriptionRequest build() {
            return new CreateNotificationSubscriptionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
