/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNotificationSubscriptionResponse extends WorkDocsResponse implements
        ToCopyableBuilder<CreateNotificationSubscriptionResponse.Builder, CreateNotificationSubscriptionResponse> {
    private static final SdkField<Subscription> SUBSCRIPTION_FIELD = SdkField.<Subscription> builder(MarshallingType.SDK_POJO)
            .memberName("Subscription").getter(getter(CreateNotificationSubscriptionResponse::subscription))
            .setter(setter(Builder::subscription)).constructor(Subscription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subscription").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_FIELD));

    private final Subscription subscription;

    private CreateNotificationSubscriptionResponse(BuilderImpl builder) {
        super(builder);
        this.subscription = builder.subscription;
    }

    /**
     * <p>
     * The subscription.
     * </p>
     * 
     * @return The subscription.
     */
    public final Subscription subscription() {
        return subscription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subscription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNotificationSubscriptionResponse)) {
            return false;
        }
        CreateNotificationSubscriptionResponse other = (CreateNotificationSubscriptionResponse) obj;
        return Objects.equals(subscription(), other.subscription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateNotificationSubscriptionResponse").add("Subscription", subscription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Subscription":
            return Optional.ofNullable(clazz.cast(subscription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNotificationSubscriptionResponse, T> g) {
        return obj -> g.apply((CreateNotificationSubscriptionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkDocsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateNotificationSubscriptionResponse> {
        /**
         * <p>
         * The subscription.
         * </p>
         * 
         * @param subscription
         *        The subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscription(Subscription subscription);

        /**
         * <p>
         * The subscription.
         * </p>
         * This is a convenience that creates an instance of the {@link Subscription.Builder} avoiding the need to
         * create one manually via {@link Subscription#builder()}.
         *
         * When the {@link Consumer} completes, {@link Subscription.Builder#build()} is called immediately and its
         * result is passed to {@link #subscription(Subscription)}.
         * 
         * @param subscription
         *        a consumer that will call methods on {@link Subscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subscription(Subscription)
         */
        default Builder subscription(Consumer<Subscription.Builder> subscription) {
            return subscription(Subscription.builder().applyMutation(subscription).build());
        }
    }

    static final class BuilderImpl extends WorkDocsResponse.BuilderImpl implements Builder {
        private Subscription subscription;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNotificationSubscriptionResponse model) {
            super(model);
            subscription(model.subscription);
        }

        public final Subscription.Builder getSubscription() {
            return subscription != null ? subscription.toBuilder() : null;
        }

        public final void setSubscription(Subscription.BuilderImpl subscription) {
            this.subscription = subscription != null ? subscription.build() : null;
        }

        @Override
        @Transient
        public final Builder subscription(Subscription subscription) {
            this.subscription = subscription;
            return this;
        }

        @Override
        public CreateNotificationSubscriptionResponse build() {
            return new CreateNotificationSubscriptionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
