/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDocumentVersionsRequest extends WorkDocsRequest implements
        ToCopyableBuilder<DescribeDocumentVersionsRequest.Builder, DescribeDocumentVersionsRequest> {
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationToken").getter(getter(DescribeDocumentVersionsRequest::authenticationToken))
            .setter(setter(Builder::authenticationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()).build();

    private static final SdkField<String> DOCUMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentId").getter(getter(DescribeDocumentVersionsRequest::documentId))
            .setter(setter(Builder::documentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DocumentId").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeDocumentVersionsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("marker").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(DescribeDocumentVersionsRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()).build();

    private static final SdkField<String> INCLUDE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Include")
            .getter(getter(DescribeDocumentVersionsRequest::include)).setter(setter(Builder::include))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("include").build()).build();

    private static final SdkField<String> FIELDS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Fields")
            .getter(getter(DescribeDocumentVersionsRequest::fields)).setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("fields").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TOKEN_FIELD,
            DOCUMENT_ID_FIELD, MARKER_FIELD, LIMIT_FIELD, INCLUDE_FIELD, FIELDS_FIELD));

    private final String authenticationToken;

    private final String documentId;

    private final String marker;

    private final Integer limit;

    private final String include;

    private final String fields;

    private DescribeDocumentVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.documentId = builder.documentId;
        this.marker = builder.marker;
        this.limit = builder.limit;
        this.include = builder.include;
        this.fields = builder.fields;
    }

    /**
     * <p>
     * Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.
     * </p>
     * 
     * @return Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the
     *         API.
     */
    public final String authenticationToken() {
        return authenticationToken;
    }

    /**
     * <p>
     * The ID of the document.
     * </p>
     * 
     * @return The ID of the document.
     */
    public final String documentId() {
        return documentId;
    }

    /**
     * <p>
     * The marker for the next set of results. (You received this marker from a previous call.)
     * </p>
     * 
     * @return The marker for the next set of results. (You received this marker from a previous call.)
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of versions to return with this call.
     * </p>
     * 
     * @return The maximum number of versions to return with this call.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * A comma-separated list of values. Specify "INITIALIZED" to include incomplete versions.
     * </p>
     * 
     * @return A comma-separated list of values. Specify "INITIALIZED" to include incomplete versions.
     */
    public final String include() {
        return include;
    }

    /**
     * <p>
     * Specify "SOURCE" to include initialized versions and a URL for the source document.
     * </p>
     * 
     * @return Specify "SOURCE" to include initialized versions and a URL for the source document.
     */
    public final String fields() {
        return fields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(documentId());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(include());
        hashCode = 31 * hashCode + Objects.hashCode(fields());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDocumentVersionsRequest)) {
            return false;
        }
        DescribeDocumentVersionsRequest other = (DescribeDocumentVersionsRequest) obj;
        return Objects.equals(authenticationToken(), other.authenticationToken())
                && Objects.equals(documentId(), other.documentId()) && Objects.equals(marker(), other.marker())
                && Objects.equals(limit(), other.limit()) && Objects.equals(include(), other.include())
                && Objects.equals(fields(), other.fields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDocumentVersionsRequest")
                .add("AuthenticationToken", authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DocumentId", documentId()).add("Marker", marker()).add("Limit", limit()).add("Include", include())
                .add("Fields", fields()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationToken":
            return Optional.ofNullable(clazz.cast(authenticationToken()));
        case "DocumentId":
            return Optional.ofNullable(clazz.cast(documentId()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "Include":
            return Optional.ofNullable(clazz.cast(include()));
        case "Fields":
            return Optional.ofNullable(clazz.cast(fields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDocumentVersionsRequest, T> g) {
        return obj -> g.apply((DescribeDocumentVersionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkDocsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDocumentVersionsRequest> {
        /**
         * <p>
         * Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the
         * API.
         * </p>
         * 
         * @param authenticationToken
         *        Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access
         *        the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationToken(String authenticationToken);

        /**
         * <p>
         * The ID of the document.
         * </p>
         * 
         * @param documentId
         *        The ID of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentId(String documentId);

        /**
         * <p>
         * The marker for the next set of results. (You received this marker from a previous call.)
         * </p>
         * 
         * @param marker
         *        The marker for the next set of results. (You received this marker from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of versions to return with this call.
         * </p>
         * 
         * @param limit
         *        The maximum number of versions to return with this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * A comma-separated list of values. Specify "INITIALIZED" to include incomplete versions.
         * </p>
         * 
         * @param include
         *        A comma-separated list of values. Specify "INITIALIZED" to include incomplete versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder include(String include);

        /**
         * <p>
         * Specify "SOURCE" to include initialized versions and a URL for the source document.
         * </p>
         * 
         * @param fields
         *        Specify "SOURCE" to include initialized versions and a URL for the source document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(String fields);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkDocsRequest.BuilderImpl implements Builder {
        private String authenticationToken;

        private String documentId;

        private String marker;

        private Integer limit;

        private String include;

        private String fields;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDocumentVersionsRequest model) {
            super(model);
            authenticationToken(model.authenticationToken);
            documentId(model.documentId);
            marker(model.marker);
            limit(model.limit);
            include(model.include);
            fields(model.fields);
        }

        public final String getAuthenticationToken() {
            return authenticationToken;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        @Override
        @Transient
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final String getDocumentId() {
            return documentId;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        @Override
        @Transient
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        @Transient
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getInclude() {
            return include;
        }

        public final void setInclude(String include) {
            this.include = include;
        }

        @Override
        @Transient
        public final Builder include(String include) {
            this.include = include;
            return this;
        }

        public final String getFields() {
            return fields;
        }

        public final void setFields(String fields) {
            this.fields = fields;
        }

        @Override
        @Transient
        public final Builder fields(String fields) {
            this.fields = fields;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDocumentVersionsRequest build() {
            return new DescribeDocumentVersionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
