/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFolderContentsResponse extends WorkDocsResponse implements
        ToCopyableBuilder<DescribeFolderContentsResponse.Builder, DescribeFolderContentsResponse> {
    private static final SdkField<List<FolderMetadata>> FOLDERS_FIELD = SdkField
            .<List<FolderMetadata>> builder(MarshallingType.LIST)
            .memberName("Folders")
            .getter(getter(DescribeFolderContentsResponse::folders))
            .setter(setter(Builder::folders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Folders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FolderMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(FolderMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DocumentMetadata>> DOCUMENTS_FIELD = SdkField
            .<List<DocumentMetadata>> builder(MarshallingType.LIST)
            .memberName("Documents")
            .getter(getter(DescribeFolderContentsResponse::documents))
            .setter(setter(Builder::documents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Documents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeFolderContentsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FOLDERS_FIELD,
            DOCUMENTS_FIELD, MARKER_FIELD));

    private final List<FolderMetadata> folders;

    private final List<DocumentMetadata> documents;

    private final String marker;

    private DescribeFolderContentsResponse(BuilderImpl builder) {
        super(builder);
        this.folders = builder.folders;
        this.documents = builder.documents;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the Folders property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFolders() {
        return folders != null && !(folders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The subfolders in the specified folder.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFolders} method.
     * </p>
     * 
     * @return The subfolders in the specified folder.
     */
    public final List<FolderMetadata> folders() {
        return folders;
    }

    /**
     * For responses, this returns true if the service returned a value for the Documents property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDocuments() {
        return documents != null && !(documents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The documents in the specified folder.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDocuments} method.
     * </p>
     * 
     * @return The documents in the specified folder.
     */
    public final List<DocumentMetadata> documents() {
        return documents;
    }

    /**
     * <p>
     * The marker to use when requesting the next set of results. If there are no additional results, the string is
     * empty.
     * </p>
     * 
     * @return The marker to use when requesting the next set of results. If there are no additional results, the string
     *         is empty.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFolders() ? folders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDocuments() ? documents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFolderContentsResponse)) {
            return false;
        }
        DescribeFolderContentsResponse other = (DescribeFolderContentsResponse) obj;
        return hasFolders() == other.hasFolders() && Objects.equals(folders(), other.folders())
                && hasDocuments() == other.hasDocuments() && Objects.equals(documents(), other.documents())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFolderContentsResponse").add("Folders", hasFolders() ? folders() : null)
                .add("Documents", hasDocuments() ? documents() : null).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Folders":
            return Optional.ofNullable(clazz.cast(folders()));
        case "Documents":
            return Optional.ofNullable(clazz.cast(documents()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFolderContentsResponse, T> g) {
        return obj -> g.apply((DescribeFolderContentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkDocsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFolderContentsResponse> {
        /**
         * <p>
         * The subfolders in the specified folder.
         * </p>
         * 
         * @param folders
         *        The subfolders in the specified folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folders(Collection<FolderMetadata> folders);

        /**
         * <p>
         * The subfolders in the specified folder.
         * </p>
         * 
         * @param folders
         *        The subfolders in the specified folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folders(FolderMetadata... folders);

        /**
         * <p>
         * The subfolders in the specified folder.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FolderMetadata>.Builder} avoiding the need
         * to create one manually via {@link List<FolderMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FolderMetadata>.Builder#build()} is called immediately and
         * its result is passed to {@link #folders(List<FolderMetadata>)}.
         * 
         * @param folders
         *        a consumer that will call methods on {@link List<FolderMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #folders(List<FolderMetadata>)
         */
        Builder folders(Consumer<FolderMetadata.Builder>... folders);

        /**
         * <p>
         * The documents in the specified folder.
         * </p>
         * 
         * @param documents
         *        The documents in the specified folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documents(Collection<DocumentMetadata> documents);

        /**
         * <p>
         * The documents in the specified folder.
         * </p>
         * 
         * @param documents
         *        The documents in the specified folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documents(DocumentMetadata... documents);

        /**
         * <p>
         * The documents in the specified folder.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DocumentMetadata>.Builder} avoiding the
         * need to create one manually via {@link List<DocumentMetadata>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DocumentMetadata>.Builder#build()} is called immediately and
         * its result is passed to {@link #documents(List<DocumentMetadata>)}.
         * 
         * @param documents
         *        a consumer that will call methods on {@link List<DocumentMetadata>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documents(List<DocumentMetadata>)
         */
        Builder documents(Consumer<DocumentMetadata.Builder>... documents);

        /**
         * <p>
         * The marker to use when requesting the next set of results. If there are no additional results, the string is
         * empty.
         * </p>
         * 
         * @param marker
         *        The marker to use when requesting the next set of results. If there are no additional results, the
         *        string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends WorkDocsResponse.BuilderImpl implements Builder {
        private List<FolderMetadata> folders = DefaultSdkAutoConstructList.getInstance();

        private List<DocumentMetadata> documents = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFolderContentsResponse model) {
            super(model);
            folders(model.folders);
            documents(model.documents);
            marker(model.marker);
        }

        public final List<FolderMetadata.Builder> getFolders() {
            List<FolderMetadata.Builder> result = FolderMetadataListCopier.copyToBuilder(this.folders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFolders(Collection<FolderMetadata.BuilderImpl> folders) {
            this.folders = FolderMetadataListCopier.copyFromBuilder(folders);
        }

        @Override
        @Transient
        public final Builder folders(Collection<FolderMetadata> folders) {
            this.folders = FolderMetadataListCopier.copy(folders);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder folders(FolderMetadata... folders) {
            folders(Arrays.asList(folders));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder folders(Consumer<FolderMetadata.Builder>... folders) {
            folders(Stream.of(folders).map(c -> FolderMetadata.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DocumentMetadata.Builder> getDocuments() {
            List<DocumentMetadata.Builder> result = DocumentMetadataListCopier.copyToBuilder(this.documents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocuments(Collection<DocumentMetadata.BuilderImpl> documents) {
            this.documents = DocumentMetadataListCopier.copyFromBuilder(documents);
        }

        @Override
        @Transient
        public final Builder documents(Collection<DocumentMetadata> documents) {
            this.documents = DocumentMetadataListCopier.copy(documents);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder documents(DocumentMetadata... documents) {
            documents(Arrays.asList(documents));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder documents(Consumer<DocumentMetadata.Builder>... documents) {
            documents(Stream.of(documents).map(c -> DocumentMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeFolderContentsResponse build() {
            return new DescribeFolderContentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
