/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFolderResponse extends WorkDocsResponse implements
        ToCopyableBuilder<GetFolderResponse.Builder, GetFolderResponse> {
    private static final SdkField<FolderMetadata> METADATA_FIELD = SdkField.<FolderMetadata> builder(MarshallingType.SDK_POJO)
            .memberName("Metadata").getter(getter(GetFolderResponse::metadata)).setter(setter(Builder::metadata))
            .constructor(FolderMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final SdkField<Map<String, String>> CUSTOM_METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("CustomMetadata")
            .getter(getter(GetFolderResponse::customMetadata))
            .setter(setter(Builder::customMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomMetadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_FIELD,
            CUSTOM_METADATA_FIELD));

    private final FolderMetadata metadata;

    private final Map<String, String> customMetadata;

    private GetFolderResponse(BuilderImpl builder) {
        super(builder);
        this.metadata = builder.metadata;
        this.customMetadata = builder.customMetadata;
    }

    /**
     * <p>
     * The metadata of the folder.
     * </p>
     * 
     * @return The metadata of the folder.
     */
    public final FolderMetadata metadata() {
        return metadata;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomMetadata property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomMetadata() {
        return customMetadata != null && !(customMetadata instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The custom metadata on the folder.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomMetadata} method.
     * </p>
     * 
     * @return The custom metadata on the folder.
     */
    public final Map<String, String> customMetadata() {
        return customMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomMetadata() ? customMetadata() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFolderResponse)) {
            return false;
        }
        GetFolderResponse other = (GetFolderResponse) obj;
        return Objects.equals(metadata(), other.metadata()) && hasCustomMetadata() == other.hasCustomMetadata()
                && Objects.equals(customMetadata(), other.customMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFolderResponse").add("Metadata", metadata())
                .add("CustomMetadata", hasCustomMetadata() ? customMetadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "CustomMetadata":
            return Optional.ofNullable(clazz.cast(customMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFolderResponse, T> g) {
        return obj -> g.apply((GetFolderResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkDocsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetFolderResponse> {
        /**
         * <p>
         * The metadata of the folder.
         * </p>
         * 
         * @param metadata
         *        The metadata of the folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(FolderMetadata metadata);

        /**
         * <p>
         * The metadata of the folder.
         * </p>
         * This is a convenience that creates an instance of the {@link FolderMetadata.Builder} avoiding the need to
         * create one manually via {@link FolderMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link FolderMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #metadata(FolderMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link FolderMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(FolderMetadata)
         */
        default Builder metadata(Consumer<FolderMetadata.Builder> metadata) {
            return metadata(FolderMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * The custom metadata on the folder.
         * </p>
         * 
         * @param customMetadata
         *        The custom metadata on the folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customMetadata(Map<String, String> customMetadata);
    }

    static final class BuilderImpl extends WorkDocsResponse.BuilderImpl implements Builder {
        private FolderMetadata metadata;

        private Map<String, String> customMetadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetFolderResponse model) {
            super(model);
            metadata(model.metadata);
            customMetadata(model.customMetadata);
        }

        public final FolderMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(FolderMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        @Transient
        public final Builder metadata(FolderMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final Map<String, String> getCustomMetadata() {
            if (customMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return customMetadata;
        }

        public final void setCustomMetadata(Map<String, String> customMetadata) {
            this.customMetadata = CustomMetadataMapCopier.copy(customMetadata);
        }

        @Override
        @Transient
        public final Builder customMetadata(Map<String, String> customMetadata) {
            this.customMetadata = CustomMetadataMapCopier.copy(customMetadata);
            return this;
        }

        @Override
        public GetFolderResponse build() {
            return new GetFolderResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
