/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InitiateDocumentVersionUploadRequest extends WorkDocsRequest implements
        ToCopyableBuilder<InitiateDocumentVersionUploadRequest.Builder, InitiateDocumentVersionUploadRequest> {
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationToken").getter(getter(InitiateDocumentVersionUploadRequest::authenticationToken))
            .setter(setter(Builder::authenticationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(InitiateDocumentVersionUploadRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(InitiateDocumentVersionUploadRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Instant> CONTENT_CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ContentCreatedTimestamp").getter(getter(InitiateDocumentVersionUploadRequest::contentCreatedTimestamp))
            .setter(setter(Builder::contentCreatedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentCreatedTimestamp").build())
            .build();

    private static final SdkField<Instant> CONTENT_MODIFIED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ContentModifiedTimestamp")
            .getter(getter(InitiateDocumentVersionUploadRequest::contentModifiedTimestamp))
            .setter(setter(Builder::contentModifiedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentModifiedTimestamp").build())
            .build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(InitiateDocumentVersionUploadRequest::contentType))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()).build();

    private static final SdkField<Long> DOCUMENT_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DocumentSizeInBytes").getter(getter(InitiateDocumentVersionUploadRequest::documentSizeInBytes))
            .setter(setter(Builder::documentSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentSizeInBytes").build())
            .build();

    private static final SdkField<String> PARENT_FOLDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentFolderId").getter(getter(InitiateDocumentVersionUploadRequest::parentFolderId))
            .setter(setter(Builder::parentFolderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentFolderId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TOKEN_FIELD,
            ID_FIELD, NAME_FIELD, CONTENT_CREATED_TIMESTAMP_FIELD, CONTENT_MODIFIED_TIMESTAMP_FIELD, CONTENT_TYPE_FIELD,
            DOCUMENT_SIZE_IN_BYTES_FIELD, PARENT_FOLDER_ID_FIELD));

    private final String authenticationToken;

    private final String id;

    private final String name;

    private final Instant contentCreatedTimestamp;

    private final Instant contentModifiedTimestamp;

    private final String contentType;

    private final Long documentSizeInBytes;

    private final String parentFolderId;

    private InitiateDocumentVersionUploadRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.id = builder.id;
        this.name = builder.name;
        this.contentCreatedTimestamp = builder.contentCreatedTimestamp;
        this.contentModifiedTimestamp = builder.contentModifiedTimestamp;
        this.contentType = builder.contentType;
        this.documentSizeInBytes = builder.documentSizeInBytes;
        this.parentFolderId = builder.parentFolderId;
    }

    /**
     * <p>
     * Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the API.
     * </p>
     * 
     * @return Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the
     *         API.
     */
    public final String authenticationToken() {
        return authenticationToken;
    }

    /**
     * <p>
     * The ID of the document.
     * </p>
     * 
     * @return The ID of the document.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the document.
     * </p>
     * 
     * @return The name of the document.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The timestamp when the content of the document was originally created.
     * </p>
     * 
     * @return The timestamp when the content of the document was originally created.
     */
    public final Instant contentCreatedTimestamp() {
        return contentCreatedTimestamp;
    }

    /**
     * <p>
     * The timestamp when the content of the document was modified.
     * </p>
     * 
     * @return The timestamp when the content of the document was modified.
     */
    public final Instant contentModifiedTimestamp() {
        return contentModifiedTimestamp;
    }

    /**
     * <p>
     * The content type of the document.
     * </p>
     * 
     * @return The content type of the document.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * The size of the document, in bytes.
     * </p>
     * 
     * @return The size of the document, in bytes.
     */
    public final Long documentSizeInBytes() {
        return documentSizeInBytes;
    }

    /**
     * <p>
     * The ID of the parent folder.
     * </p>
     * 
     * @return The ID of the parent folder.
     */
    public final String parentFolderId() {
        return parentFolderId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(contentCreatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(contentModifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(documentSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(parentFolderId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitiateDocumentVersionUploadRequest)) {
            return false;
        }
        InitiateDocumentVersionUploadRequest other = (InitiateDocumentVersionUploadRequest) obj;
        return Objects.equals(authenticationToken(), other.authenticationToken()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name())
                && Objects.equals(contentCreatedTimestamp(), other.contentCreatedTimestamp())
                && Objects.equals(contentModifiedTimestamp(), other.contentModifiedTimestamp())
                && Objects.equals(contentType(), other.contentType())
                && Objects.equals(documentSizeInBytes(), other.documentSizeInBytes())
                && Objects.equals(parentFolderId(), other.parentFolderId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InitiateDocumentVersionUploadRequest")
                .add("AuthenticationToken", authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Id", id()).add("Name", name()).add("ContentCreatedTimestamp", contentCreatedTimestamp())
                .add("ContentModifiedTimestamp", contentModifiedTimestamp()).add("ContentType", contentType())
                .add("DocumentSizeInBytes", documentSizeInBytes()).add("ParentFolderId", parentFolderId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationToken":
            return Optional.ofNullable(clazz.cast(authenticationToken()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ContentCreatedTimestamp":
            return Optional.ofNullable(clazz.cast(contentCreatedTimestamp()));
        case "ContentModifiedTimestamp":
            return Optional.ofNullable(clazz.cast(contentModifiedTimestamp()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "DocumentSizeInBytes":
            return Optional.ofNullable(clazz.cast(documentSizeInBytes()));
        case "ParentFolderId":
            return Optional.ofNullable(clazz.cast(parentFolderId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InitiateDocumentVersionUploadRequest, T> g) {
        return obj -> g.apply((InitiateDocumentVersionUploadRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkDocsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, InitiateDocumentVersionUploadRequest> {
        /**
         * <p>
         * Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access the
         * API.
         * </p>
         * 
         * @param authenticationToken
         *        Amazon WorkDocs authentication token. Not required when using AWS administrator credentials to access
         *        the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationToken(String authenticationToken);

        /**
         * <p>
         * The ID of the document.
         * </p>
         * 
         * @param id
         *        The ID of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the document.
         * </p>
         * 
         * @param name
         *        The name of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The timestamp when the content of the document was originally created.
         * </p>
         * 
         * @param contentCreatedTimestamp
         *        The timestamp when the content of the document was originally created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentCreatedTimestamp(Instant contentCreatedTimestamp);

        /**
         * <p>
         * The timestamp when the content of the document was modified.
         * </p>
         * 
         * @param contentModifiedTimestamp
         *        The timestamp when the content of the document was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentModifiedTimestamp(Instant contentModifiedTimestamp);

        /**
         * <p>
         * The content type of the document.
         * </p>
         * 
         * @param contentType
         *        The content type of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The size of the document, in bytes.
         * </p>
         * 
         * @param documentSizeInBytes
         *        The size of the document, in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentSizeInBytes(Long documentSizeInBytes);

        /**
         * <p>
         * The ID of the parent folder.
         * </p>
         * 
         * @param parentFolderId
         *        The ID of the parent folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentFolderId(String parentFolderId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkDocsRequest.BuilderImpl implements Builder {
        private String authenticationToken;

        private String id;

        private String name;

        private Instant contentCreatedTimestamp;

        private Instant contentModifiedTimestamp;

        private String contentType;

        private Long documentSizeInBytes;

        private String parentFolderId;

        private BuilderImpl() {
        }

        private BuilderImpl(InitiateDocumentVersionUploadRequest model) {
            super(model);
            authenticationToken(model.authenticationToken);
            id(model.id);
            name(model.name);
            contentCreatedTimestamp(model.contentCreatedTimestamp);
            contentModifiedTimestamp(model.contentModifiedTimestamp);
            contentType(model.contentType);
            documentSizeInBytes(model.documentSizeInBytes);
            parentFolderId(model.parentFolderId);
        }

        public final String getAuthenticationToken() {
            return authenticationToken;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        @Override
        @Transient
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getContentCreatedTimestamp() {
            return contentCreatedTimestamp;
        }

        public final void setContentCreatedTimestamp(Instant contentCreatedTimestamp) {
            this.contentCreatedTimestamp = contentCreatedTimestamp;
        }

        @Override
        @Transient
        public final Builder contentCreatedTimestamp(Instant contentCreatedTimestamp) {
            this.contentCreatedTimestamp = contentCreatedTimestamp;
            return this;
        }

        public final Instant getContentModifiedTimestamp() {
            return contentModifiedTimestamp;
        }

        public final void setContentModifiedTimestamp(Instant contentModifiedTimestamp) {
            this.contentModifiedTimestamp = contentModifiedTimestamp;
        }

        @Override
        @Transient
        public final Builder contentModifiedTimestamp(Instant contentModifiedTimestamp) {
            this.contentModifiedTimestamp = contentModifiedTimestamp;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        @Transient
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final Long getDocumentSizeInBytes() {
            return documentSizeInBytes;
        }

        public final void setDocumentSizeInBytes(Long documentSizeInBytes) {
            this.documentSizeInBytes = documentSizeInBytes;
        }

        @Override
        @Transient
        public final Builder documentSizeInBytes(Long documentSizeInBytes) {
            this.documentSizeInBytes = documentSizeInBytes;
            return this;
        }

        public final String getParentFolderId() {
            return parentFolderId;
        }

        public final void setParentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
        }

        @Override
        @Transient
        public final Builder parentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InitiateDocumentVersionUploadRequest build() {
            return new InitiateDocumentVersionUploadRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
