/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the storage for a user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StorageRuleType implements SdkPojo, Serializable, ToCopyableBuilder<StorageRuleType.Builder, StorageRuleType> {
    private static final SdkField<Long> STORAGE_ALLOCATED_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("StorageAllocatedInBytes").getter(getter(StorageRuleType::storageAllocatedInBytes))
            .setter(setter(Builder::storageAllocatedInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageAllocatedInBytes").build())
            .build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(StorageRuleType::storageTypeAsString)).setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STORAGE_ALLOCATED_IN_BYTES_FIELD, STORAGE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long storageAllocatedInBytes;

    private final String storageType;

    private StorageRuleType(BuilderImpl builder) {
        this.storageAllocatedInBytes = builder.storageAllocatedInBytes;
        this.storageType = builder.storageType;
    }

    /**
     * <p>
     * The amount of storage allocated, in bytes.
     * </p>
     * 
     * @return The amount of storage allocated, in bytes.
     */
    public final Long storageAllocatedInBytes() {
        return storageAllocatedInBytes;
    }

    /**
     * <p>
     * The type of storage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link StorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return The type of storage.
     * @see StorageType
     */
    public final StorageType storageType() {
        return StorageType.fromValue(storageType);
    }

    /**
     * <p>
     * The type of storage.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link StorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return The type of storage.
     * @see StorageType
     */
    public final String storageTypeAsString() {
        return storageType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(storageAllocatedInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(storageTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageRuleType)) {
            return false;
        }
        StorageRuleType other = (StorageRuleType) obj;
        return Objects.equals(storageAllocatedInBytes(), other.storageAllocatedInBytes())
                && Objects.equals(storageTypeAsString(), other.storageTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StorageRuleType").add("StorageAllocatedInBytes", storageAllocatedInBytes())
                .add("StorageType", storageTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorageAllocatedInBytes":
            return Optional.ofNullable(clazz.cast(storageAllocatedInBytes()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StorageRuleType, T> g) {
        return obj -> g.apply((StorageRuleType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StorageRuleType> {
        /**
         * <p>
         * The amount of storage allocated, in bytes.
         * </p>
         * 
         * @param storageAllocatedInBytes
         *        The amount of storage allocated, in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageAllocatedInBytes(Long storageAllocatedInBytes);

        /**
         * <p>
         * The type of storage.
         * </p>
         * 
         * @param storageType
         *        The type of storage.
         * @see StorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageType
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The type of storage.
         * </p>
         * 
         * @param storageType
         *        The type of storage.
         * @see StorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageType
         */
        Builder storageType(StorageType storageType);
    }

    static final class BuilderImpl implements Builder {
        private Long storageAllocatedInBytes;

        private String storageType;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageRuleType model) {
            storageAllocatedInBytes(model.storageAllocatedInBytes);
            storageType(model.storageType);
        }

        public final Long getStorageAllocatedInBytes() {
            return storageAllocatedInBytes;
        }

        public final void setStorageAllocatedInBytes(Long storageAllocatedInBytes) {
            this.storageAllocatedInBytes = storageAllocatedInBytes;
        }

        @Override
        @Transient
        public final Builder storageAllocatedInBytes(Long storageAllocatedInBytes) {
            this.storageAllocatedInBytes = storageAllocatedInBytes;
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        @Transient
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        @Transient
        public final Builder storageType(StorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        @Override
        public StorageRuleType build() {
            return new StorageRuleType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
