/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentMetadata.Builder, DocumentMetadata> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(DocumentMetadata::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> CREATOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatorId").getter(getter(DocumentMetadata::creatorId)).setter(setter(Builder::creatorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorId").build()).build();

    private static final SdkField<String> PARENT_FOLDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentFolderId").getter(getter(DocumentMetadata::parentFolderId))
            .setter(setter(Builder::parentFolderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentFolderId").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(DocumentMetadata::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Instant> MODIFIED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ModifiedTimestamp").getter(getter(DocumentMetadata::modifiedTimestamp))
            .setter(setter(Builder::modifiedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedTimestamp").build()).build();

    private static final SdkField<DocumentVersionMetadata> LATEST_VERSION_METADATA_FIELD = SdkField
            .<DocumentVersionMetadata> builder(MarshallingType.SDK_POJO).memberName("LatestVersionMetadata")
            .getter(getter(DocumentMetadata::latestVersionMetadata)).setter(setter(Builder::latestVersionMetadata))
            .constructor(DocumentVersionMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersionMetadata").build())
            .build();

    private static final SdkField<String> RESOURCE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceState").getter(getter(DocumentMetadata::resourceStateAsString))
            .setter(setter(Builder::resourceState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceState").build()).build();

    private static final SdkField<List<String>> LABELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Labels")
            .getter(getter(DocumentMetadata::labels))
            .setter(setter(Builder::labels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Labels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, CREATOR_ID_FIELD,
            PARENT_FOLDER_ID_FIELD, CREATED_TIMESTAMP_FIELD, MODIFIED_TIMESTAMP_FIELD, LATEST_VERSION_METADATA_FIELD,
            RESOURCE_STATE_FIELD, LABELS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String creatorId;

    private final String parentFolderId;

    private final Instant createdTimestamp;

    private final Instant modifiedTimestamp;

    private final DocumentVersionMetadata latestVersionMetadata;

    private final String resourceState;

    private final List<String> labels;

    private DocumentMetadata(BuilderImpl builder) {
        this.id = builder.id;
        this.creatorId = builder.creatorId;
        this.parentFolderId = builder.parentFolderId;
        this.createdTimestamp = builder.createdTimestamp;
        this.modifiedTimestamp = builder.modifiedTimestamp;
        this.latestVersionMetadata = builder.latestVersionMetadata;
        this.resourceState = builder.resourceState;
        this.labels = builder.labels;
    }

    /**
     * <p>
     * The ID of the document.
     * </p>
     * 
     * @return The ID of the document.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ID of the creator.
     * </p>
     * 
     * @return The ID of the creator.
     */
    public final String creatorId() {
        return creatorId;
    }

    /**
     * <p>
     * The ID of the parent folder.
     * </p>
     * 
     * @return The ID of the parent folder.
     */
    public final String parentFolderId() {
        return parentFolderId;
    }

    /**
     * <p>
     * The time when the document was created.
     * </p>
     * 
     * @return The time when the document was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The time when the document was updated.
     * </p>
     * 
     * @return The time when the document was updated.
     */
    public final Instant modifiedTimestamp() {
        return modifiedTimestamp;
    }

    /**
     * <p>
     * The latest version of the document.
     * </p>
     * 
     * @return The latest version of the document.
     */
    public final DocumentVersionMetadata latestVersionMetadata() {
        return latestVersionMetadata;
    }

    /**
     * <p>
     * The resource state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceState}
     * will return {@link ResourceStateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceStateAsString}.
     * </p>
     * 
     * @return The resource state.
     * @see ResourceStateType
     */
    public final ResourceStateType resourceState() {
        return ResourceStateType.fromValue(resourceState);
    }

    /**
     * <p>
     * The resource state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceState}
     * will return {@link ResourceStateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceStateAsString}.
     * </p>
     * 
     * @return The resource state.
     * @see ResourceStateType
     */
    public final String resourceStateAsString() {
        return resourceState;
    }

    /**
     * For responses, this returns true if the service returned a value for the Labels property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLabels() {
        return labels != null && !(labels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of labels on the document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLabels} method.
     * </p>
     * 
     * @return List of labels on the document.
     */
    public final List<String> labels() {
        return labels;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(creatorId());
        hashCode = 31 * hashCode + Objects.hashCode(parentFolderId());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersionMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(resourceStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasLabels() ? labels() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentMetadata)) {
            return false;
        }
        DocumentMetadata other = (DocumentMetadata) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(creatorId(), other.creatorId())
                && Objects.equals(parentFolderId(), other.parentFolderId())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(modifiedTimestamp(), other.modifiedTimestamp())
                && Objects.equals(latestVersionMetadata(), other.latestVersionMetadata())
                && Objects.equals(resourceStateAsString(), other.resourceStateAsString()) && hasLabels() == other.hasLabels()
                && Objects.equals(labels(), other.labels());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentMetadata").add("Id", id()).add("CreatorId", creatorId())
                .add("ParentFolderId", parentFolderId()).add("CreatedTimestamp", createdTimestamp())
                .add("ModifiedTimestamp", modifiedTimestamp()).add("LatestVersionMetadata", latestVersionMetadata())
                .add("ResourceState", resourceStateAsString()).add("Labels", hasLabels() ? labels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "CreatorId":
            return Optional.ofNullable(clazz.cast(creatorId()));
        case "ParentFolderId":
            return Optional.ofNullable(clazz.cast(parentFolderId()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "ModifiedTimestamp":
            return Optional.ofNullable(clazz.cast(modifiedTimestamp()));
        case "LatestVersionMetadata":
            return Optional.ofNullable(clazz.cast(latestVersionMetadata()));
        case "ResourceState":
            return Optional.ofNullable(clazz.cast(resourceStateAsString()));
        case "Labels":
            return Optional.ofNullable(clazz.cast(labels()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentMetadata, T> g) {
        return obj -> g.apply((DocumentMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentMetadata> {
        /**
         * <p>
         * The ID of the document.
         * </p>
         * 
         * @param id
         *        The ID of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ID of the creator.
         * </p>
         * 
         * @param creatorId
         *        The ID of the creator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorId(String creatorId);

        /**
         * <p>
         * The ID of the parent folder.
         * </p>
         * 
         * @param parentFolderId
         *        The ID of the parent folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentFolderId(String parentFolderId);

        /**
         * <p>
         * The time when the document was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The time when the document was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The time when the document was updated.
         * </p>
         * 
         * @param modifiedTimestamp
         *        The time when the document was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedTimestamp(Instant modifiedTimestamp);

        /**
         * <p>
         * The latest version of the document.
         * </p>
         * 
         * @param latestVersionMetadata
         *        The latest version of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersionMetadata(DocumentVersionMetadata latestVersionMetadata);

        /**
         * <p>
         * The latest version of the document.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentVersionMetadata.Builder} avoiding
         * the need to create one manually via {@link DocumentVersionMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link DocumentVersionMetadata.Builder#build()} is called immediately
         * and its result is passed to {@link #latestVersionMetadata(DocumentVersionMetadata)}.
         * 
         * @param latestVersionMetadata
         *        a consumer that will call methods on {@link DocumentVersionMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestVersionMetadata(DocumentVersionMetadata)
         */
        default Builder latestVersionMetadata(Consumer<DocumentVersionMetadata.Builder> latestVersionMetadata) {
            return latestVersionMetadata(DocumentVersionMetadata.builder().applyMutation(latestVersionMetadata).build());
        }

        /**
         * <p>
         * The resource state.
         * </p>
         * 
         * @param resourceState
         *        The resource state.
         * @see ResourceStateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStateType
         */
        Builder resourceState(String resourceState);

        /**
         * <p>
         * The resource state.
         * </p>
         * 
         * @param resourceState
         *        The resource state.
         * @see ResourceStateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStateType
         */
        Builder resourceState(ResourceStateType resourceState);

        /**
         * <p>
         * List of labels on the document.
         * </p>
         * 
         * @param labels
         *        List of labels on the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(Collection<String> labels);

        /**
         * <p>
         * List of labels on the document.
         * </p>
         * 
         * @param labels
         *        List of labels on the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labels(String... labels);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String creatorId;

        private String parentFolderId;

        private Instant createdTimestamp;

        private Instant modifiedTimestamp;

        private DocumentVersionMetadata latestVersionMetadata;

        private String resourceState;

        private List<String> labels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentMetadata model) {
            id(model.id);
            creatorId(model.creatorId);
            parentFolderId(model.parentFolderId);
            createdTimestamp(model.createdTimestamp);
            modifiedTimestamp(model.modifiedTimestamp);
            latestVersionMetadata(model.latestVersionMetadata);
            resourceState(model.resourceState);
            labels(model.labels);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getCreatorId() {
            return creatorId;
        }

        public final void setCreatorId(String creatorId) {
            this.creatorId = creatorId;
        }

        @Override
        public final Builder creatorId(String creatorId) {
            this.creatorId = creatorId;
            return this;
        }

        public final String getParentFolderId() {
            return parentFolderId;
        }

        public final void setParentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
        }

        @Override
        public final Builder parentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getModifiedTimestamp() {
            return modifiedTimestamp;
        }

        public final void setModifiedTimestamp(Instant modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
        }

        @Override
        public final Builder modifiedTimestamp(Instant modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
            return this;
        }

        public final DocumentVersionMetadata.Builder getLatestVersionMetadata() {
            return latestVersionMetadata != null ? latestVersionMetadata.toBuilder() : null;
        }

        public final void setLatestVersionMetadata(DocumentVersionMetadata.BuilderImpl latestVersionMetadata) {
            this.latestVersionMetadata = latestVersionMetadata != null ? latestVersionMetadata.build() : null;
        }

        @Override
        public final Builder latestVersionMetadata(DocumentVersionMetadata latestVersionMetadata) {
            this.latestVersionMetadata = latestVersionMetadata;
            return this;
        }

        public final String getResourceState() {
            return resourceState;
        }

        public final void setResourceState(String resourceState) {
            this.resourceState = resourceState;
        }

        @Override
        public final Builder resourceState(String resourceState) {
            this.resourceState = resourceState;
            return this;
        }

        @Override
        public final Builder resourceState(ResourceStateType resourceState) {
            this.resourceState(resourceState == null ? null : resourceState.toString());
            return this;
        }

        public final Collection<String> getLabels() {
            if (labels instanceof SdkAutoConstructList) {
                return null;
            }
            return labels;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = SharedLabelsCopier.copy(labels);
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = SharedLabelsCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String... labels) {
            labels(Arrays.asList(labels));
            return this;
        }

        @Override
        public DocumentMetadata build() {
            return new DocumentMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
