/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFolderPathResponse extends WorkDocsResponse implements
        ToCopyableBuilder<GetFolderPathResponse.Builder, GetFolderPathResponse> {
    private static final SdkField<ResourcePath> PATH_FIELD = SdkField.<ResourcePath> builder(MarshallingType.SDK_POJO)
            .memberName("Path").getter(getter(GetFolderPathResponse::path)).setter(setter(Builder::path))
            .constructor(ResourcePath::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD));

    private final ResourcePath path;

    private GetFolderPathResponse(BuilderImpl builder) {
        super(builder);
        this.path = builder.path;
    }

    /**
     * <p>
     * The path information.
     * </p>
     * 
     * @return The path information.
     */
    public final ResourcePath path() {
        return path;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(path());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFolderPathResponse)) {
            return false;
        }
        GetFolderPathResponse other = (GetFolderPathResponse) obj;
        return Objects.equals(path(), other.path());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFolderPathResponse").add("Path", path()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFolderPathResponse, T> g) {
        return obj -> g.apply((GetFolderPathResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkDocsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetFolderPathResponse> {
        /**
         * <p>
         * The path information.
         * </p>
         * 
         * @param path
         *        The path information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(ResourcePath path);

        /**
         * <p>
         * The path information.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourcePath.Builder} avoiding the need
         * to create one manually via {@link ResourcePath#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourcePath.Builder#build()} is called immediately and its
         * result is passed to {@link #path(ResourcePath)}.
         * 
         * @param path
         *        a consumer that will call methods on {@link ResourcePath.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #path(ResourcePath)
         */
        default Builder path(Consumer<ResourcePath.Builder> path) {
            return path(ResourcePath.builder().applyMutation(path).build());
        }
    }

    static final class BuilderImpl extends WorkDocsResponse.BuilderImpl implements Builder {
        private ResourcePath path;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFolderPathResponse model) {
            super(model);
            path(model.path);
        }

        public final ResourcePath.Builder getPath() {
            return path != null ? path.toBuilder() : null;
        }

        public final void setPath(ResourcePath.BuilderImpl path) {
            this.path = path != null ? path.build() : null;
        }

        @Override
        public final Builder path(ResourcePath path) {
            this.path = path;
            return this;
        }

        @Override
        public GetFolderPathResponse build() {
            return new GetFolderPathResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
