/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InitiateDocumentVersionUploadResponse extends WorkDocsResponse implements
        ToCopyableBuilder<InitiateDocumentVersionUploadResponse.Builder, InitiateDocumentVersionUploadResponse> {
    private static final SdkField<DocumentMetadata> METADATA_FIELD = SdkField
            .<DocumentMetadata> builder(MarshallingType.SDK_POJO).memberName("Metadata")
            .getter(getter(InitiateDocumentVersionUploadResponse::metadata)).setter(setter(Builder::metadata))
            .constructor(DocumentMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final SdkField<UploadMetadata> UPLOAD_METADATA_FIELD = SdkField
            .<UploadMetadata> builder(MarshallingType.SDK_POJO).memberName("UploadMetadata")
            .getter(getter(InitiateDocumentVersionUploadResponse::uploadMetadata)).setter(setter(Builder::uploadMetadata))
            .constructor(UploadMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_FIELD,
            UPLOAD_METADATA_FIELD));

    private final DocumentMetadata metadata;

    private final UploadMetadata uploadMetadata;

    private InitiateDocumentVersionUploadResponse(BuilderImpl builder) {
        super(builder);
        this.metadata = builder.metadata;
        this.uploadMetadata = builder.uploadMetadata;
    }

    /**
     * <p>
     * The document metadata.
     * </p>
     * 
     * @return The document metadata.
     */
    public final DocumentMetadata metadata() {
        return metadata;
    }

    /**
     * <p>
     * The upload metadata.
     * </p>
     * 
     * @return The upload metadata.
     */
    public final UploadMetadata uploadMetadata() {
        return uploadMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(uploadMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitiateDocumentVersionUploadResponse)) {
            return false;
        }
        InitiateDocumentVersionUploadResponse other = (InitiateDocumentVersionUploadResponse) obj;
        return Objects.equals(metadata(), other.metadata()) && Objects.equals(uploadMetadata(), other.uploadMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InitiateDocumentVersionUploadResponse").add("Metadata", metadata())
                .add("UploadMetadata", uploadMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "UploadMetadata":
            return Optional.ofNullable(clazz.cast(uploadMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InitiateDocumentVersionUploadResponse, T> g) {
        return obj -> g.apply((InitiateDocumentVersionUploadResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkDocsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, InitiateDocumentVersionUploadResponse> {
        /**
         * <p>
         * The document metadata.
         * </p>
         * 
         * @param metadata
         *        The document metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(DocumentMetadata metadata);

        /**
         * <p>
         * The document metadata.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentMetadata.Builder} avoiding the
         * need to create one manually via {@link DocumentMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link DocumentMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #metadata(DocumentMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link DocumentMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(DocumentMetadata)
         */
        default Builder metadata(Consumer<DocumentMetadata.Builder> metadata) {
            return metadata(DocumentMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * The upload metadata.
         * </p>
         * 
         * @param uploadMetadata
         *        The upload metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadMetadata(UploadMetadata uploadMetadata);

        /**
         * <p>
         * The upload metadata.
         * </p>
         * This is a convenience method that creates an instance of the {@link UploadMetadata.Builder} avoiding the need
         * to create one manually via {@link UploadMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link UploadMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #uploadMetadata(UploadMetadata)}.
         * 
         * @param uploadMetadata
         *        a consumer that will call methods on {@link UploadMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uploadMetadata(UploadMetadata)
         */
        default Builder uploadMetadata(Consumer<UploadMetadata.Builder> uploadMetadata) {
            return uploadMetadata(UploadMetadata.builder().applyMutation(uploadMetadata).build());
        }
    }

    static final class BuilderImpl extends WorkDocsResponse.BuilderImpl implements Builder {
        private DocumentMetadata metadata;

        private UploadMetadata uploadMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(InitiateDocumentVersionUploadResponse model) {
            super(model);
            metadata(model.metadata);
            uploadMetadata(model.uploadMetadata);
        }

        public final DocumentMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(DocumentMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(DocumentMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final UploadMetadata.Builder getUploadMetadata() {
            return uploadMetadata != null ? uploadMetadata.toBuilder() : null;
        }

        public final void setUploadMetadata(UploadMetadata.BuilderImpl uploadMetadata) {
            this.uploadMetadata = uploadMetadata != null ? uploadMetadata.build() : null;
        }

        @Override
        public final Builder uploadMetadata(UploadMetadata uploadMetadata) {
            this.uploadMetadata = uploadMetadata;
            return this;
        }

        @Override
        public InitiateDocumentVersionUploadResponse build() {
            return new InitiateDocumentVersionUploadResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
