/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchResourcesResponse extends WorkDocsResponse implements
        ToCopyableBuilder<SearchResourcesResponse.Builder, SearchResourcesResponse> {
    private static final SdkField<List<ResponseItem>> ITEMS_FIELD = SdkField
            .<List<ResponseItem>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(SearchResourcesResponse::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResponseItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResponseItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(SearchResourcesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEMS_FIELD, MARKER_FIELD));

    private final List<ResponseItem> items;

    private final String marker;

    private SearchResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.items = builder.items;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of Documents, Folders, Comments, and Document Versions matching the query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return List of Documents, Folders, Comments, and Document Versions matching the query.
     */
    public final List<ResponseItem> items() {
        return items;
    }

    /**
     * <p>
     * The marker to use when requesting the next set of results. If there are no additional results, the string is
     * empty.
     * </p>
     * 
     * @return The marker to use when requesting the next set of results. If there are no additional results, the string
     *         is empty.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchResourcesResponse)) {
            return false;
        }
        SearchResourcesResponse other = (SearchResourcesResponse) obj;
        return hasItems() == other.hasItems() && Objects.equals(items(), other.items())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchResourcesResponse").add("Items", hasItems() ? items() : null).add("Marker", marker())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchResourcesResponse, T> g) {
        return obj -> g.apply((SearchResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkDocsResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchResourcesResponse> {
        /**
         * <p>
         * List of Documents, Folders, Comments, and Document Versions matching the query.
         * </p>
         * 
         * @param items
         *        List of Documents, Folders, Comments, and Document Versions matching the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<ResponseItem> items);

        /**
         * <p>
         * List of Documents, Folders, Comments, and Document Versions matching the query.
         * </p>
         * 
         * @param items
         *        List of Documents, Folders, Comments, and Document Versions matching the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(ResponseItem... items);

        /**
         * <p>
         * List of Documents, Folders, Comments, and Document Versions matching the query.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workdocs.model.ResponseItem.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.workdocs.model.ResponseItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workdocs.model.ResponseItem.Builder#build()} is called immediately and
         * its result is passed to {@link #items(List<ResponseItem>)}.
         * 
         * @param items
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workdocs.model.ResponseItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(java.util.Collection<ResponseItem>)
         */
        Builder items(Consumer<ResponseItem.Builder>... items);

        /**
         * <p>
         * The marker to use when requesting the next set of results. If there are no additional results, the string is
         * empty.
         * </p>
         * 
         * @param marker
         *        The marker to use when requesting the next set of results. If there are no additional results, the
         *        string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends WorkDocsResponse.BuilderImpl implements Builder {
        private List<ResponseItem> items = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchResourcesResponse model) {
            super(model);
            items(model.items);
            marker(model.marker);
        }

        public final List<ResponseItem.Builder> getItems() {
            List<ResponseItem.Builder> result = ResponseItemsListCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<ResponseItem.BuilderImpl> items) {
            this.items = ResponseItemsListCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<ResponseItem> items) {
            this.items = ResponseItemsListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(ResponseItem... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<ResponseItem.Builder>... items) {
            items(Stream.of(items).map(c -> ResponseItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public SearchResourcesResponse build() {
            return new SearchResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
