/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class User implements SdkPojo, Serializable, ToCopyableBuilder<User.Builder, User> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(User::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(User::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()).build();

    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailAddress").getter(getter(User::emailAddress)).setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()).build();

    private static final SdkField<String> GIVEN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GivenName").getter(getter(User::givenName)).setter(setter(Builder::givenName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GivenName").build()).build();

    private static final SdkField<String> SURNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Surname")
            .getter(getter(User::surname)).setter(setter(Builder::surname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Surname").build()).build();

    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationId").getter(getter(User::organizationId)).setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<String> ROOT_FOLDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RootFolderId").getter(getter(User::rootFolderId)).setter(setter(Builder::rootFolderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootFolderId").build()).build();

    private static final SdkField<String> RECYCLE_BIN_FOLDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecycleBinFolderId").getter(getter(User::recycleBinFolderId))
            .setter(setter(Builder::recycleBinFolderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecycleBinFolderId").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(User::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(User::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(User::createdTimestamp)).setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<Instant> MODIFIED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ModifiedTimestamp").getter(getter(User::modifiedTimestamp)).setter(setter(Builder::modifiedTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifiedTimestamp").build()).build();

    private static final SdkField<String> TIME_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeZoneId").getter(getter(User::timeZoneId)).setter(setter(Builder::timeZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZoneId").build()).build();

    private static final SdkField<String> LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Locale")
            .getter(getter(User::localeAsString)).setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locale").build()).build();

    private static final SdkField<UserStorageMetadata> STORAGE_FIELD = SdkField
            .<UserStorageMetadata> builder(MarshallingType.SDK_POJO).memberName("Storage").getter(getter(User::storage))
            .setter(setter(Builder::storage)).constructor(UserStorageMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Storage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, USERNAME_FIELD,
            EMAIL_ADDRESS_FIELD, GIVEN_NAME_FIELD, SURNAME_FIELD, ORGANIZATION_ID_FIELD, ROOT_FOLDER_ID_FIELD,
            RECYCLE_BIN_FOLDER_ID_FIELD, STATUS_FIELD, TYPE_FIELD, CREATED_TIMESTAMP_FIELD, MODIFIED_TIMESTAMP_FIELD,
            TIME_ZONE_ID_FIELD, LOCALE_FIELD, STORAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String username;

    private final String emailAddress;

    private final String givenName;

    private final String surname;

    private final String organizationId;

    private final String rootFolderId;

    private final String recycleBinFolderId;

    private final String status;

    private final String type;

    private final Instant createdTimestamp;

    private final Instant modifiedTimestamp;

    private final String timeZoneId;

    private final String locale;

    private final UserStorageMetadata storage;

    private User(BuilderImpl builder) {
        this.id = builder.id;
        this.username = builder.username;
        this.emailAddress = builder.emailAddress;
        this.givenName = builder.givenName;
        this.surname = builder.surname;
        this.organizationId = builder.organizationId;
        this.rootFolderId = builder.rootFolderId;
        this.recycleBinFolderId = builder.recycleBinFolderId;
        this.status = builder.status;
        this.type = builder.type;
        this.createdTimestamp = builder.createdTimestamp;
        this.modifiedTimestamp = builder.modifiedTimestamp;
        this.timeZoneId = builder.timeZoneId;
        this.locale = builder.locale;
        this.storage = builder.storage;
    }

    /**
     * <p>
     * The ID of the user.
     * </p>
     * 
     * @return The ID of the user.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The login name of the user.
     * </p>
     * 
     * @return The login name of the user.
     */
    public final String username() {
        return username;
    }

    /**
     * <p>
     * The email address of the user.
     * </p>
     * 
     * @return The email address of the user.
     */
    public final String emailAddress() {
        return emailAddress;
    }

    /**
     * <p>
     * The given name of the user.
     * </p>
     * 
     * @return The given name of the user.
     */
    public final String givenName() {
        return givenName;
    }

    /**
     * <p>
     * The surname of the user.
     * </p>
     * 
     * @return The surname of the user.
     */
    public final String surname() {
        return surname;
    }

    /**
     * <p>
     * The ID of the organization.
     * </p>
     * 
     * @return The ID of the organization.
     */
    public final String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * The ID of the root folder.
     * </p>
     * 
     * @return The ID of the root folder.
     */
    public final String rootFolderId() {
        return rootFolderId;
    }

    /**
     * <p>
     * The ID of the recycle bin folder.
     * </p>
     * 
     * @return The ID of the recycle bin folder.
     */
    public final String recycleBinFolderId() {
        return recycleBinFolderId;
    }

    /**
     * <p>
     * The status of the user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UserStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the user.
     * @see UserStatusType
     */
    public final UserStatusType status() {
        return UserStatusType.fromValue(status);
    }

    /**
     * <p>
     * The status of the user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UserStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the user.
     * @see UserStatusType
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The type of user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UserType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of user.
     * @see UserType
     */
    public final UserType type() {
        return UserType.fromValue(type);
    }

    /**
     * <p>
     * The type of user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UserType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of user.
     * @see UserType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The time when the user was created.
     * </p>
     * 
     * @return The time when the user was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The time when the user was modified.
     * </p>
     * 
     * @return The time when the user was modified.
     */
    public final Instant modifiedTimestamp() {
        return modifiedTimestamp;
    }

    /**
     * <p>
     * The time zone ID of the user.
     * </p>
     * 
     * @return The time zone ID of the user.
     */
    public final String timeZoneId() {
        return timeZoneId;
    }

    /**
     * <p>
     * The locale of the user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link LocaleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return The locale of the user.
     * @see LocaleType
     */
    public final LocaleType locale() {
        return LocaleType.fromValue(locale);
    }

    /**
     * <p>
     * The locale of the user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link LocaleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return The locale of the user.
     * @see LocaleType
     */
    public final String localeAsString() {
        return locale;
    }

    /**
     * <p>
     * The storage for the user.
     * </p>
     * 
     * @return The storage for the user.
     */
    public final UserStorageMetadata storage() {
        return storage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(givenName());
        hashCode = 31 * hashCode + Objects.hashCode(surname());
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(rootFolderId());
        hashCode = 31 * hashCode + Objects.hashCode(recycleBinFolderId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(modifiedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(timeZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(localeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(storage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(username(), other.username())
                && Objects.equals(emailAddress(), other.emailAddress()) && Objects.equals(givenName(), other.givenName())
                && Objects.equals(surname(), other.surname()) && Objects.equals(organizationId(), other.organizationId())
                && Objects.equals(rootFolderId(), other.rootFolderId())
                && Objects.equals(recycleBinFolderId(), other.recycleBinFolderId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(modifiedTimestamp(), other.modifiedTimestamp())
                && Objects.equals(timeZoneId(), other.timeZoneId()) && Objects.equals(localeAsString(), other.localeAsString())
                && Objects.equals(storage(), other.storage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("User").add("Id", id())
                .add("Username", username() == null ? null : "*** Sensitive Data Redacted ***")
                .add("EmailAddress", emailAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("GivenName", givenName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Surname", surname() == null ? null : "*** Sensitive Data Redacted ***")
                .add("OrganizationId", organizationId()).add("RootFolderId", rootFolderId())
                .add("RecycleBinFolderId", recycleBinFolderId()).add("Status", statusAsString()).add("Type", typeAsString())
                .add("CreatedTimestamp", createdTimestamp()).add("ModifiedTimestamp", modifiedTimestamp())
                .add("TimeZoneId", timeZoneId()).add("Locale", localeAsString()).add("Storage", storage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        case "EmailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "GivenName":
            return Optional.ofNullable(clazz.cast(givenName()));
        case "Surname":
            return Optional.ofNullable(clazz.cast(surname()));
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "RootFolderId":
            return Optional.ofNullable(clazz.cast(rootFolderId()));
        case "RecycleBinFolderId":
            return Optional.ofNullable(clazz.cast(recycleBinFolderId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "ModifiedTimestamp":
            return Optional.ofNullable(clazz.cast(modifiedTimestamp()));
        case "TimeZoneId":
            return Optional.ofNullable(clazz.cast(timeZoneId()));
        case "Locale":
            return Optional.ofNullable(clazz.cast(localeAsString()));
        case "Storage":
            return Optional.ofNullable(clazz.cast(storage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<User, T> g) {
        return obj -> g.apply((User) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, User> {
        /**
         * <p>
         * The ID of the user.
         * </p>
         * 
         * @param id
         *        The ID of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The login name of the user.
         * </p>
         * 
         * @param username
         *        The login name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);

        /**
         * <p>
         * The email address of the user.
         * </p>
         * 
         * @param emailAddress
         *        The email address of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * The given name of the user.
         * </p>
         * 
         * @param givenName
         *        The given name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder givenName(String givenName);

        /**
         * <p>
         * The surname of the user.
         * </p>
         * 
         * @param surname
         *        The surname of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder surname(String surname);

        /**
         * <p>
         * The ID of the organization.
         * </p>
         * 
         * @param organizationId
         *        The ID of the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * The ID of the root folder.
         * </p>
         * 
         * @param rootFolderId
         *        The ID of the root folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootFolderId(String rootFolderId);

        /**
         * <p>
         * The ID of the recycle bin folder.
         * </p>
         * 
         * @param recycleBinFolderId
         *        The ID of the recycle bin folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recycleBinFolderId(String recycleBinFolderId);

        /**
         * <p>
         * The status of the user.
         * </p>
         * 
         * @param status
         *        The status of the user.
         * @see UserStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the user.
         * </p>
         * 
         * @param status
         *        The status of the user.
         * @see UserStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserStatusType
         */
        Builder status(UserStatusType status);

        /**
         * <p>
         * The type of user.
         * </p>
         * 
         * @param type
         *        The type of user.
         * @see UserType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of user.
         * </p>
         * 
         * @param type
         *        The type of user.
         * @see UserType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserType
         */
        Builder type(UserType type);

        /**
         * <p>
         * The time when the user was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The time when the user was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The time when the user was modified.
         * </p>
         * 
         * @param modifiedTimestamp
         *        The time when the user was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modifiedTimestamp(Instant modifiedTimestamp);

        /**
         * <p>
         * The time zone ID of the user.
         * </p>
         * 
         * @param timeZoneId
         *        The time zone ID of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeZoneId(String timeZoneId);

        /**
         * <p>
         * The locale of the user.
         * </p>
         * 
         * @param locale
         *        The locale of the user.
         * @see LocaleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocaleType
         */
        Builder locale(String locale);

        /**
         * <p>
         * The locale of the user.
         * </p>
         * 
         * @param locale
         *        The locale of the user.
         * @see LocaleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocaleType
         */
        Builder locale(LocaleType locale);

        /**
         * <p>
         * The storage for the user.
         * </p>
         * 
         * @param storage
         *        The storage for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storage(UserStorageMetadata storage);

        /**
         * <p>
         * The storage for the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link UserStorageMetadata.Builder} avoiding the
         * need to create one manually via {@link UserStorageMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserStorageMetadata.Builder#build()} is called immediately and
         * its result is passed to {@link #storage(UserStorageMetadata)}.
         * 
         * @param storage
         *        a consumer that will call methods on {@link UserStorageMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storage(UserStorageMetadata)
         */
        default Builder storage(Consumer<UserStorageMetadata.Builder> storage) {
            return storage(UserStorageMetadata.builder().applyMutation(storage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String username;

        private String emailAddress;

        private String givenName;

        private String surname;

        private String organizationId;

        private String rootFolderId;

        private String recycleBinFolderId;

        private String status;

        private String type;

        private Instant createdTimestamp;

        private Instant modifiedTimestamp;

        private String timeZoneId;

        private String locale;

        private UserStorageMetadata storage;

        private BuilderImpl() {
        }

        private BuilderImpl(User model) {
            id(model.id);
            username(model.username);
            emailAddress(model.emailAddress);
            givenName(model.givenName);
            surname(model.surname);
            organizationId(model.organizationId);
            rootFolderId(model.rootFolderId);
            recycleBinFolderId(model.recycleBinFolderId);
            status(model.status);
            type(model.type);
            createdTimestamp(model.createdTimestamp);
            modifiedTimestamp(model.modifiedTimestamp);
            timeZoneId(model.timeZoneId);
            locale(model.locale);
            storage(model.storage);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getUsername() {
            return username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getGivenName() {
            return givenName;
        }

        public final void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        @Override
        public final Builder givenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public final String getSurname() {
            return surname;
        }

        public final void setSurname(String surname) {
            this.surname = surname;
        }

        @Override
        public final Builder surname(String surname) {
            this.surname = surname;
            return this;
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getRootFolderId() {
            return rootFolderId;
        }

        public final void setRootFolderId(String rootFolderId) {
            this.rootFolderId = rootFolderId;
        }

        @Override
        public final Builder rootFolderId(String rootFolderId) {
            this.rootFolderId = rootFolderId;
            return this;
        }

        public final String getRecycleBinFolderId() {
            return recycleBinFolderId;
        }

        public final void setRecycleBinFolderId(String recycleBinFolderId) {
            this.recycleBinFolderId = recycleBinFolderId;
        }

        @Override
        public final Builder recycleBinFolderId(String recycleBinFolderId) {
            this.recycleBinFolderId = recycleBinFolderId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UserStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UserType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final Instant getModifiedTimestamp() {
            return modifiedTimestamp;
        }

        public final void setModifiedTimestamp(Instant modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
        }

        @Override
        public final Builder modifiedTimestamp(Instant modifiedTimestamp) {
            this.modifiedTimestamp = modifiedTimestamp;
            return this;
        }

        public final String getTimeZoneId() {
            return timeZoneId;
        }

        public final void setTimeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
        }

        @Override
        public final Builder timeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return this;
        }

        public final String getLocale() {
            return locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(LocaleType locale) {
            this.locale(locale == null ? null : locale.toString());
            return this;
        }

        public final UserStorageMetadata.Builder getStorage() {
            return storage != null ? storage.toBuilder() : null;
        }

        public final void setStorage(UserStorageMetadata.BuilderImpl storage) {
            this.storage = storage != null ? storage.build() : null;
        }

        @Override
        public final Builder storage(UserStorageMetadata storage) {
            this.storage = storage;
            return this;
        }

        @Override
        public User build() {
            return new User(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
