/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeFolderContentsRequest extends WorkDocsRequest implements
        ToCopyableBuilder<DescribeFolderContentsRequest.Builder, DescribeFolderContentsRequest> {
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationToken").getter(getter(DescribeFolderContentsRequest::authenticationToken))
            .setter(setter(Builder::authenticationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()).build();

    private static final SdkField<String> FOLDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FolderId").getter(getter(DescribeFolderContentsRequest::folderId)).setter(setter(Builder::folderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FolderId").build()).build();

    private static final SdkField<String> SORT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Sort")
            .getter(getter(DescribeFolderContentsRequest::sortAsString)).setter(setter(Builder::sort))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sort").build()).build();

    private static final SdkField<String> ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Order")
            .getter(getter(DescribeFolderContentsRequest::orderAsString)).setter(setter(Builder::order))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("order").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(DescribeFolderContentsRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeFolderContentsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("marker").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(DescribeFolderContentsRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("type").build()).build();

    private static final SdkField<String> INCLUDE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Include")
            .getter(getter(DescribeFolderContentsRequest::include)).setter(setter(Builder::include))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("include").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TOKEN_FIELD,
            FOLDER_ID_FIELD, SORT_FIELD, ORDER_FIELD, LIMIT_FIELD, MARKER_FIELD, TYPE_FIELD, INCLUDE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String authenticationToken;

    private final String folderId;

    private final String sort;

    private final String order;

    private final Integer limit;

    private final String marker;

    private final String type;

    private final String include;

    private DescribeFolderContentsRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.folderId = builder.folderId;
        this.sort = builder.sort;
        this.order = builder.order;
        this.limit = builder.limit;
        this.marker = builder.marker;
        this.type = builder.type;
        this.include = builder.include;
    }

    /**
     * <p>
     * Amazon WorkDocs authentication token. Not required when using Amazon Web Services administrator credentials to
     * access the API.
     * </p>
     * 
     * @return Amazon WorkDocs authentication token. Not required when using Amazon Web Services administrator
     *         credentials to access the API.
     */
    public final String authenticationToken() {
        return authenticationToken;
    }

    /**
     * <p>
     * The ID of the folder.
     * </p>
     * 
     * @return The ID of the folder.
     */
    public final String folderId() {
        return folderId;
    }

    /**
     * <p>
     * The sorting criteria.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sort} will return
     * {@link ResourceSortType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortAsString}.
     * </p>
     * 
     * @return The sorting criteria.
     * @see ResourceSortType
     */
    public final ResourceSortType sort() {
        return ResourceSortType.fromValue(sort);
    }

    /**
     * <p>
     * The sorting criteria.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sort} will return
     * {@link ResourceSortType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortAsString}.
     * </p>
     * 
     * @return The sorting criteria.
     * @see ResourceSortType
     */
    public final String sortAsString() {
        return sort;
    }

    /**
     * <p>
     * The order for the contents of the folder.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #order} will return
     * {@link OrderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderAsString}.
     * </p>
     * 
     * @return The order for the contents of the folder.
     * @see OrderType
     */
    public final OrderType order() {
        return OrderType.fromValue(order);
    }

    /**
     * <p>
     * The order for the contents of the folder.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #order} will return
     * {@link OrderType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderAsString}.
     * </p>
     * 
     * @return The order for the contents of the folder.
     * @see OrderType
     */
    public final String orderAsString() {
        return order;
    }

    /**
     * <p>
     * The maximum number of items to return with this call.
     * </p>
     * 
     * @return The maximum number of items to return with this call.
     */
    public final Integer limit() {
        return limit;
    }

    /**
     * <p>
     * The marker for the next set of results. This marker was received from a previous call.
     * </p>
     * 
     * @return The marker for the next set of results. This marker was received from a previous call.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * The type of items.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FolderContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of items.
     * @see FolderContentType
     */
    public final FolderContentType type() {
        return FolderContentType.fromValue(type);
    }

    /**
     * <p>
     * The type of items.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FolderContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of items.
     * @see FolderContentType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The contents to include. Specify "INITIALIZED" to include initialized documents.
     * </p>
     * 
     * @return The contents to include. Specify "INITIALIZED" to include initialized documents.
     */
    public final String include() {
        return include;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(folderId());
        hashCode = 31 * hashCode + Objects.hashCode(sortAsString());
        hashCode = 31 * hashCode + Objects.hashCode(orderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(include());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFolderContentsRequest)) {
            return false;
        }
        DescribeFolderContentsRequest other = (DescribeFolderContentsRequest) obj;
        return Objects.equals(authenticationToken(), other.authenticationToken()) && Objects.equals(folderId(), other.folderId())
                && Objects.equals(sortAsString(), other.sortAsString()) && Objects.equals(orderAsString(), other.orderAsString())
                && Objects.equals(limit(), other.limit()) && Objects.equals(marker(), other.marker())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(include(), other.include());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeFolderContentsRequest")
                .add("AuthenticationToken", authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FolderId", folderId()).add("Sort", sortAsString()).add("Order", orderAsString()).add("Limit", limit())
                .add("Marker", marker()).add("Type", typeAsString()).add("Include", include()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationToken":
            return Optional.ofNullable(clazz.cast(authenticationToken()));
        case "FolderId":
            return Optional.ofNullable(clazz.cast(folderId()));
        case "Sort":
            return Optional.ofNullable(clazz.cast(sortAsString()));
        case "Order":
            return Optional.ofNullable(clazz.cast(orderAsString()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Include":
            return Optional.ofNullable(clazz.cast(include()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Authentication", AUTHENTICATION_TOKEN_FIELD);
        map.put("FolderId", FOLDER_ID_FIELD);
        map.put("sort", SORT_FIELD);
        map.put("order", ORDER_FIELD);
        map.put("limit", LIMIT_FIELD);
        map.put("marker", MARKER_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("include", INCLUDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeFolderContentsRequest, T> g) {
        return obj -> g.apply((DescribeFolderContentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkDocsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeFolderContentsRequest> {
        /**
         * <p>
         * Amazon WorkDocs authentication token. Not required when using Amazon Web Services administrator credentials
         * to access the API.
         * </p>
         * 
         * @param authenticationToken
         *        Amazon WorkDocs authentication token. Not required when using Amazon Web Services administrator
         *        credentials to access the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationToken(String authenticationToken);

        /**
         * <p>
         * The ID of the folder.
         * </p>
         * 
         * @param folderId
         *        The ID of the folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folderId(String folderId);

        /**
         * <p>
         * The sorting criteria.
         * </p>
         * 
         * @param sort
         *        The sorting criteria.
         * @see ResourceSortType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceSortType
         */
        Builder sort(String sort);

        /**
         * <p>
         * The sorting criteria.
         * </p>
         * 
         * @param sort
         *        The sorting criteria.
         * @see ResourceSortType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceSortType
         */
        Builder sort(ResourceSortType sort);

        /**
         * <p>
         * The order for the contents of the folder.
         * </p>
         * 
         * @param order
         *        The order for the contents of the folder.
         * @see OrderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrderType
         */
        Builder order(String order);

        /**
         * <p>
         * The order for the contents of the folder.
         * </p>
         * 
         * @param order
         *        The order for the contents of the folder.
         * @see OrderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrderType
         */
        Builder order(OrderType order);

        /**
         * <p>
         * The maximum number of items to return with this call.
         * </p>
         * 
         * @param limit
         *        The maximum number of items to return with this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        /**
         * <p>
         * The marker for the next set of results. This marker was received from a previous call.
         * </p>
         * 
         * @param marker
         *        The marker for the next set of results. This marker was received from a previous call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The type of items.
         * </p>
         * 
         * @param type
         *        The type of items.
         * @see FolderContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FolderContentType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of items.
         * </p>
         * 
         * @param type
         *        The type of items.
         * @see FolderContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FolderContentType
         */
        Builder type(FolderContentType type);

        /**
         * <p>
         * The contents to include. Specify "INITIALIZED" to include initialized documents.
         * </p>
         * 
         * @param include
         *        The contents to include. Specify "INITIALIZED" to include initialized documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder include(String include);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkDocsRequest.BuilderImpl implements Builder {
        private String authenticationToken;

        private String folderId;

        private String sort;

        private String order;

        private Integer limit;

        private String marker;

        private String type;

        private String include;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFolderContentsRequest model) {
            super(model);
            authenticationToken(model.authenticationToken);
            folderId(model.folderId);
            sort(model.sort);
            order(model.order);
            limit(model.limit);
            marker(model.marker);
            type(model.type);
            include(model.include);
        }

        public final String getAuthenticationToken() {
            return authenticationToken;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final String getFolderId() {
            return folderId;
        }

        public final void setFolderId(String folderId) {
            this.folderId = folderId;
        }

        @Override
        public final Builder folderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public final String getSort() {
            return sort;
        }

        public final void setSort(String sort) {
            this.sort = sort;
        }

        @Override
        public final Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        @Override
        public final Builder sort(ResourceSortType sort) {
            this.sort(sort == null ? null : sort.toString());
            return this;
        }

        public final String getOrder() {
            return order;
        }

        public final void setOrder(String order) {
            this.order = order;
        }

        @Override
        public final Builder order(String order) {
            this.order = order;
            return this;
        }

        @Override
        public final Builder order(OrderType order) {
            this.order(order == null ? null : order.toString());
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FolderContentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getInclude() {
            return include;
        }

        public final void setInclude(String include) {
            this.include = include;
        }

        @Override
        public final Builder include(String include) {
            this.include = include;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeFolderContentsRequest build() {
            return new DescribeFolderContentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
