/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filter based on UserIds or GroupIds.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchPrincipalType implements SdkPojo, Serializable,
        ToCopyableBuilder<SearchPrincipalType.Builder, SearchPrincipalType> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(SearchPrincipalType::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<List<String>> ROLES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Roles")
            .getter(getter(SearchPrincipalType::rolesAsStrings))
            .setter(setter(Builder::rolesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Roles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ROLES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final List<String> roles;

    private SearchPrincipalType(BuilderImpl builder) {
        this.id = builder.id;
        this.roles = builder.roles;
    }

    /**
     * <p>
     * UserIds or GroupIds.
     * </p>
     * 
     * @return UserIds or GroupIds.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Role of a User or Group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoles} method.
     * </p>
     * 
     * @return The Role of a User or Group.
     */
    public final List<PrincipalRoleType> roles() {
        return SearchPrincipalRoleListCopier.copyStringToEnum(roles);
    }

    /**
     * For responses, this returns true if the service returned a value for the Roles property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRoles() {
        return roles != null && !(roles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Role of a User or Group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoles} method.
     * </p>
     * 
     * @return The Role of a User or Group.
     */
    public final List<String> rolesAsStrings() {
        return roles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoles() ? rolesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchPrincipalType)) {
            return false;
        }
        SearchPrincipalType other = (SearchPrincipalType) obj;
        return Objects.equals(id(), other.id()) && hasRoles() == other.hasRoles()
                && Objects.equals(rolesAsStrings(), other.rolesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchPrincipalType").add("Id", id()).add("Roles", hasRoles() ? rolesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Roles":
            return Optional.ofNullable(clazz.cast(rolesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Roles", ROLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchPrincipalType, T> g) {
        return obj -> g.apply((SearchPrincipalType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchPrincipalType> {
        /**
         * <p>
         * UserIds or GroupIds.
         * </p>
         * 
         * @param id
         *        UserIds or GroupIds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Role of a User or Group.
         * </p>
         * 
         * @param roles
         *        The Role of a User or Group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rolesWithStrings(Collection<String> roles);

        /**
         * <p>
         * The Role of a User or Group.
         * </p>
         * 
         * @param roles
         *        The Role of a User or Group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rolesWithStrings(String... roles);

        /**
         * <p>
         * The Role of a User or Group.
         * </p>
         * 
         * @param roles
         *        The Role of a User or Group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roles(Collection<PrincipalRoleType> roles);

        /**
         * <p>
         * The Role of a User or Group.
         * </p>
         * 
         * @param roles
         *        The Role of a User or Group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roles(PrincipalRoleType... roles);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private List<String> roles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchPrincipalType model) {
            id(model.id);
            rolesWithStrings(model.roles);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Collection<String> getRoles() {
            if (roles instanceof SdkAutoConstructList) {
                return null;
            }
            return roles;
        }

        public final void setRoles(Collection<String> roles) {
            this.roles = SearchPrincipalRoleListCopier.copy(roles);
        }

        @Override
        public final Builder rolesWithStrings(Collection<String> roles) {
            this.roles = SearchPrincipalRoleListCopier.copy(roles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rolesWithStrings(String... roles) {
            rolesWithStrings(Arrays.asList(roles));
            return this;
        }

        @Override
        public final Builder roles(Collection<PrincipalRoleType> roles) {
            this.roles = SearchPrincipalRoleListCopier.copyEnumToString(roles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(PrincipalRoleType... roles) {
            roles(Arrays.asList(roles));
            return this;
        }

        @Override
        public SearchPrincipalType build() {
            return new SearchPrincipalType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
