/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the metadata of a comment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CommentMetadata implements SdkPojo, Serializable, ToCopyableBuilder<CommentMetadata.Builder, CommentMetadata> {
    private static final SdkField<String> COMMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CommentId").getter(getter(CommentMetadata::commentId)).setter(setter(Builder::commentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommentId").build()).build();

    private static final SdkField<User> CONTRIBUTOR_FIELD = SdkField.<User> builder(MarshallingType.SDK_POJO)
            .memberName("Contributor").getter(getter(CommentMetadata::contributor)).setter(setter(Builder::contributor))
            .constructor(User::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Contributor").build()).build();

    private static final SdkField<Instant> CREATED_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTimestamp").getter(getter(CommentMetadata::createdTimestamp))
            .setter(setter(Builder::createdTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimestamp").build()).build();

    private static final SdkField<String> COMMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CommentStatus").getter(getter(CommentMetadata::commentStatusAsString))
            .setter(setter(Builder::commentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommentStatus").build()).build();

    private static final SdkField<String> RECIPIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecipientId").getter(getter(CommentMetadata::recipientId)).setter(setter(Builder::recipientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipientId").build()).build();

    private static final SdkField<String> CONTRIBUTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContributorId").getter(getter(CommentMetadata::contributorId)).setter(setter(Builder::contributorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributorId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_ID_FIELD,
            CONTRIBUTOR_FIELD, CREATED_TIMESTAMP_FIELD, COMMENT_STATUS_FIELD, RECIPIENT_ID_FIELD, CONTRIBUTOR_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String commentId;

    private final User contributor;

    private final Instant createdTimestamp;

    private final String commentStatus;

    private final String recipientId;

    private final String contributorId;

    private CommentMetadata(BuilderImpl builder) {
        this.commentId = builder.commentId;
        this.contributor = builder.contributor;
        this.createdTimestamp = builder.createdTimestamp;
        this.commentStatus = builder.commentStatus;
        this.recipientId = builder.recipientId;
        this.contributorId = builder.contributorId;
    }

    /**
     * <p>
     * The ID of the comment.
     * </p>
     * 
     * @return The ID of the comment.
     */
    public final String commentId() {
        return commentId;
    }

    /**
     * <p>
     * The user who made the comment.
     * </p>
     * 
     * @return The user who made the comment.
     */
    public final User contributor() {
        return contributor;
    }

    /**
     * <p>
     * The timestamp that the comment was created.
     * </p>
     * 
     * @return The timestamp that the comment was created.
     */
    public final Instant createdTimestamp() {
        return createdTimestamp;
    }

    /**
     * <p>
     * The status of the comment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #commentStatus}
     * will return {@link CommentStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #commentStatusAsString}.
     * </p>
     * 
     * @return The status of the comment.
     * @see CommentStatusType
     */
    public final CommentStatusType commentStatus() {
        return CommentStatusType.fromValue(commentStatus);
    }

    /**
     * <p>
     * The status of the comment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #commentStatus}
     * will return {@link CommentStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #commentStatusAsString}.
     * </p>
     * 
     * @return The status of the comment.
     * @see CommentStatusType
     */
    public final String commentStatusAsString() {
        return commentStatus;
    }

    /**
     * <p>
     * The ID of the user being replied to.
     * </p>
     * 
     * @return The ID of the user being replied to.
     */
    public final String recipientId() {
        return recipientId;
    }

    /**
     * <p>
     * The ID of the user who made the comment.
     * </p>
     * 
     * @return The ID of the user who made the comment.
     */
    public final String contributorId() {
        return contributorId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(commentId());
        hashCode = 31 * hashCode + Objects.hashCode(contributor());
        hashCode = 31 * hashCode + Objects.hashCode(createdTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(commentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(recipientId());
        hashCode = 31 * hashCode + Objects.hashCode(contributorId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommentMetadata)) {
            return false;
        }
        CommentMetadata other = (CommentMetadata) obj;
        return Objects.equals(commentId(), other.commentId()) && Objects.equals(contributor(), other.contributor())
                && Objects.equals(createdTimestamp(), other.createdTimestamp())
                && Objects.equals(commentStatusAsString(), other.commentStatusAsString())
                && Objects.equals(recipientId(), other.recipientId()) && Objects.equals(contributorId(), other.contributorId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CommentMetadata").add("CommentId", commentId()).add("Contributor", contributor())
                .add("CreatedTimestamp", createdTimestamp()).add("CommentStatus", commentStatusAsString())
                .add("RecipientId", recipientId()).add("ContributorId", contributorId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CommentId":
            return Optional.ofNullable(clazz.cast(commentId()));
        case "Contributor":
            return Optional.ofNullable(clazz.cast(contributor()));
        case "CreatedTimestamp":
            return Optional.ofNullable(clazz.cast(createdTimestamp()));
        case "CommentStatus":
            return Optional.ofNullable(clazz.cast(commentStatusAsString()));
        case "RecipientId":
            return Optional.ofNullable(clazz.cast(recipientId()));
        case "ContributorId":
            return Optional.ofNullable(clazz.cast(contributorId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CommentId", COMMENT_ID_FIELD);
        map.put("Contributor", CONTRIBUTOR_FIELD);
        map.put("CreatedTimestamp", CREATED_TIMESTAMP_FIELD);
        map.put("CommentStatus", COMMENT_STATUS_FIELD);
        map.put("RecipientId", RECIPIENT_ID_FIELD);
        map.put("ContributorId", CONTRIBUTOR_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CommentMetadata, T> g) {
        return obj -> g.apply((CommentMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CommentMetadata> {
        /**
         * <p>
         * The ID of the comment.
         * </p>
         * 
         * @param commentId
         *        The ID of the comment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commentId(String commentId);

        /**
         * <p>
         * The user who made the comment.
         * </p>
         * 
         * @param contributor
         *        The user who made the comment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contributor(User contributor);

        /**
         * <p>
         * The user who made the comment.
         * </p>
         * This is a convenience method that creates an instance of the {@link User.Builder} avoiding the need to create
         * one manually via {@link User#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link User.Builder#build()} is called immediately and its result is
         * passed to {@link #contributor(User)}.
         * 
         * @param contributor
         *        a consumer that will call methods on {@link User.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contributor(User)
         */
        default Builder contributor(Consumer<User.Builder> contributor) {
            return contributor(User.builder().applyMutation(contributor).build());
        }

        /**
         * <p>
         * The timestamp that the comment was created.
         * </p>
         * 
         * @param createdTimestamp
         *        The timestamp that the comment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimestamp(Instant createdTimestamp);

        /**
         * <p>
         * The status of the comment.
         * </p>
         * 
         * @param commentStatus
         *        The status of the comment.
         * @see CommentStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommentStatusType
         */
        Builder commentStatus(String commentStatus);

        /**
         * <p>
         * The status of the comment.
         * </p>
         * 
         * @param commentStatus
         *        The status of the comment.
         * @see CommentStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommentStatusType
         */
        Builder commentStatus(CommentStatusType commentStatus);

        /**
         * <p>
         * The ID of the user being replied to.
         * </p>
         * 
         * @param recipientId
         *        The ID of the user being replied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipientId(String recipientId);

        /**
         * <p>
         * The ID of the user who made the comment.
         * </p>
         * 
         * @param contributorId
         *        The ID of the user who made the comment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contributorId(String contributorId);
    }

    static final class BuilderImpl implements Builder {
        private String commentId;

        private User contributor;

        private Instant createdTimestamp;

        private String commentStatus;

        private String recipientId;

        private String contributorId;

        private BuilderImpl() {
        }

        private BuilderImpl(CommentMetadata model) {
            commentId(model.commentId);
            contributor(model.contributor);
            createdTimestamp(model.createdTimestamp);
            commentStatus(model.commentStatus);
            recipientId(model.recipientId);
            contributorId(model.contributorId);
        }

        public final String getCommentId() {
            return commentId;
        }

        public final void setCommentId(String commentId) {
            this.commentId = commentId;
        }

        @Override
        public final Builder commentId(String commentId) {
            this.commentId = commentId;
            return this;
        }

        public final User.Builder getContributor() {
            return contributor != null ? contributor.toBuilder() : null;
        }

        public final void setContributor(User.BuilderImpl contributor) {
            this.contributor = contributor != null ? contributor.build() : null;
        }

        @Override
        public final Builder contributor(User contributor) {
            this.contributor = contributor;
            return this;
        }

        public final Instant getCreatedTimestamp() {
            return createdTimestamp;
        }

        public final void setCreatedTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
        }

        @Override
        public final Builder createdTimestamp(Instant createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return this;
        }

        public final String getCommentStatus() {
            return commentStatus;
        }

        public final void setCommentStatus(String commentStatus) {
            this.commentStatus = commentStatus;
        }

        @Override
        public final Builder commentStatus(String commentStatus) {
            this.commentStatus = commentStatus;
            return this;
        }

        @Override
        public final Builder commentStatus(CommentStatusType commentStatus) {
            this.commentStatus(commentStatus == null ? null : commentStatus.toString());
            return this;
        }

        public final String getRecipientId() {
            return recipientId;
        }

        public final void setRecipientId(String recipientId) {
            this.recipientId = recipientId;
        }

        @Override
        public final Builder recipientId(String recipientId) {
            this.recipientId = recipientId;
            return this;
        }

        public final String getContributorId() {
            return contributorId;
        }

        public final void setContributorId(String contributorId) {
            this.contributorId = contributorId;
        }

        @Override
        public final Builder contributorId(String contributorId) {
            this.contributorId = contributorId;
            return this;
        }

        @Override
        public CommentMetadata build() {
            return new CommentMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
