/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCustomMetadataRequest extends WorkDocsRequest implements
        ToCopyableBuilder<CreateCustomMetadataRequest.Builder, CreateCustomMetadataRequest> {
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationToken").getter(getter(CreateCustomMetadataRequest::authenticationToken))
            .setter(setter(Builder::authenticationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(CreateCustomMetadataRequest::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ResourceId").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionId").getter(getter(CreateCustomMetadataRequest::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("versionid").build()).build();

    private static final SdkField<Map<String, String>> CUSTOM_METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("CustomMetadata")
            .getter(getter(CreateCustomMetadataRequest::customMetadata))
            .setter(setter(Builder::customMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomMetadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TOKEN_FIELD,
            RESOURCE_ID_FIELD, VERSION_ID_FIELD, CUSTOM_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String authenticationToken;

    private final String resourceId;

    private final String versionId;

    private final Map<String, String> customMetadata;

    private CreateCustomMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.resourceId = builder.resourceId;
        this.versionId = builder.versionId;
        this.customMetadata = builder.customMetadata;
    }

    /**
     * <p>
     * Amazon WorkDocs authentication token. Not required when using Amazon Web Services administrator credentials to
     * access the API.
     * </p>
     * 
     * @return Amazon WorkDocs authentication token. Not required when using Amazon Web Services administrator
     *         credentials to access the API.
     */
    public final String authenticationToken() {
        return authenticationToken;
    }

    /**
     * <p>
     * The ID of the resource.
     * </p>
     * 
     * @return The ID of the resource.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The ID of the version, if the custom metadata is being added to a document version.
     * </p>
     * 
     * @return The ID of the version, if the custom metadata is being added to a document version.
     */
    public final String versionId() {
        return versionId;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomMetadata property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomMetadata() {
        return customMetadata != null && !(customMetadata instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Custom metadata in the form of name-value pairs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomMetadata} method.
     * </p>
     * 
     * @return Custom metadata in the form of name-value pairs.
     */
    public final Map<String, String> customMetadata() {
        return customMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomMetadata() ? customMetadata() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomMetadataRequest)) {
            return false;
        }
        CreateCustomMetadataRequest other = (CreateCustomMetadataRequest) obj;
        return Objects.equals(authenticationToken(), other.authenticationToken())
                && Objects.equals(resourceId(), other.resourceId()) && Objects.equals(versionId(), other.versionId())
                && hasCustomMetadata() == other.hasCustomMetadata() && Objects.equals(customMetadata(), other.customMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCustomMetadataRequest")
                .add("AuthenticationToken", authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ResourceId", resourceId()).add("VersionId", versionId())
                .add("CustomMetadata", hasCustomMetadata() ? customMetadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationToken":
            return Optional.ofNullable(clazz.cast(authenticationToken()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        case "CustomMetadata":
            return Optional.ofNullable(clazz.cast(customMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Authentication", AUTHENTICATION_TOKEN_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("versionid", VERSION_ID_FIELD);
        map.put("CustomMetadata", CUSTOM_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomMetadataRequest, T> g) {
        return obj -> g.apply((CreateCustomMetadataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkDocsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCustomMetadataRequest> {
        /**
         * <p>
         * Amazon WorkDocs authentication token. Not required when using Amazon Web Services administrator credentials
         * to access the API.
         * </p>
         * 
         * @param authenticationToken
         *        Amazon WorkDocs authentication token. Not required when using Amazon Web Services administrator
         *        credentials to access the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationToken(String authenticationToken);

        /**
         * <p>
         * The ID of the resource.
         * </p>
         * 
         * @param resourceId
         *        The ID of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The ID of the version, if the custom metadata is being added to a document version.
         * </p>
         * 
         * @param versionId
         *        The ID of the version, if the custom metadata is being added to a document version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * <p>
         * Custom metadata in the form of name-value pairs.
         * </p>
         * 
         * @param customMetadata
         *        Custom metadata in the form of name-value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customMetadata(Map<String, String> customMetadata);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkDocsRequest.BuilderImpl implements Builder {
        private String authenticationToken;

        private String resourceId;

        private String versionId;

        private Map<String, String> customMetadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomMetadataRequest model) {
            super(model);
            authenticationToken(model.authenticationToken);
            resourceId(model.resourceId);
            versionId(model.versionId);
            customMetadata(model.customMetadata);
        }

        public final String getAuthenticationToken() {
            return authenticationToken;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getVersionId() {
            return versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final Map<String, String> getCustomMetadata() {
            if (customMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return customMetadata;
        }

        public final void setCustomMetadata(Map<String, String> customMetadata) {
            this.customMetadata = CustomMetadataMapCopier.copy(customMetadata);
        }

        @Override
        public final Builder customMetadata(Map<String, String> customMetadata) {
            this.customMetadata = CustomMetadataMapCopier.copy(customMetadata);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomMetadataRequest build() {
            return new CreateCustomMetadataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
