/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filter based on size (in bytes).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LongRangeType implements SdkPojo, Serializable, ToCopyableBuilder<LongRangeType.Builder, LongRangeType> {
    private static final SdkField<Long> START_VALUE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("StartValue").getter(getter(LongRangeType::startValue)).setter(setter(Builder::startValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartValue").build()).build();

    private static final SdkField<Long> END_VALUE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("EndValue")
            .getter(getter(LongRangeType::endValue)).setter(setter(Builder::endValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_VALUE_FIELD,
            END_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long startValue;

    private final Long endValue;

    private LongRangeType(BuilderImpl builder) {
        this.startValue = builder.startValue;
        this.endValue = builder.endValue;
    }

    /**
     * <p>
     * The size start range (in bytes).
     * </p>
     * 
     * @return The size start range (in bytes).
     */
    public final Long startValue() {
        return startValue;
    }

    /**
     * <p>
     * The size end range (in bytes).
     * </p>
     * 
     * @return The size end range (in bytes).
     */
    public final Long endValue() {
        return endValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startValue());
        hashCode = 31 * hashCode + Objects.hashCode(endValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LongRangeType)) {
            return false;
        }
        LongRangeType other = (LongRangeType) obj;
        return Objects.equals(startValue(), other.startValue()) && Objects.equals(endValue(), other.endValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LongRangeType").add("StartValue", startValue()).add("EndValue", endValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartValue":
            return Optional.ofNullable(clazz.cast(startValue()));
        case "EndValue":
            return Optional.ofNullable(clazz.cast(endValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StartValue", START_VALUE_FIELD);
        map.put("EndValue", END_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LongRangeType, T> g) {
        return obj -> g.apply((LongRangeType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LongRangeType> {
        /**
         * <p>
         * The size start range (in bytes).
         * </p>
         * 
         * @param startValue
         *        The size start range (in bytes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startValue(Long startValue);

        /**
         * <p>
         * The size end range (in bytes).
         * </p>
         * 
         * @param endValue
         *        The size end range (in bytes).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endValue(Long endValue);
    }

    static final class BuilderImpl implements Builder {
        private Long startValue;

        private Long endValue;

        private BuilderImpl() {
        }

        private BuilderImpl(LongRangeType model) {
            startValue(model.startValue);
            endValue(model.endValue);
        }

        public final Long getStartValue() {
            return startValue;
        }

        public final void setStartValue(Long startValue) {
            this.startValue = startValue;
        }

        @Override
        public final Builder startValue(Long startValue) {
            this.startValue = startValue;
            return this;
        }

        public final Long getEndValue() {
            return endValue;
        }

        public final void setEndValue(Long endValue) {
            this.endValue = endValue;
        }

        @Override
        public final Builder endValue(Long endValue) {
            this.endValue = endValue;
            return this;
        }

        @Override
        public LongRangeType build() {
            return new LongRangeType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
