/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the share results of a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ShareResult implements SdkPojo, Serializable, ToCopyableBuilder<ShareResult.Builder, ShareResult> {
    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrincipalId").getter(getter(ShareResult::principalId)).setter(setter(Builder::principalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalId").build()).build();

    private static final SdkField<String> INVITEE_PRINCIPAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InviteePrincipalId").getter(getter(ShareResult::inviteePrincipalId))
            .setter(setter(Builder::inviteePrincipalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InviteePrincipalId").build())
            .build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(ShareResult::roleAsString)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ShareResult::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> SHARE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShareId").getter(getter(ShareResult::shareId)).setter(setter(Builder::shareId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareId").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(ShareResult::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_ID_FIELD,
            INVITEE_PRINCIPAL_ID_FIELD, ROLE_FIELD, STATUS_FIELD, SHARE_ID_FIELD, STATUS_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String principalId;

    private final String inviteePrincipalId;

    private final String role;

    private final String status;

    private final String shareId;

    private final String statusMessage;

    private ShareResult(BuilderImpl builder) {
        this.principalId = builder.principalId;
        this.inviteePrincipalId = builder.inviteePrincipalId;
        this.role = builder.role;
        this.status = builder.status;
        this.shareId = builder.shareId;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The ID of the principal.
     * </p>
     * 
     * @return The ID of the principal.
     */
    public final String principalId() {
        return principalId;
    }

    /**
     * <p>
     * The ID of the invited user.
     * </p>
     * 
     * @return The ID of the invited user.
     */
    public final String inviteePrincipalId() {
        return inviteePrincipalId;
    }

    /**
     * <p>
     * The role.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link RoleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The role.
     * @see RoleType
     */
    public final RoleType role() {
        return RoleType.fromValue(role);
    }

    /**
     * <p>
     * The role.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link RoleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The role.
     * @see RoleType
     */
    public final String roleAsString() {
        return role;
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ShareStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see ShareStatusType
     */
    public final ShareStatusType status() {
        return ShareStatusType.fromValue(status);
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ShareStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status.
     * @see ShareStatusType
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The ID of the resource that was shared.
     * </p>
     * 
     * @return The ID of the resource that was shared.
     */
    public final String shareId() {
        return shareId;
    }

    /**
     * <p>
     * The status message.
     * </p>
     * 
     * @return The status message.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(principalId());
        hashCode = 31 * hashCode + Objects.hashCode(inviteePrincipalId());
        hashCode = 31 * hashCode + Objects.hashCode(roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(shareId());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ShareResult)) {
            return false;
        }
        ShareResult other = (ShareResult) obj;
        return Objects.equals(principalId(), other.principalId())
                && Objects.equals(inviteePrincipalId(), other.inviteePrincipalId())
                && Objects.equals(roleAsString(), other.roleAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(shareId(), other.shareId())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ShareResult").add("PrincipalId", principalId()).add("InviteePrincipalId", inviteePrincipalId())
                .add("Role", roleAsString()).add("Status", statusAsString()).add("ShareId", shareId())
                .add("StatusMessage", statusMessage() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrincipalId":
            return Optional.ofNullable(clazz.cast(principalId()));
        case "InviteePrincipalId":
            return Optional.ofNullable(clazz.cast(inviteePrincipalId()));
        case "Role":
            return Optional.ofNullable(clazz.cast(roleAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ShareId":
            return Optional.ofNullable(clazz.cast(shareId()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PrincipalId", PRINCIPAL_ID_FIELD);
        map.put("InviteePrincipalId", INVITEE_PRINCIPAL_ID_FIELD);
        map.put("Role", ROLE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ShareId", SHARE_ID_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ShareResult, T> g) {
        return obj -> g.apply((ShareResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ShareResult> {
        /**
         * <p>
         * The ID of the principal.
         * </p>
         * 
         * @param principalId
         *        The ID of the principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);

        /**
         * <p>
         * The ID of the invited user.
         * </p>
         * 
         * @param inviteePrincipalId
         *        The ID of the invited user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inviteePrincipalId(String inviteePrincipalId);

        /**
         * <p>
         * The role.
         * </p>
         * 
         * @param role
         *        The role.
         * @see RoleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoleType
         */
        Builder role(String role);

        /**
         * <p>
         * The role.
         * </p>
         * 
         * @param role
         *        The role.
         * @see RoleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RoleType
         */
        Builder role(RoleType role);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see ShareStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param status
         *        The status.
         * @see ShareStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareStatusType
         */
        Builder status(ShareStatusType status);

        /**
         * <p>
         * The ID of the resource that was shared.
         * </p>
         * 
         * @param shareId
         *        The ID of the resource that was shared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareId(String shareId);

        /**
         * <p>
         * The status message.
         * </p>
         * 
         * @param statusMessage
         *        The status message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String principalId;

        private String inviteePrincipalId;

        private String role;

        private String status;

        private String shareId;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ShareResult model) {
            principalId(model.principalId);
            inviteePrincipalId(model.inviteePrincipalId);
            role(model.role);
            status(model.status);
            shareId(model.shareId);
            statusMessage(model.statusMessage);
        }

        public final String getPrincipalId() {
            return principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final String getInviteePrincipalId() {
            return inviteePrincipalId;
        }

        public final void setInviteePrincipalId(String inviteePrincipalId) {
            this.inviteePrincipalId = inviteePrincipalId;
        }

        @Override
        public final Builder inviteePrincipalId(String inviteePrincipalId) {
            this.inviteePrincipalId = inviteePrincipalId;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(RoleType role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ShareStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getShareId() {
            return shareId;
        }

        public final void setShareId(String shareId) {
            this.shareId = shareId;
        }

        @Override
        public final Builder shareId(String shareId) {
            this.shareId = shareId;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public ShareResult build() {
            return new ShareResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
