/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a subscription.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Subscription implements SdkPojo, Serializable, ToCopyableBuilder<Subscription.Builder, Subscription> {
    private static final SdkField<String> SUBSCRIPTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionId").getter(getter(Subscription::subscriptionId)).setter(setter(Builder::subscriptionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionId").build()).build();

    private static final SdkField<String> END_POINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndPoint").getter(getter(Subscription::endPoint)).setter(setter(Builder::endPoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndPoint").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(Subscription::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_ID_FIELD,
            END_POINT_FIELD, PROTOCOL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String subscriptionId;

    private final String endPoint;

    private final String protocol;

    private Subscription(BuilderImpl builder) {
        this.subscriptionId = builder.subscriptionId;
        this.endPoint = builder.endPoint;
        this.protocol = builder.protocol;
    }

    /**
     * <p>
     * The ID of the subscription.
     * </p>
     * 
     * @return The ID of the subscription.
     */
    public final String subscriptionId() {
        return subscriptionId;
    }

    /**
     * <p>
     * The endpoint of the subscription.
     * </p>
     * 
     * @return The endpoint of the subscription.
     */
    public final String endPoint() {
        return endPoint;
    }

    /**
     * <p>
     * The protocol of the subscription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link SubscriptionProtocolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol of the subscription.
     * @see SubscriptionProtocolType
     */
    public final SubscriptionProtocolType protocol() {
        return SubscriptionProtocolType.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol of the subscription.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link SubscriptionProtocolType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol of the subscription.
     * @see SubscriptionProtocolType
     */
    public final String protocolAsString() {
        return protocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionId());
        hashCode = 31 * hashCode + Objects.hashCode(endPoint());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription) obj;
        return Objects.equals(subscriptionId(), other.subscriptionId()) && Objects.equals(endPoint(), other.endPoint())
                && Objects.equals(protocolAsString(), other.protocolAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Subscription").add("SubscriptionId", subscriptionId()).add("EndPoint", endPoint())
                .add("Protocol", protocolAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubscriptionId":
            return Optional.ofNullable(clazz.cast(subscriptionId()));
        case "EndPoint":
            return Optional.ofNullable(clazz.cast(endPoint()));
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SubscriptionId", SUBSCRIPTION_ID_FIELD);
        map.put("EndPoint", END_POINT_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Subscription, T> g) {
        return obj -> g.apply((Subscription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Subscription> {
        /**
         * <p>
         * The ID of the subscription.
         * </p>
         * 
         * @param subscriptionId
         *        The ID of the subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionId(String subscriptionId);

        /**
         * <p>
         * The endpoint of the subscription.
         * </p>
         * 
         * @param endPoint
         *        The endpoint of the subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endPoint(String endPoint);

        /**
         * <p>
         * The protocol of the subscription.
         * </p>
         * 
         * @param protocol
         *        The protocol of the subscription.
         * @see SubscriptionProtocolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionProtocolType
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol of the subscription.
         * </p>
         * 
         * @param protocol
         *        The protocol of the subscription.
         * @see SubscriptionProtocolType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubscriptionProtocolType
         */
        Builder protocol(SubscriptionProtocolType protocol);
    }

    static final class BuilderImpl implements Builder {
        private String subscriptionId;

        private String endPoint;

        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(Subscription model) {
            subscriptionId(model.subscriptionId);
            endPoint(model.endPoint);
            protocol(model.protocol);
        }

        public final String getSubscriptionId() {
            return subscriptionId;
        }

        public final void setSubscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
        }

        @Override
        public final Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public final String getEndPoint() {
            return endPoint;
        }

        public final void setEndPoint(String endPoint) {
            this.endPoint = endPoint;
        }

        @Override
        public final Builder endPoint(String endPoint) {
            this.endPoint = endPoint;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(SubscriptionProtocolType protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        @Override
        public Subscription build() {
            return new Subscription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
