/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workdocs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUserRequest extends WorkDocsRequest implements
        ToCopyableBuilder<UpdateUserRequest.Builder, UpdateUserRequest> {
    private static final SdkField<String> AUTHENTICATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationToken").getter(getter(UpdateUserRequest::authenticationToken))
            .setter(setter(Builder::authenticationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Authentication").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(UpdateUserRequest::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("UserId").build()).build();

    private static final SdkField<String> GIVEN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GivenName").getter(getter(UpdateUserRequest::givenName)).setter(setter(Builder::givenName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GivenName").build()).build();

    private static final SdkField<String> SURNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Surname")
            .getter(getter(UpdateUserRequest::surname)).setter(setter(Builder::surname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Surname").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(UpdateUserRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<StorageRuleType> STORAGE_RULE_FIELD = SdkField
            .<StorageRuleType> builder(MarshallingType.SDK_POJO).memberName("StorageRule")
            .getter(getter(UpdateUserRequest::storageRule)).setter(setter(Builder::storageRule))
            .constructor(StorageRuleType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageRule").build()).build();

    private static final SdkField<String> TIME_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeZoneId").getter(getter(UpdateUserRequest::timeZoneId)).setter(setter(Builder::timeZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZoneId").build()).build();

    private static final SdkField<String> LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Locale")
            .getter(getter(UpdateUserRequest::localeAsString)).setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locale").build()).build();

    private static final SdkField<String> GRANT_POWERUSER_PRIVILEGES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GrantPoweruserPrivileges").getter(getter(UpdateUserRequest::grantPoweruserPrivilegesAsString))
            .setter(setter(Builder::grantPoweruserPrivileges))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantPoweruserPrivileges").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TOKEN_FIELD,
            USER_ID_FIELD, GIVEN_NAME_FIELD, SURNAME_FIELD, TYPE_FIELD, STORAGE_RULE_FIELD, TIME_ZONE_ID_FIELD, LOCALE_FIELD,
            GRANT_POWERUSER_PRIVILEGES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String authenticationToken;

    private final String userId;

    private final String givenName;

    private final String surname;

    private final String type;

    private final StorageRuleType storageRule;

    private final String timeZoneId;

    private final String locale;

    private final String grantPoweruserPrivileges;

    private UpdateUserRequest(BuilderImpl builder) {
        super(builder);
        this.authenticationToken = builder.authenticationToken;
        this.userId = builder.userId;
        this.givenName = builder.givenName;
        this.surname = builder.surname;
        this.type = builder.type;
        this.storageRule = builder.storageRule;
        this.timeZoneId = builder.timeZoneId;
        this.locale = builder.locale;
        this.grantPoweruserPrivileges = builder.grantPoweruserPrivileges;
    }

    /**
     * <p>
     * Amazon WorkDocs authentication token. Not required when using Amazon Web Services administrator credentials to
     * access the API.
     * </p>
     * 
     * @return Amazon WorkDocs authentication token. Not required when using Amazon Web Services administrator
     *         credentials to access the API.
     */
    public final String authenticationToken() {
        return authenticationToken;
    }

    /**
     * <p>
     * The ID of the user.
     * </p>
     * 
     * @return The ID of the user.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The given name of the user.
     * </p>
     * 
     * @return The given name of the user.
     */
    public final String givenName() {
        return givenName;
    }

    /**
     * <p>
     * The surname of the user.
     * </p>
     * 
     * @return The surname of the user.
     */
    public final String surname() {
        return surname;
    }

    /**
     * <p>
     * The type of the user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UserType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the user.
     * @see UserType
     */
    public final UserType type() {
        return UserType.fromValue(type);
    }

    /**
     * <p>
     * The type of the user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link UserType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the user.
     * @see UserType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The amount of storage for the user.
     * </p>
     * 
     * @return The amount of storage for the user.
     */
    public final StorageRuleType storageRule() {
        return storageRule;
    }

    /**
     * <p>
     * The time zone ID of the user.
     * </p>
     * 
     * @return The time zone ID of the user.
     */
    public final String timeZoneId() {
        return timeZoneId;
    }

    /**
     * <p>
     * The locale of the user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link LocaleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return The locale of the user.
     * @see LocaleType
     */
    public final LocaleType locale() {
        return LocaleType.fromValue(locale);
    }

    /**
     * <p>
     * The locale of the user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #locale} will
     * return {@link LocaleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #localeAsString}.
     * </p>
     * 
     * @return The locale of the user.
     * @see LocaleType
     */
    public final String localeAsString() {
        return locale;
    }

    /**
     * <p>
     * Boolean value to determine whether the user is granted Power user privileges.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #grantPoweruserPrivileges} will return {@link BooleanEnumType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #grantPoweruserPrivilegesAsString}.
     * </p>
     * 
     * @return Boolean value to determine whether the user is granted Power user privileges.
     * @see BooleanEnumType
     */
    public final BooleanEnumType grantPoweruserPrivileges() {
        return BooleanEnumType.fromValue(grantPoweruserPrivileges);
    }

    /**
     * <p>
     * Boolean value to determine whether the user is granted Power user privileges.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #grantPoweruserPrivileges} will return {@link BooleanEnumType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #grantPoweruserPrivilegesAsString}.
     * </p>
     * 
     * @return Boolean value to determine whether the user is granted Power user privileges.
     * @see BooleanEnumType
     */
    public final String grantPoweruserPrivilegesAsString() {
        return grantPoweruserPrivileges;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authenticationToken());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(givenName());
        hashCode = 31 * hashCode + Objects.hashCode(surname());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(storageRule());
        hashCode = 31 * hashCode + Objects.hashCode(timeZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(localeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(grantPoweruserPrivilegesAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserRequest)) {
            return false;
        }
        UpdateUserRequest other = (UpdateUserRequest) obj;
        return Objects.equals(authenticationToken(), other.authenticationToken()) && Objects.equals(userId(), other.userId())
                && Objects.equals(givenName(), other.givenName()) && Objects.equals(surname(), other.surname())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(storageRule(), other.storageRule())
                && Objects.equals(timeZoneId(), other.timeZoneId()) && Objects.equals(localeAsString(), other.localeAsString())
                && Objects.equals(grantPoweruserPrivilegesAsString(), other.grantPoweruserPrivilegesAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateUserRequest")
                .add("AuthenticationToken", authenticationToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UserId", userId()).add("GivenName", givenName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Surname", surname() == null ? null : "*** Sensitive Data Redacted ***").add("Type", typeAsString())
                .add("StorageRule", storageRule()).add("TimeZoneId", timeZoneId()).add("Locale", localeAsString())
                .add("GrantPoweruserPrivileges", grantPoweruserPrivilegesAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AuthenticationToken":
            return Optional.ofNullable(clazz.cast(authenticationToken()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "GivenName":
            return Optional.ofNullable(clazz.cast(givenName()));
        case "Surname":
            return Optional.ofNullable(clazz.cast(surname()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "StorageRule":
            return Optional.ofNullable(clazz.cast(storageRule()));
        case "TimeZoneId":
            return Optional.ofNullable(clazz.cast(timeZoneId()));
        case "Locale":
            return Optional.ofNullable(clazz.cast(localeAsString()));
        case "GrantPoweruserPrivileges":
            return Optional.ofNullable(clazz.cast(grantPoweruserPrivilegesAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Authentication", AUTHENTICATION_TOKEN_FIELD);
        map.put("UserId", USER_ID_FIELD);
        map.put("GivenName", GIVEN_NAME_FIELD);
        map.put("Surname", SURNAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("StorageRule", STORAGE_RULE_FIELD);
        map.put("TimeZoneId", TIME_ZONE_ID_FIELD);
        map.put("Locale", LOCALE_FIELD);
        map.put("GrantPoweruserPrivileges", GRANT_POWERUSER_PRIVILEGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserRequest, T> g) {
        return obj -> g.apply((UpdateUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkDocsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateUserRequest> {
        /**
         * <p>
         * Amazon WorkDocs authentication token. Not required when using Amazon Web Services administrator credentials
         * to access the API.
         * </p>
         * 
         * @param authenticationToken
         *        Amazon WorkDocs authentication token. Not required when using Amazon Web Services administrator
         *        credentials to access the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationToken(String authenticationToken);

        /**
         * <p>
         * The ID of the user.
         * </p>
         * 
         * @param userId
         *        The ID of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The given name of the user.
         * </p>
         * 
         * @param givenName
         *        The given name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder givenName(String givenName);

        /**
         * <p>
         * The surname of the user.
         * </p>
         * 
         * @param surname
         *        The surname of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder surname(String surname);

        /**
         * <p>
         * The type of the user.
         * </p>
         * 
         * @param type
         *        The type of the user.
         * @see UserType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the user.
         * </p>
         * 
         * @param type
         *        The type of the user.
         * @see UserType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserType
         */
        Builder type(UserType type);

        /**
         * <p>
         * The amount of storage for the user.
         * </p>
         * 
         * @param storageRule
         *        The amount of storage for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageRule(StorageRuleType storageRule);

        /**
         * <p>
         * The amount of storage for the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link StorageRuleType.Builder} avoiding the
         * need to create one manually via {@link StorageRuleType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StorageRuleType.Builder#build()} is called immediately and its
         * result is passed to {@link #storageRule(StorageRuleType)}.
         * 
         * @param storageRule
         *        a consumer that will call methods on {@link StorageRuleType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageRule(StorageRuleType)
         */
        default Builder storageRule(Consumer<StorageRuleType.Builder> storageRule) {
            return storageRule(StorageRuleType.builder().applyMutation(storageRule).build());
        }

        /**
         * <p>
         * The time zone ID of the user.
         * </p>
         * 
         * @param timeZoneId
         *        The time zone ID of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeZoneId(String timeZoneId);

        /**
         * <p>
         * The locale of the user.
         * </p>
         * 
         * @param locale
         *        The locale of the user.
         * @see LocaleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocaleType
         */
        Builder locale(String locale);

        /**
         * <p>
         * The locale of the user.
         * </p>
         * 
         * @param locale
         *        The locale of the user.
         * @see LocaleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LocaleType
         */
        Builder locale(LocaleType locale);

        /**
         * <p>
         * Boolean value to determine whether the user is granted Power user privileges.
         * </p>
         * 
         * @param grantPoweruserPrivileges
         *        Boolean value to determine whether the user is granted Power user privileges.
         * @see BooleanEnumType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BooleanEnumType
         */
        Builder grantPoweruserPrivileges(String grantPoweruserPrivileges);

        /**
         * <p>
         * Boolean value to determine whether the user is granted Power user privileges.
         * </p>
         * 
         * @param grantPoweruserPrivileges
         *        Boolean value to determine whether the user is granted Power user privileges.
         * @see BooleanEnumType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BooleanEnumType
         */
        Builder grantPoweruserPrivileges(BooleanEnumType grantPoweruserPrivileges);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkDocsRequest.BuilderImpl implements Builder {
        private String authenticationToken;

        private String userId;

        private String givenName;

        private String surname;

        private String type;

        private StorageRuleType storageRule;

        private String timeZoneId;

        private String locale;

        private String grantPoweruserPrivileges;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserRequest model) {
            super(model);
            authenticationToken(model.authenticationToken);
            userId(model.userId);
            givenName(model.givenName);
            surname(model.surname);
            type(model.type);
            storageRule(model.storageRule);
            timeZoneId(model.timeZoneId);
            locale(model.locale);
            grantPoweruserPrivileges(model.grantPoweruserPrivileges);
        }

        public final String getAuthenticationToken() {
            return authenticationToken;
        }

        public final void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        @Override
        public final Builder authenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
            return this;
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getGivenName() {
            return givenName;
        }

        public final void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        @Override
        public final Builder givenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public final String getSurname() {
            return surname;
        }

        public final void setSurname(String surname) {
            this.surname = surname;
        }

        @Override
        public final Builder surname(String surname) {
            this.surname = surname;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(UserType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final StorageRuleType.Builder getStorageRule() {
            return storageRule != null ? storageRule.toBuilder() : null;
        }

        public final void setStorageRule(StorageRuleType.BuilderImpl storageRule) {
            this.storageRule = storageRule != null ? storageRule.build() : null;
        }

        @Override
        public final Builder storageRule(StorageRuleType storageRule) {
            this.storageRule = storageRule;
            return this;
        }

        public final String getTimeZoneId() {
            return timeZoneId;
        }

        public final void setTimeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
        }

        @Override
        public final Builder timeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return this;
        }

        public final String getLocale() {
            return locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public final Builder locale(LocaleType locale) {
            this.locale(locale == null ? null : locale.toString());
            return this;
        }

        public final String getGrantPoweruserPrivileges() {
            return grantPoweruserPrivileges;
        }

        public final void setGrantPoweruserPrivileges(String grantPoweruserPrivileges) {
            this.grantPoweruserPrivileges = grantPoweruserPrivileges;
        }

        @Override
        public final Builder grantPoweruserPrivileges(String grantPoweruserPrivileges) {
            this.grantPoweruserPrivileges = grantPoweruserPrivileges;
            return this;
        }

        @Override
        public final Builder grantPoweruserPrivileges(BooleanEnumType grantPoweruserPrivileges) {
            this.grantPoweruserPrivileges(grantPoweruserPrivileges == null ? null : grantPoweruserPrivileges.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserRequest build() {
            return new UpdateUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
