/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.workdocs.WorkDocsAsyncClient;
import software.amazon.awssdk.services.workdocs.WorkDocsServiceClientConfiguration;
import software.amazon.awssdk.services.workdocs.internal.WorkDocsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.workdocs.model.AbortDocumentVersionUploadRequest;
import software.amazon.awssdk.services.workdocs.model.AbortDocumentVersionUploadResponse;
import software.amazon.awssdk.services.workdocs.model.ActivateUserRequest;
import software.amazon.awssdk.services.workdocs.model.ActivateUserResponse;
import software.amazon.awssdk.services.workdocs.model.AddResourcePermissionsRequest;
import software.amazon.awssdk.services.workdocs.model.AddResourcePermissionsResponse;
import software.amazon.awssdk.services.workdocs.model.ConcurrentModificationException;
import software.amazon.awssdk.services.workdocs.model.ConflictingOperationException;
import software.amazon.awssdk.services.workdocs.model.CreateCommentRequest;
import software.amazon.awssdk.services.workdocs.model.CreateCommentResponse;
import software.amazon.awssdk.services.workdocs.model.CreateCustomMetadataRequest;
import software.amazon.awssdk.services.workdocs.model.CreateCustomMetadataResponse;
import software.amazon.awssdk.services.workdocs.model.CreateFolderRequest;
import software.amazon.awssdk.services.workdocs.model.CreateFolderResponse;
import software.amazon.awssdk.services.workdocs.model.CreateLabelsRequest;
import software.amazon.awssdk.services.workdocs.model.CreateLabelsResponse;
import software.amazon.awssdk.services.workdocs.model.CreateNotificationSubscriptionRequest;
import software.amazon.awssdk.services.workdocs.model.CreateNotificationSubscriptionResponse;
import software.amazon.awssdk.services.workdocs.model.CreateUserRequest;
import software.amazon.awssdk.services.workdocs.model.CreateUserResponse;
import software.amazon.awssdk.services.workdocs.model.CustomMetadataLimitExceededException;
import software.amazon.awssdk.services.workdocs.model.DeactivateUserRequest;
import software.amazon.awssdk.services.workdocs.model.DeactivateUserResponse;
import software.amazon.awssdk.services.workdocs.model.DeactivatingLastSystemUserException;
import software.amazon.awssdk.services.workdocs.model.DeleteCommentRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteCommentResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteCustomMetadataRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteCustomMetadataResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteDocumentRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteDocumentResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteDocumentVersionRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteDocumentVersionResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteFolderContentsRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteFolderContentsResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteFolderRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteFolderResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteLabelsRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteLabelsResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteNotificationSubscriptionRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteNotificationSubscriptionResponse;
import software.amazon.awssdk.services.workdocs.model.DeleteUserRequest;
import software.amazon.awssdk.services.workdocs.model.DeleteUserResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeActivitiesResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeCommentsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeCommentsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeGroupsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeGroupsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeResourcePermissionsResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersResponse;
import software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeUsersResponse;
import software.amazon.awssdk.services.workdocs.model.DocumentLockedForCommentsException;
import software.amazon.awssdk.services.workdocs.model.DraftUploadOutOfSyncException;
import software.amazon.awssdk.services.workdocs.model.EntityAlreadyExistsException;
import software.amazon.awssdk.services.workdocs.model.EntityNotExistsException;
import software.amazon.awssdk.services.workdocs.model.FailedDependencyException;
import software.amazon.awssdk.services.workdocs.model.GetCurrentUserRequest;
import software.amazon.awssdk.services.workdocs.model.GetCurrentUserResponse;
import software.amazon.awssdk.services.workdocs.model.GetDocumentPathRequest;
import software.amazon.awssdk.services.workdocs.model.GetDocumentPathResponse;
import software.amazon.awssdk.services.workdocs.model.GetDocumentRequest;
import software.amazon.awssdk.services.workdocs.model.GetDocumentResponse;
import software.amazon.awssdk.services.workdocs.model.GetDocumentVersionRequest;
import software.amazon.awssdk.services.workdocs.model.GetDocumentVersionResponse;
import software.amazon.awssdk.services.workdocs.model.GetFolderPathRequest;
import software.amazon.awssdk.services.workdocs.model.GetFolderPathResponse;
import software.amazon.awssdk.services.workdocs.model.GetFolderRequest;
import software.amazon.awssdk.services.workdocs.model.GetFolderResponse;
import software.amazon.awssdk.services.workdocs.model.GetResourcesRequest;
import software.amazon.awssdk.services.workdocs.model.GetResourcesResponse;
import software.amazon.awssdk.services.workdocs.model.IllegalUserStateException;
import software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadRequest;
import software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadResponse;
import software.amazon.awssdk.services.workdocs.model.InvalidArgumentException;
import software.amazon.awssdk.services.workdocs.model.InvalidCommentOperationException;
import software.amazon.awssdk.services.workdocs.model.InvalidOperationException;
import software.amazon.awssdk.services.workdocs.model.InvalidPasswordException;
import software.amazon.awssdk.services.workdocs.model.LimitExceededException;
import software.amazon.awssdk.services.workdocs.model.ProhibitedStateException;
import software.amazon.awssdk.services.workdocs.model.RemoveAllResourcePermissionsRequest;
import software.amazon.awssdk.services.workdocs.model.RemoveAllResourcePermissionsResponse;
import software.amazon.awssdk.services.workdocs.model.RemoveResourcePermissionRequest;
import software.amazon.awssdk.services.workdocs.model.RemoveResourcePermissionResponse;
import software.amazon.awssdk.services.workdocs.model.RequestedEntityTooLargeException;
import software.amazon.awssdk.services.workdocs.model.ResourceAlreadyCheckedOutException;
import software.amazon.awssdk.services.workdocs.model.RestoreDocumentVersionsRequest;
import software.amazon.awssdk.services.workdocs.model.RestoreDocumentVersionsResponse;
import software.amazon.awssdk.services.workdocs.model.SearchResourcesRequest;
import software.amazon.awssdk.services.workdocs.model.SearchResourcesResponse;
import software.amazon.awssdk.services.workdocs.model.ServiceUnavailableException;
import software.amazon.awssdk.services.workdocs.model.StorageLimitExceededException;
import software.amazon.awssdk.services.workdocs.model.StorageLimitWillExceedException;
import software.amazon.awssdk.services.workdocs.model.TooManyLabelsException;
import software.amazon.awssdk.services.workdocs.model.TooManySubscriptionsException;
import software.amazon.awssdk.services.workdocs.model.UnauthorizedOperationException;
import software.amazon.awssdk.services.workdocs.model.UnauthorizedResourceAccessException;
import software.amazon.awssdk.services.workdocs.model.UpdateDocumentRequest;
import software.amazon.awssdk.services.workdocs.model.UpdateDocumentResponse;
import software.amazon.awssdk.services.workdocs.model.UpdateDocumentVersionRequest;
import software.amazon.awssdk.services.workdocs.model.UpdateDocumentVersionResponse;
import software.amazon.awssdk.services.workdocs.model.UpdateFolderRequest;
import software.amazon.awssdk.services.workdocs.model.UpdateFolderResponse;
import software.amazon.awssdk.services.workdocs.model.UpdateUserRequest;
import software.amazon.awssdk.services.workdocs.model.UpdateUserResponse;
import software.amazon.awssdk.services.workdocs.model.WorkDocsException;
import software.amazon.awssdk.services.workdocs.transform.AbortDocumentVersionUploadRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.ActivateUserRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.AddResourcePermissionsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateCommentRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateCustomMetadataRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateFolderRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateLabelsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateNotificationSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeactivateUserRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteCommentRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteCustomMetadataRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteDocumentRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteDocumentVersionRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteFolderContentsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteFolderRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteLabelsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteNotificationSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeActivitiesRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeCommentsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeDocumentVersionsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeFolderContentsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeGroupsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeNotificationSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeResourcePermissionsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeRootFoldersRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.DescribeUsersRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetCurrentUserRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetDocumentPathRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetDocumentRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetDocumentVersionRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetFolderPathRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetFolderRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.GetResourcesRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.InitiateDocumentVersionUploadRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.RemoveAllResourcePermissionsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.RemoveResourcePermissionRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.RestoreDocumentVersionsRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.SearchResourcesRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.UpdateDocumentRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.UpdateDocumentVersionRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.UpdateFolderRequestMarshaller;
import software.amazon.awssdk.services.workdocs.transform.UpdateUserRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultWorkDocsAsyncClient
implements WorkDocsAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkDocsAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultWorkDocsAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"WorkDocs#2.33.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<AbortDocumentVersionUploadResponse> abortDocumentVersionUpload(AbortDocumentVersionUploadRequest abortDocumentVersionUploadRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)abortDocumentVersionUploadRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, abortDocumentVersionUploadRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AbortDocumentVersionUpload");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AbortDocumentVersionUploadResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AbortDocumentVersionUpload").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AbortDocumentVersionUploadRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)abortDocumentVersionUploadRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$abortDocumentVersionUpload$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$abortDocumentVersionUpload$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ActivateUserResponse> activateUser(ActivateUserRequest activateUserRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)activateUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, activateUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ActivateUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ActivateUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ActivateUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ActivateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)activateUserRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$activateUser$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$activateUser$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddResourcePermissionsResponse> addResourcePermissions(AddResourcePermissionsRequest addResourcePermissionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addResourcePermissionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, addResourcePermissionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddResourcePermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddResourcePermissionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddResourcePermissions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddResourcePermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addResourcePermissionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$addResourcePermissions$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$addResourcePermissions$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCommentResponse> createComment(CreateCommentRequest createCommentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCommentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, createCommentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateComment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCommentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateComment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateCommentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createCommentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$createComment$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$createComment$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCustomMetadataResponse> createCustomMetadata(CreateCustomMetadataRequest createCustomMetadataRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCustomMetadataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, createCustomMetadataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCustomMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCustomMetadataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCustomMetadata").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateCustomMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createCustomMetadataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$createCustomMetadata$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$createCustomMetadata$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateFolderResponse> createFolder(CreateFolderRequest createFolderRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createFolderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, createFolderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFolder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFolderResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFolder").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateFolderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createFolderRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$createFolder$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$createFolder$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLabelsResponse> createLabels(CreateLabelsRequest createLabelsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLabelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, createLabelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLabels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLabelsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLabels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateLabelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createLabelsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$createLabels$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$createLabels$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateNotificationSubscriptionResponse> createNotificationSubscription(CreateNotificationSubscriptionRequest createNotificationSubscriptionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createNotificationSubscriptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, createNotificationSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateNotificationSubscription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateNotificationSubscriptionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateNotificationSubscription").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateNotificationSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createNotificationSubscriptionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$createNotificationSubscription$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$createNotificationSubscription$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateUserResponse> createUser(CreateUserRequest createUserRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, createUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createUserRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$createUser$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$createUser$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeactivateUserResponse> deactivateUser(DeactivateUserRequest deactivateUserRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deactivateUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, deactivateUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeactivateUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeactivateUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeactivateUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeactivateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deactivateUserRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$deactivateUser$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$deactivateUser$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCommentResponse> deleteComment(DeleteCommentRequest deleteCommentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCommentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteCommentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteComment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCommentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteComment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteCommentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteCommentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$deleteComment$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$deleteComment$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCustomMetadataResponse> deleteCustomMetadata(DeleteCustomMetadataRequest deleteCustomMetadataRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCustomMetadataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteCustomMetadataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCustomMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCustomMetadataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCustomMetadata").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteCustomMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteCustomMetadataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$deleteCustomMetadata$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$deleteCustomMetadata$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDocumentResponse> deleteDocument(DeleteDocumentRequest deleteDocumentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDocumentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteDocumentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDocument");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDocumentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDocument").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteDocumentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDocumentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$deleteDocument$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$deleteDocument$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDocumentVersionResponse> deleteDocumentVersion(DeleteDocumentVersionRequest deleteDocumentVersionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDocumentVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteDocumentVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDocumentVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDocumentVersionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDocumentVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteDocumentVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDocumentVersionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$deleteDocumentVersion$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$deleteDocumentVersion$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteFolderResponse> deleteFolder(DeleteFolderRequest deleteFolderRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteFolderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteFolderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFolder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFolderResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFolder").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteFolderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteFolderRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$deleteFolder$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$deleteFolder$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteFolderContentsResponse> deleteFolderContents(DeleteFolderContentsRequest deleteFolderContentsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteFolderContentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteFolderContentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFolderContents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFolderContentsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFolderContents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteFolderContentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteFolderContentsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$deleteFolderContents$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$deleteFolderContents$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLabelsResponse> deleteLabels(DeleteLabelsRequest deleteLabelsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLabelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteLabelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLabels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLabelsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLabels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteLabelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteLabelsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$deleteLabels$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$deleteLabels$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteNotificationSubscriptionResponse> deleteNotificationSubscription(DeleteNotificationSubscriptionRequest deleteNotificationSubscriptionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteNotificationSubscriptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteNotificationSubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteNotificationSubscription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteNotificationSubscriptionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteNotificationSubscription").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteNotificationSubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteNotificationSubscriptionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$deleteNotificationSubscription$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$deleteNotificationSubscription$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, deleteUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteUserRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$deleteUser$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$deleteUser$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeActivitiesResponse> describeActivities(DescribeActivitiesRequest describeActivitiesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeActivitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, describeActivitiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeActivities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeActivitiesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeActivities").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeActivitiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeActivitiesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$describeActivities$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$describeActivities$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeCommentsResponse> describeComments(DescribeCommentsRequest describeCommentsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCommentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, describeCommentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeComments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCommentsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeComments").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeCommentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeCommentsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$describeComments$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$describeComments$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDocumentVersionsResponse> describeDocumentVersions(DescribeDocumentVersionsRequest describeDocumentVersionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDocumentVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, describeDocumentVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDocumentVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDocumentVersionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDocumentVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeDocumentVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeDocumentVersionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$describeDocumentVersions$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$describeDocumentVersions$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeFolderContentsResponse> describeFolderContents(DescribeFolderContentsRequest describeFolderContentsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFolderContentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, describeFolderContentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFolderContents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFolderContentsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFolderContents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeFolderContentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeFolderContentsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$describeFolderContents$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$describeFolderContents$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeGroupsResponse> describeGroups(DescribeGroupsRequest describeGroupsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, describeGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeGroupsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$describeGroups$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$describeGroups$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeNotificationSubscriptionsResponse> describeNotificationSubscriptions(DescribeNotificationSubscriptionsRequest describeNotificationSubscriptionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeNotificationSubscriptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, describeNotificationSubscriptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeNotificationSubscriptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeNotificationSubscriptionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeNotificationSubscriptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeNotificationSubscriptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeNotificationSubscriptionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$describeNotificationSubscriptions$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$describeNotificationSubscriptions$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeResourcePermissionsResponse> describeResourcePermissions(DescribeResourcePermissionsRequest describeResourcePermissionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeResourcePermissionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, describeResourcePermissionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeResourcePermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeResourcePermissionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeResourcePermissions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeResourcePermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeResourcePermissionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$describeResourcePermissions$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$describeResourcePermissions$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeRootFoldersResponse> describeRootFolders(DescribeRootFoldersRequest describeRootFoldersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeRootFoldersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, describeRootFoldersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRootFolders");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRootFoldersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRootFolders").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeRootFoldersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeRootFoldersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$describeRootFolders$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$describeRootFolders$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeUsersResponse> describeUsers(DescribeUsersRequest describeUsersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeUsersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, describeUsersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeUsers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeUsersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeUsers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeUsersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeUsersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$describeUsers$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$describeUsers$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCurrentUserResponse> getCurrentUser(GetCurrentUserRequest getCurrentUserRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCurrentUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, getCurrentUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCurrentUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCurrentUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCurrentUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetCurrentUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCurrentUserRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$getCurrentUser$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$getCurrentUser$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDocumentResponse> getDocument(GetDocumentRequest getDocumentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDocumentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, getDocumentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDocument");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDocumentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDocument").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDocumentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDocumentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$getDocument$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$getDocument$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDocumentPathResponse> getDocumentPath(GetDocumentPathRequest getDocumentPathRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDocumentPathRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, getDocumentPathRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDocumentPath");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDocumentPathResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDocumentPath").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDocumentPathRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDocumentPathRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$getDocumentPath$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$getDocumentPath$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDocumentVersionResponse> getDocumentVersion(GetDocumentVersionRequest getDocumentVersionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDocumentVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, getDocumentVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDocumentVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDocumentVersionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDocumentVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDocumentVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDocumentVersionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$getDocumentVersion$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$getDocumentVersion$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetFolderResponse> getFolder(GetFolderRequest getFolderRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getFolderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, getFolderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFolder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFolderResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFolder").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetFolderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getFolderRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$getFolder$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$getFolder$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetFolderPathResponse> getFolderPath(GetFolderPathRequest getFolderPathRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getFolderPathRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, getFolderPathRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFolderPath");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFolderPathResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFolderPath").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetFolderPathRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getFolderPathRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$getFolderPath$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$getFolderPath$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetResourcesResponse> getResources(GetResourcesRequest getResourcesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, getResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourcesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getResourcesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$getResources$138(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$getResources$139((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<InitiateDocumentVersionUploadResponse> initiateDocumentVersionUpload(InitiateDocumentVersionUploadRequest initiateDocumentVersionUploadRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)initiateDocumentVersionUploadRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, initiateDocumentVersionUploadRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"InitiateDocumentVersionUpload");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InitiateDocumentVersionUploadResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("InitiateDocumentVersionUpload").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new InitiateDocumentVersionUploadRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)initiateDocumentVersionUploadRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$initiateDocumentVersionUpload$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$initiateDocumentVersionUpload$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveAllResourcePermissionsResponse> removeAllResourcePermissions(RemoveAllResourcePermissionsRequest removeAllResourcePermissionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeAllResourcePermissionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, removeAllResourcePermissionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveAllResourcePermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveAllResourcePermissionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveAllResourcePermissions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RemoveAllResourcePermissionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)removeAllResourcePermissionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$removeAllResourcePermissions$146(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$removeAllResourcePermissions$147((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveResourcePermissionResponse> removeResourcePermission(RemoveResourcePermissionRequest removeResourcePermissionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeResourcePermissionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, removeResourcePermissionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveResourcePermission");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveResourcePermissionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveResourcePermission").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RemoveResourcePermissionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)removeResourcePermissionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$removeResourcePermission$150(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$removeResourcePermission$151((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RestoreDocumentVersionsResponse> restoreDocumentVersions(RestoreDocumentVersionsRequest restoreDocumentVersionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)restoreDocumentVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, restoreDocumentVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreDocumentVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreDocumentVersionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreDocumentVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RestoreDocumentVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)restoreDocumentVersionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$restoreDocumentVersions$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$restoreDocumentVersions$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SearchResourcesResponse> searchResources(SearchResourcesRequest searchResourcesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)searchResourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, searchResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SearchResources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SearchResourcesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SearchResources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new SearchResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)searchResourcesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$searchResources$158(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$searchResources$159((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDocumentResponse> updateDocument(UpdateDocumentRequest updateDocumentRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDocumentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, updateDocumentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDocument");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDocumentResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDocument").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateDocumentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateDocumentRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$updateDocument$162(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$updateDocument$163((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDocumentVersionResponse> updateDocumentVersion(UpdateDocumentVersionRequest updateDocumentVersionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDocumentVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, updateDocumentVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDocumentVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDocumentVersionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDocumentVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateDocumentVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateDocumentVersionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$updateDocumentVersion$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$updateDocumentVersion$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateFolderResponse> updateFolder(UpdateFolderRequest updateFolderRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateFolderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, updateFolderRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFolder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFolderResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFolder").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateFolderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateFolderRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$updateFolder$170(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$updateFolder$171((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateUserResponse> updateUser(UpdateUserRequest updateUserRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateUserRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkDocsAsyncClient.resolveMetricPublishers(clientConfiguration, updateUserRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkDocs");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateUserResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "FailedDependencyException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("FailedDependencyException").httpStatusCode(Integer.valueOf(424)).exceptionBuilderSupplier(FailedDependencyException::builder).build());
                    }
                    case "ConcurrentModificationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                    }
                    case "InvalidOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidOperationException").httpStatusCode(Integer.valueOf(405)).exceptionBuilderSupplier(InvalidOperationException::builder).build());
                    }
                    case "CustomMetadataLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CustomMetadataLimitExceededException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(CustomMetadataLimitExceededException::builder).build());
                    }
                    case "UnauthorizedResourceAccessException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedResourceAccessException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(UnauthorizedResourceAccessException::builder).build());
                    }
                    case "TooManySubscriptionsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManySubscriptionsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManySubscriptionsException::builder).build());
                    }
                    case "EntityAlreadyExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
                    }
                    case "EntityNotExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("EntityNotExistsException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(EntityNotExistsException::builder).build());
                    }
                    case "DocumentLockedForCommentsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DocumentLockedForCommentsException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DocumentLockedForCommentsException::builder).build());
                    }
                    case "StorageLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(StorageLimitExceededException::builder).build());
                    }
                    case "StorageLimitWillExceedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StorageLimitWillExceedException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(StorageLimitWillExceedException::builder).build());
                    }
                    case "ProhibitedStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ProhibitedStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ProhibitedStateException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "IllegalUserStateException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("IllegalUserStateException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(IllegalUserStateException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "ConflictingOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictingOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictingOperationException::builder).build());
                    }
                    case "InvalidCommentOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCommentOperationException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(InvalidCommentOperationException::builder).build());
                    }
                    case "InvalidPasswordException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(InvalidPasswordException::builder).build());
                    }
                    case "UnauthorizedOperationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnauthorizedOperationException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(UnauthorizedOperationException::builder).build());
                    }
                    case "TooManyLabelsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyLabelsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyLabelsException::builder).build());
                    }
                    case "DraftUploadOutOfSyncException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DraftUploadOutOfSyncException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DraftUploadOutOfSyncException::builder).build());
                    }
                    case "ResourceAlreadyCheckedOutException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyCheckedOutException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ResourceAlreadyCheckedOutException::builder).build());
                    }
                    case "RequestedEntityTooLargeException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestedEntityTooLargeException").httpStatusCode(Integer.valueOf(413)).exceptionBuilderSupplier(RequestedEntityTooLargeException::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "DeactivatingLastSystemUserException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeactivatingLastSystemUserException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(DeactivatingLastSystemUserException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateUser").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateUserRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultWorkDocsAsyncClient.lambda$updateUser$174(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultWorkDocsAsyncClient.lambda$updateUser$175((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final WorkDocsServiceClientConfiguration serviceClientConfiguration() {
        return new WorkDocsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "workdocs";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(WorkDocsException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        WorkDocsServiceClientConfigurationBuilder serviceConfigBuilder = new WorkDocsServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateUser$175(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateUser$174(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateUserResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateFolder$171(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFolder$170(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateFolderResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateDocumentVersion$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDocumentVersion$166(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateDocumentVersionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateDocument$163(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDocument$162(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateDocumentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$searchResources$159(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$searchResources$158(List metricPublishers, MetricCollector apiCallMetricCollector, SearchResourcesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$restoreDocumentVersions$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreDocumentVersions$154(List metricPublishers, MetricCollector apiCallMetricCollector, RestoreDocumentVersionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$removeResourcePermission$151(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeResourcePermission$150(List metricPublishers, MetricCollector apiCallMetricCollector, RemoveResourcePermissionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$removeAllResourcePermissions$147(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeAllResourcePermissions$146(List metricPublishers, MetricCollector apiCallMetricCollector, RemoveAllResourcePermissionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$initiateDocumentVersionUpload$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$initiateDocumentVersionUpload$142(List metricPublishers, MetricCollector apiCallMetricCollector, InitiateDocumentVersionUploadResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getResources$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getResources$138(List metricPublishers, MetricCollector apiCallMetricCollector, GetResourcesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getFolderPath$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFolderPath$134(List metricPublishers, MetricCollector apiCallMetricCollector, GetFolderPathResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getFolder$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getFolder$130(List metricPublishers, MetricCollector apiCallMetricCollector, GetFolderResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDocumentVersion$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDocumentVersion$126(List metricPublishers, MetricCollector apiCallMetricCollector, GetDocumentVersionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDocumentPath$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDocumentPath$122(List metricPublishers, MetricCollector apiCallMetricCollector, GetDocumentPathResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDocument$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDocument$118(List metricPublishers, MetricCollector apiCallMetricCollector, GetDocumentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCurrentUser$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCurrentUser$114(List metricPublishers, MetricCollector apiCallMetricCollector, GetCurrentUserResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeUsers$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeUsers$110(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeUsersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeRootFolders$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRootFolders$106(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeRootFoldersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeResourcePermissions$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeResourcePermissions$102(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeResourcePermissionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeNotificationSubscriptions$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeNotificationSubscriptions$98(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeNotificationSubscriptionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeGroups$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeGroups$94(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeGroupsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeFolderContents$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFolderContents$90(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeFolderContentsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeDocumentVersions$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDocumentVersions$86(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeDocumentVersionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeComments$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeComments$82(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeCommentsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeActivities$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeActivities$78(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeActivitiesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteUser$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteUser$74(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteUserResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteNotificationSubscription$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteNotificationSubscription$70(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteNotificationSubscriptionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteLabels$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLabels$66(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteLabelsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteFolderContents$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFolderContents$62(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteFolderContentsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteFolder$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFolder$58(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteFolderResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteDocumentVersion$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDocumentVersion$54(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteDocumentVersionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteDocument$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDocument$50(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteDocumentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteCustomMetadata$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCustomMetadata$46(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteCustomMetadataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteComment$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteComment$42(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteCommentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deactivateUser$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deactivateUser$38(List metricPublishers, MetricCollector apiCallMetricCollector, DeactivateUserResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createUser$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createUser$34(List metricPublishers, MetricCollector apiCallMetricCollector, CreateUserResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createNotificationSubscription$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createNotificationSubscription$30(List metricPublishers, MetricCollector apiCallMetricCollector, CreateNotificationSubscriptionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createLabels$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLabels$26(List metricPublishers, MetricCollector apiCallMetricCollector, CreateLabelsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createFolder$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFolder$22(List metricPublishers, MetricCollector apiCallMetricCollector, CreateFolderResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCustomMetadata$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCustomMetadata$18(List metricPublishers, MetricCollector apiCallMetricCollector, CreateCustomMetadataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createComment$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createComment$14(List metricPublishers, MetricCollector apiCallMetricCollector, CreateCommentResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addResourcePermissions$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addResourcePermissions$10(List metricPublishers, MetricCollector apiCallMetricCollector, AddResourcePermissionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$activateUser$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$activateUser$6(List metricPublishers, MetricCollector apiCallMetricCollector, ActivateUserResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$abortDocumentVersionUpload$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$abortDocumentVersionUpload$2(List metricPublishers, MetricCollector apiCallMetricCollector, AbortDocumentVersionUploadResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

