/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.worklink.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.worklink.model.FleetStatus;
import software.amazon.awssdk.services.worklink.model.WorkLinkResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeFleetMetadataResponse
extends WorkLinkResponse
implements ToCopyableBuilder<Builder, DescribeFleetMetadataResponse> {
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeFleetMetadataResponse.getter(DescribeFleetMetadataResponse::createdTime)).setter(DescribeFleetMetadataResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeFleetMetadataResponse.getter(DescribeFleetMetadataResponse::lastUpdatedTime)).setter(DescribeFleetMetadataResponse.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<String> FLEET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeFleetMetadataResponse.getter(DescribeFleetMetadataResponse::fleetName)).setter(DescribeFleetMetadataResponse.setter(Builder::fleetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetName").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeFleetMetadataResponse.getter(DescribeFleetMetadataResponse::displayName)).setter(DescribeFleetMetadataResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<Boolean> OPTIMIZE_FOR_END_USER_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(DescribeFleetMetadataResponse.getter(DescribeFleetMetadataResponse::optimizeForEndUserLocation)).setter(DescribeFleetMetadataResponse.setter(Builder::optimizeForEndUserLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizeForEndUserLocation").build()}).build();
    private static final SdkField<String> COMPANY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeFleetMetadataResponse.getter(DescribeFleetMetadataResponse::companyCode)).setter(DescribeFleetMetadataResponse.setter(Builder::companyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompanyCode").build()}).build();
    private static final SdkField<String> FLEET_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeFleetMetadataResponse.getter(DescribeFleetMetadataResponse::fleetStatusAsString)).setter(DescribeFleetMetadataResponse.setter(Builder::fleetStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, FLEET_NAME_FIELD, DISPLAY_NAME_FIELD, OPTIMIZE_FOR_END_USER_LOCATION_FIELD, COMPANY_CODE_FIELD, FLEET_STATUS_FIELD));
    private final Instant createdTime;
    private final Instant lastUpdatedTime;
    private final String fleetName;
    private final String displayName;
    private final Boolean optimizeForEndUserLocation;
    private final String companyCode;
    private final String fleetStatus;

    private DescribeFleetMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.fleetName = builder.fleetName;
        this.displayName = builder.displayName;
        this.optimizeForEndUserLocation = builder.optimizeForEndUserLocation;
        this.companyCode = builder.companyCode;
        this.fleetStatus = builder.fleetStatus;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String fleetName() {
        return this.fleetName;
    }

    public String displayName() {
        return this.displayName;
    }

    public Boolean optimizeForEndUserLocation() {
        return this.optimizeForEndUserLocation;
    }

    public String companyCode() {
        return this.companyCode;
    }

    public FleetStatus fleetStatus() {
        return FleetStatus.fromValue(this.fleetStatus);
    }

    public String fleetStatusAsString() {
        return this.fleetStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizeForEndUserLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.companyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFleetMetadataResponse)) {
            return false;
        }
        DescribeFleetMetadataResponse other = (DescribeFleetMetadataResponse)((Object)obj);
        return Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.fleetName(), other.fleetName()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.optimizeForEndUserLocation(), other.optimizeForEndUserLocation()) && Objects.equals(this.companyCode(), other.companyCode()) && Objects.equals(this.fleetStatusAsString(), other.fleetStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"DescribeFleetMetadataResponse").add("CreatedTime", (Object)this.createdTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("FleetName", (Object)this.fleetName()).add("DisplayName", (Object)this.displayName()).add("OptimizeForEndUserLocation", (Object)this.optimizeForEndUserLocation()).add("CompanyCode", (Object)this.companyCode()).add("FleetStatus", (Object)this.fleetStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "FleetName": {
                return Optional.ofNullable(clazz.cast(this.fleetName()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "OptimizeForEndUserLocation": {
                return Optional.ofNullable(clazz.cast(this.optimizeForEndUserLocation()));
            }
            case "CompanyCode": {
                return Optional.ofNullable(clazz.cast(this.companyCode()));
            }
            case "FleetStatus": {
                return Optional.ofNullable(clazz.cast(this.fleetStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeFleetMetadataResponse, T> g) {
        return obj -> g.apply((DescribeFleetMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkLinkResponse.BuilderImpl
    implements Builder {
        private Instant createdTime;
        private Instant lastUpdatedTime;
        private String fleetName;
        private String displayName;
        private Boolean optimizeForEndUserLocation;
        private String companyCode;
        private String fleetStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFleetMetadataResponse model) {
            super(model);
            this.createdTime(model.createdTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.fleetName(model.fleetName);
            this.displayName(model.displayName);
            this.optimizeForEndUserLocation(model.optimizeForEndUserLocation);
            this.companyCode(model.companyCode);
            this.fleetStatus(model.fleetStatus);
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final String getFleetName() {
            return this.fleetName;
        }

        @Override
        public final Builder fleetName(String fleetName) {
            this.fleetName = fleetName;
            return this;
        }

        public final void setFleetName(String fleetName) {
            this.fleetName = fleetName;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final Boolean getOptimizeForEndUserLocation() {
            return this.optimizeForEndUserLocation;
        }

        @Override
        public final Builder optimizeForEndUserLocation(Boolean optimizeForEndUserLocation) {
            this.optimizeForEndUserLocation = optimizeForEndUserLocation;
            return this;
        }

        public final void setOptimizeForEndUserLocation(Boolean optimizeForEndUserLocation) {
            this.optimizeForEndUserLocation = optimizeForEndUserLocation;
        }

        public final String getCompanyCode() {
            return this.companyCode;
        }

        @Override
        public final Builder companyCode(String companyCode) {
            this.companyCode = companyCode;
            return this;
        }

        public final void setCompanyCode(String companyCode) {
            this.companyCode = companyCode;
        }

        public final String getFleetStatusAsString() {
            return this.fleetStatus;
        }

        @Override
        public final Builder fleetStatus(String fleetStatus) {
            this.fleetStatus = fleetStatus;
            return this;
        }

        @Override
        public final Builder fleetStatus(FleetStatus fleetStatus) {
            this.fleetStatus(fleetStatus == null ? null : fleetStatus.toString());
            return this;
        }

        public final void setFleetStatus(String fleetStatus) {
            this.fleetStatus = fleetStatus;
        }

        @Override
        public DescribeFleetMetadataResponse build() {
            return new DescribeFleetMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkLinkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeFleetMetadataResponse> {
        public Builder createdTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder fleetName(String var1);

        public Builder displayName(String var1);

        public Builder optimizeForEndUserLocation(Boolean var1);

        public Builder companyCode(String var1);

        public Builder fleetStatus(String var1);

        public Builder fleetStatus(FleetStatus var1);
    }
}

