/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.worklink.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.worklink.model.FleetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FleetSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FleetSummary> {
    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FleetSummary.getter(FleetSummary::fleetArn)).setter(FleetSummary.setter(Builder::fleetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(FleetSummary.getter(FleetSummary::createdTime)).setter(FleetSummary.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(FleetSummary.getter(FleetSummary::lastUpdatedTime)).setter(FleetSummary.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<String> FLEET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FleetSummary.getter(FleetSummary::fleetName)).setter(FleetSummary.setter(Builder::fleetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetName").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FleetSummary.getter(FleetSummary::displayName)).setter(FleetSummary.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> COMPANY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FleetSummary.getter(FleetSummary::companyCode)).setter(FleetSummary.setter(Builder::companyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompanyCode").build()}).build();
    private static final SdkField<String> FLEET_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FleetSummary.getter(FleetSummary::fleetStatusAsString)).setter(FleetSummary.setter(Builder::fleetStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ARN_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, FLEET_NAME_FIELD, DISPLAY_NAME_FIELD, COMPANY_CODE_FIELD, FLEET_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fleetArn;
    private final Instant createdTime;
    private final Instant lastUpdatedTime;
    private final String fleetName;
    private final String displayName;
    private final String companyCode;
    private final String fleetStatus;

    private FleetSummary(BuilderImpl builder) {
        this.fleetArn = builder.fleetArn;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.fleetName = builder.fleetName;
        this.displayName = builder.displayName;
        this.companyCode = builder.companyCode;
        this.fleetStatus = builder.fleetStatus;
    }

    public String fleetArn() {
        return this.fleetArn;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String fleetName() {
        return this.fleetName;
    }

    public String displayName() {
        return this.displayName;
    }

    public String companyCode() {
        return this.companyCode;
    }

    public FleetStatus fleetStatus() {
        return FleetStatus.fromValue(this.fleetStatus);
    }

    public String fleetStatusAsString() {
        return this.fleetStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.companyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetSummary)) {
            return false;
        }
        FleetSummary other = (FleetSummary)obj;
        return Objects.equals(this.fleetArn(), other.fleetArn()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.fleetName(), other.fleetName()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.companyCode(), other.companyCode()) && Objects.equals(this.fleetStatusAsString(), other.fleetStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"FleetSummary").add("FleetArn", (Object)this.fleetArn()).add("CreatedTime", (Object)this.createdTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("FleetName", (Object)this.fleetName()).add("DisplayName", (Object)this.displayName()).add("CompanyCode", (Object)this.companyCode()).add("FleetStatus", (Object)this.fleetStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetArn": {
                return Optional.ofNullable(clazz.cast(this.fleetArn()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "FleetName": {
                return Optional.ofNullable(clazz.cast(this.fleetName()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "CompanyCode": {
                return Optional.ofNullable(clazz.cast(this.companyCode()));
            }
            case "FleetStatus": {
                return Optional.ofNullable(clazz.cast(this.fleetStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FleetSummary, T> g) {
        return obj -> g.apply((FleetSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fleetArn;
        private Instant createdTime;
        private Instant lastUpdatedTime;
        private String fleetName;
        private String displayName;
        private String companyCode;
        private String fleetStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetSummary model) {
            this.fleetArn(model.fleetArn);
            this.createdTime(model.createdTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.fleetName(model.fleetName);
            this.displayName(model.displayName);
            this.companyCode(model.companyCode);
            this.fleetStatus(model.fleetStatus);
        }

        public final String getFleetArn() {
            return this.fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        public final String getFleetName() {
            return this.fleetName;
        }

        @Override
        public final Builder fleetName(String fleetName) {
            this.fleetName = fleetName;
            return this;
        }

        public final void setFleetName(String fleetName) {
            this.fleetName = fleetName;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getCompanyCode() {
            return this.companyCode;
        }

        @Override
        public final Builder companyCode(String companyCode) {
            this.companyCode = companyCode;
            return this;
        }

        public final void setCompanyCode(String companyCode) {
            this.companyCode = companyCode;
        }

        public final String getFleetStatusAsString() {
            return this.fleetStatus;
        }

        @Override
        public final Builder fleetStatus(String fleetStatus) {
            this.fleetStatus = fleetStatus;
            return this;
        }

        @Override
        public final Builder fleetStatus(FleetStatus fleetStatus) {
            this.fleetStatus(fleetStatus == null ? null : fleetStatus.toString());
            return this;
        }

        public final void setFleetStatus(String fleetStatus) {
            this.fleetStatus = fleetStatus;
        }

        public FleetSummary build() {
            return new FleetSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FleetSummary> {
        public Builder fleetArn(String var1);

        public Builder createdTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder fleetName(String var1);

        public Builder displayName(String var1);

        public Builder companyCode(String var1);

        public Builder fleetStatus(String var1);

        public Builder fleetStatus(FleetStatus var1);
    }
}

