/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.worklink.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.worklink.model.FleetSummary;
import software.amazon.awssdk.services.worklink.model.FleetSummaryListCopier;
import software.amazon.awssdk.services.worklink.model.WorkLinkResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFleetsResponse
extends WorkLinkResponse
implements ToCopyableBuilder<Builder, ListFleetsResponse> {
    private static final SdkField<List<FleetSummary>> FLEET_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListFleetsResponse.getter(ListFleetsResponse::fleetSummaryList)).setter(ListFleetsResponse.setter(Builder::fleetSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FleetSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListFleetsResponse.getter(ListFleetsResponse::nextToken)).setter(ListFleetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<FleetSummary> fleetSummaryList;
    private final String nextToken;

    private ListFleetsResponse(BuilderImpl builder) {
        super(builder);
        this.fleetSummaryList = builder.fleetSummaryList;
        this.nextToken = builder.nextToken;
    }

    public List<FleetSummary> fleetSummaryList() {
        return this.fleetSummaryList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetSummaryList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFleetsResponse)) {
            return false;
        }
        ListFleetsResponse other = (ListFleetsResponse)((Object)obj);
        return Objects.equals(this.fleetSummaryList(), other.fleetSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListFleetsResponse").add("FleetSummaryList", this.fleetSummaryList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetSummaryList": {
                return Optional.ofNullable(clazz.cast(this.fleetSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFleetsResponse, T> g) {
        return obj -> g.apply((ListFleetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkLinkResponse.BuilderImpl
    implements Builder {
        private List<FleetSummary> fleetSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFleetsResponse model) {
            super(model);
            this.fleetSummaryList(model.fleetSummaryList);
            this.nextToken(model.nextToken);
        }

        public final Collection<FleetSummary.Builder> getFleetSummaryList() {
            return this.fleetSummaryList != null ? (Collection)this.fleetSummaryList.stream().map(FleetSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fleetSummaryList(Collection<FleetSummary> fleetSummaryList) {
            this.fleetSummaryList = FleetSummaryListCopier.copy(fleetSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetSummaryList(FleetSummary ... fleetSummaryList) {
            this.fleetSummaryList(Arrays.asList(fleetSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetSummaryList(Consumer<FleetSummary.Builder> ... fleetSummaryList) {
            this.fleetSummaryList(Stream.of(fleetSummaryList).map(c -> (FleetSummary)((FleetSummary.Builder)FleetSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFleetSummaryList(Collection<FleetSummary.BuilderImpl> fleetSummaryList) {
            this.fleetSummaryList = FleetSummaryListCopier.copyFromBuilder(fleetSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListFleetsResponse build() {
            return new ListFleetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkLinkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFleetsResponse> {
        public Builder fleetSummaryList(Collection<FleetSummary> var1);

        public Builder fleetSummaryList(FleetSummary ... var1);

        public Builder fleetSummaryList(Consumer<FleetSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

