/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.worklink;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.worklink.WorkLinkClient;
import software.amazon.awssdk.services.worklink.model.AssociateDomainRequest;
import software.amazon.awssdk.services.worklink.model.AssociateDomainResponse;
import software.amazon.awssdk.services.worklink.model.AssociateWebsiteAuthorizationProviderRequest;
import software.amazon.awssdk.services.worklink.model.AssociateWebsiteAuthorizationProviderResponse;
import software.amazon.awssdk.services.worklink.model.AssociateWebsiteCertificateAuthorityRequest;
import software.amazon.awssdk.services.worklink.model.AssociateWebsiteCertificateAuthorityResponse;
import software.amazon.awssdk.services.worklink.model.CreateFleetRequest;
import software.amazon.awssdk.services.worklink.model.CreateFleetResponse;
import software.amazon.awssdk.services.worklink.model.DeleteFleetRequest;
import software.amazon.awssdk.services.worklink.model.DeleteFleetResponse;
import software.amazon.awssdk.services.worklink.model.DescribeAuditStreamConfigurationRequest;
import software.amazon.awssdk.services.worklink.model.DescribeAuditStreamConfigurationResponse;
import software.amazon.awssdk.services.worklink.model.DescribeCompanyNetworkConfigurationRequest;
import software.amazon.awssdk.services.worklink.model.DescribeCompanyNetworkConfigurationResponse;
import software.amazon.awssdk.services.worklink.model.DescribeDevicePolicyConfigurationRequest;
import software.amazon.awssdk.services.worklink.model.DescribeDevicePolicyConfigurationResponse;
import software.amazon.awssdk.services.worklink.model.DescribeDeviceRequest;
import software.amazon.awssdk.services.worklink.model.DescribeDeviceResponse;
import software.amazon.awssdk.services.worklink.model.DescribeDomainRequest;
import software.amazon.awssdk.services.worklink.model.DescribeDomainResponse;
import software.amazon.awssdk.services.worklink.model.DescribeFleetMetadataRequest;
import software.amazon.awssdk.services.worklink.model.DescribeFleetMetadataResponse;
import software.amazon.awssdk.services.worklink.model.DescribeIdentityProviderConfigurationRequest;
import software.amazon.awssdk.services.worklink.model.DescribeIdentityProviderConfigurationResponse;
import software.amazon.awssdk.services.worklink.model.DescribeWebsiteCertificateAuthorityRequest;
import software.amazon.awssdk.services.worklink.model.DescribeWebsiteCertificateAuthorityResponse;
import software.amazon.awssdk.services.worklink.model.DisassociateDomainRequest;
import software.amazon.awssdk.services.worklink.model.DisassociateDomainResponse;
import software.amazon.awssdk.services.worklink.model.DisassociateWebsiteAuthorizationProviderRequest;
import software.amazon.awssdk.services.worklink.model.DisassociateWebsiteAuthorizationProviderResponse;
import software.amazon.awssdk.services.worklink.model.DisassociateWebsiteCertificateAuthorityRequest;
import software.amazon.awssdk.services.worklink.model.DisassociateWebsiteCertificateAuthorityResponse;
import software.amazon.awssdk.services.worklink.model.InternalServerErrorException;
import software.amazon.awssdk.services.worklink.model.InvalidRequestException;
import software.amazon.awssdk.services.worklink.model.ListDevicesRequest;
import software.amazon.awssdk.services.worklink.model.ListDevicesResponse;
import software.amazon.awssdk.services.worklink.model.ListDomainsRequest;
import software.amazon.awssdk.services.worklink.model.ListDomainsResponse;
import software.amazon.awssdk.services.worklink.model.ListFleetsRequest;
import software.amazon.awssdk.services.worklink.model.ListFleetsResponse;
import software.amazon.awssdk.services.worklink.model.ListWebsiteAuthorizationProvidersRequest;
import software.amazon.awssdk.services.worklink.model.ListWebsiteAuthorizationProvidersResponse;
import software.amazon.awssdk.services.worklink.model.ListWebsiteCertificateAuthoritiesRequest;
import software.amazon.awssdk.services.worklink.model.ListWebsiteCertificateAuthoritiesResponse;
import software.amazon.awssdk.services.worklink.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.worklink.model.ResourceNotFoundException;
import software.amazon.awssdk.services.worklink.model.RestoreDomainAccessRequest;
import software.amazon.awssdk.services.worklink.model.RestoreDomainAccessResponse;
import software.amazon.awssdk.services.worklink.model.RevokeDomainAccessRequest;
import software.amazon.awssdk.services.worklink.model.RevokeDomainAccessResponse;
import software.amazon.awssdk.services.worklink.model.SignOutUserRequest;
import software.amazon.awssdk.services.worklink.model.SignOutUserResponse;
import software.amazon.awssdk.services.worklink.model.TooManyRequestsException;
import software.amazon.awssdk.services.worklink.model.UnauthorizedException;
import software.amazon.awssdk.services.worklink.model.UpdateAuditStreamConfigurationRequest;
import software.amazon.awssdk.services.worklink.model.UpdateAuditStreamConfigurationResponse;
import software.amazon.awssdk.services.worklink.model.UpdateCompanyNetworkConfigurationRequest;
import software.amazon.awssdk.services.worklink.model.UpdateCompanyNetworkConfigurationResponse;
import software.amazon.awssdk.services.worklink.model.UpdateDevicePolicyConfigurationRequest;
import software.amazon.awssdk.services.worklink.model.UpdateDevicePolicyConfigurationResponse;
import software.amazon.awssdk.services.worklink.model.UpdateDomainMetadataRequest;
import software.amazon.awssdk.services.worklink.model.UpdateDomainMetadataResponse;
import software.amazon.awssdk.services.worklink.model.UpdateFleetMetadataRequest;
import software.amazon.awssdk.services.worklink.model.UpdateFleetMetadataResponse;
import software.amazon.awssdk.services.worklink.model.UpdateIdentityProviderConfigurationRequest;
import software.amazon.awssdk.services.worklink.model.UpdateIdentityProviderConfigurationResponse;
import software.amazon.awssdk.services.worklink.model.WorkLinkException;
import software.amazon.awssdk.services.worklink.model.WorkLinkRequest;
import software.amazon.awssdk.services.worklink.paginators.ListDevicesIterable;
import software.amazon.awssdk.services.worklink.paginators.ListDomainsIterable;
import software.amazon.awssdk.services.worklink.paginators.ListFleetsIterable;
import software.amazon.awssdk.services.worklink.paginators.ListWebsiteAuthorizationProvidersIterable;
import software.amazon.awssdk.services.worklink.paginators.ListWebsiteCertificateAuthoritiesIterable;
import software.amazon.awssdk.services.worklink.transform.AssociateDomainRequestMarshaller;
import software.amazon.awssdk.services.worklink.transform.AssociateWebsiteAuthorizationProviderRequestMarshaller;
import software.amazon.awssdk.services.worklink.transform.AssociateWebsiteCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.worklink.transform.CreateFleetRequestMarshaller;
import software.amazon.awssdk.services.worklink.transform.DeleteFleetRequestMarshaller;
import software.amazon.awssdk.services.worklink.transform.DescribeAuditStreamConfigurationRequestMarshaller;
import software.amazon.awssdk.services.worklink.transform.DescribeCompanyNetworkConfigurationRequestMarshaller;
import software.amazon.awssdk.services.worklink.transform.DescribeDevicePolicyConfigurationRequestMarshaller;
import software.amazon.awssdk.services.worklink.transform.DescribeDeviceRequestMarshaller;
import software.amazon.awssdk.services.worklink.transform.DescribeDomainRequestMarshaller;
import software.amazon.awssdk.services.worklink.transform.DescribeFleetMetadataRequestMarshaller;
import software.amazon.awssdk.services.worklink.transform.DescribeIdentityProviderConfigurationRequestMarshaller;
import software.amazon.awssdk.services.worklink.transform.DescribeWebsiteCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.worklink.transform.DisassociateDomainRequestMarshaller;
import software.amazon.awssdk.services.worklink.transform.DisassociateWebsiteAuthorizationProviderRequestMarshaller;
import software.amazon.awssdk.services.worklink.transform.DisassociateWebsiteCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.worklink.transform.ListDevicesRequestMarshaller;
import software.amazon.awssdk.services.worklink.transform.ListDomainsRequestMarshaller;
import software.amazon.awssdk.services.worklink.transform.ListFleetsRequestMarshaller;
import software.amazon.awssdk.services.worklink.transform.ListWebsiteAuthorizationProvidersRequestMarshaller;
import software.amazon.awssdk.services.worklink.transform.ListWebsiteCertificateAuthoritiesRequestMarshaller;
import software.amazon.awssdk.services.worklink.transform.RestoreDomainAccessRequestMarshaller;
import software.amazon.awssdk.services.worklink.transform.RevokeDomainAccessRequestMarshaller;
import software.amazon.awssdk.services.worklink.transform.SignOutUserRequestMarshaller;
import software.amazon.awssdk.services.worklink.transform.UpdateAuditStreamConfigurationRequestMarshaller;
import software.amazon.awssdk.services.worklink.transform.UpdateCompanyNetworkConfigurationRequestMarshaller;
import software.amazon.awssdk.services.worklink.transform.UpdateDevicePolicyConfigurationRequestMarshaller;
import software.amazon.awssdk.services.worklink.transform.UpdateDomainMetadataRequestMarshaller;
import software.amazon.awssdk.services.worklink.transform.UpdateFleetMetadataRequestMarshaller;
import software.amazon.awssdk.services.worklink.transform.UpdateIdentityProviderConfigurationRequestMarshaller;

@SdkInternalApi
final class DefaultWorkLinkClient
implements WorkLinkClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultWorkLinkClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "worklink";
    }

    @Override
    public AssociateDomainResponse associateDomain(AssociateDomainRequest associateDomainRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, ResourceAlreadyExistsException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AssociateDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateDomainRequest).withMarshaller((Marshaller)new AssociateDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public AssociateWebsiteAuthorizationProviderResponse associateWebsiteAuthorizationProvider(AssociateWebsiteAuthorizationProviderRequest associateWebsiteAuthorizationProviderRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, ResourceAlreadyExistsException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateWebsiteAuthorizationProviderResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AssociateWebsiteAuthorizationProviderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateWebsiteAuthorizationProvider").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateWebsiteAuthorizationProviderRequest).withMarshaller((Marshaller)new AssociateWebsiteAuthorizationProviderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public AssociateWebsiteCertificateAuthorityResponse associateWebsiteCertificateAuthority(AssociateWebsiteCertificateAuthorityRequest associateWebsiteCertificateAuthorityRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, ResourceAlreadyExistsException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateWebsiteCertificateAuthorityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (AssociateWebsiteCertificateAuthorityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateWebsiteCertificateAuthority").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateWebsiteCertificateAuthorityRequest).withMarshaller((Marshaller)new AssociateWebsiteCertificateAuthorityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CreateFleetResponse createFleet(CreateFleetRequest createFleetRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, ResourceAlreadyExistsException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFleetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CreateFleetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFleet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createFleetRequest).withMarshaller((Marshaller)new CreateFleetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteFleetResponse deleteFleet(DeleteFleetRequest deleteFleetRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFleetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteFleetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFleet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteFleetRequest).withMarshaller((Marshaller)new DeleteFleetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeAuditStreamConfigurationResponse describeAuditStreamConfiguration(DescribeAuditStreamConfigurationRequest describeAuditStreamConfigurationRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAuditStreamConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeAuditStreamConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAuditStreamConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAuditStreamConfigurationRequest).withMarshaller((Marshaller)new DescribeAuditStreamConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeCompanyNetworkConfigurationResponse describeCompanyNetworkConfiguration(DescribeCompanyNetworkConfigurationRequest describeCompanyNetworkConfigurationRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCompanyNetworkConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeCompanyNetworkConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCompanyNetworkConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCompanyNetworkConfigurationRequest).withMarshaller((Marshaller)new DescribeCompanyNetworkConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeDeviceResponse describeDevice(DescribeDeviceRequest describeDeviceRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDeviceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeDeviceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDevice").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDeviceRequest).withMarshaller((Marshaller)new DescribeDeviceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeDevicePolicyConfigurationResponse describeDevicePolicyConfiguration(DescribeDevicePolicyConfigurationRequest describeDevicePolicyConfigurationRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDevicePolicyConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeDevicePolicyConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDevicePolicyConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDevicePolicyConfigurationRequest).withMarshaller((Marshaller)new DescribeDevicePolicyConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeDomainResponse describeDomain(DescribeDomainRequest describeDomainRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDomainRequest).withMarshaller((Marshaller)new DescribeDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeFleetMetadataResponse describeFleetMetadata(DescribeFleetMetadataRequest describeFleetMetadataRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFleetMetadataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeFleetMetadataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFleetMetadata").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeFleetMetadataRequest).withMarshaller((Marshaller)new DescribeFleetMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeIdentityProviderConfigurationResponse describeIdentityProviderConfiguration(DescribeIdentityProviderConfigurationRequest describeIdentityProviderConfigurationRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeIdentityProviderConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeIdentityProviderConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeIdentityProviderConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeIdentityProviderConfigurationRequest).withMarshaller((Marshaller)new DescribeIdentityProviderConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DescribeWebsiteCertificateAuthorityResponse describeWebsiteCertificateAuthority(DescribeWebsiteCertificateAuthorityRequest describeWebsiteCertificateAuthorityRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeWebsiteCertificateAuthorityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeWebsiteCertificateAuthorityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeWebsiteCertificateAuthority").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeWebsiteCertificateAuthorityRequest).withMarshaller((Marshaller)new DescribeWebsiteCertificateAuthorityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DisassociateDomainResponse disassociateDomain(DisassociateDomainRequest disassociateDomainRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DisassociateDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateDomainRequest).withMarshaller((Marshaller)new DisassociateDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DisassociateWebsiteAuthorizationProviderResponse disassociateWebsiteAuthorizationProvider(DisassociateWebsiteAuthorizationProviderRequest disassociateWebsiteAuthorizationProviderRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, ResourceAlreadyExistsException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateWebsiteAuthorizationProviderResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DisassociateWebsiteAuthorizationProviderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateWebsiteAuthorizationProvider").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateWebsiteAuthorizationProviderRequest).withMarshaller((Marshaller)new DisassociateWebsiteAuthorizationProviderRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DisassociateWebsiteCertificateAuthorityResponse disassociateWebsiteCertificateAuthority(DisassociateWebsiteCertificateAuthorityRequest disassociateWebsiteCertificateAuthorityRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateWebsiteCertificateAuthorityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DisassociateWebsiteCertificateAuthorityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateWebsiteCertificateAuthority").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateWebsiteCertificateAuthorityRequest).withMarshaller((Marshaller)new DisassociateWebsiteCertificateAuthorityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDevicesResponse listDevices(ListDevicesRequest listDevicesRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDevicesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListDevicesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDevices").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDevicesRequest).withMarshaller((Marshaller)new ListDevicesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDevicesIterable listDevicesPaginator(ListDevicesRequest listDevicesRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return new ListDevicesIterable(this, this.applyPaginatorUserAgent(listDevicesRequest));
    }

    @Override
    public ListDomainsResponse listDomains(ListDomainsRequest listDomainsRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDomainsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListDomainsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDomains").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDomainsRequest).withMarshaller((Marshaller)new ListDomainsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDomainsIterable listDomainsPaginator(ListDomainsRequest listDomainsRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return new ListDomainsIterable(this, this.applyPaginatorUserAgent(listDomainsRequest));
    }

    @Override
    public ListFleetsResponse listFleets(ListFleetsRequest listFleetsRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFleetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListFleetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFleets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFleetsRequest).withMarshaller((Marshaller)new ListFleetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListFleetsIterable listFleetsPaginator(ListFleetsRequest listFleetsRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return new ListFleetsIterable(this, this.applyPaginatorUserAgent(listFleetsRequest));
    }

    @Override
    public ListWebsiteAuthorizationProvidersResponse listWebsiteAuthorizationProviders(ListWebsiteAuthorizationProvidersRequest listWebsiteAuthorizationProvidersRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWebsiteAuthorizationProvidersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListWebsiteAuthorizationProvidersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWebsiteAuthorizationProviders").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listWebsiteAuthorizationProvidersRequest).withMarshaller((Marshaller)new ListWebsiteAuthorizationProvidersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListWebsiteAuthorizationProvidersIterable listWebsiteAuthorizationProvidersPaginator(ListWebsiteAuthorizationProvidersRequest listWebsiteAuthorizationProvidersRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return new ListWebsiteAuthorizationProvidersIterable(this, this.applyPaginatorUserAgent(listWebsiteAuthorizationProvidersRequest));
    }

    @Override
    public ListWebsiteCertificateAuthoritiesResponse listWebsiteCertificateAuthorities(ListWebsiteCertificateAuthoritiesRequest listWebsiteCertificateAuthoritiesRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWebsiteCertificateAuthoritiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListWebsiteCertificateAuthoritiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWebsiteCertificateAuthorities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listWebsiteCertificateAuthoritiesRequest).withMarshaller((Marshaller)new ListWebsiteCertificateAuthoritiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListWebsiteCertificateAuthoritiesIterable listWebsiteCertificateAuthoritiesPaginator(ListWebsiteCertificateAuthoritiesRequest listWebsiteCertificateAuthoritiesRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        return new ListWebsiteCertificateAuthoritiesIterable(this, this.applyPaginatorUserAgent(listWebsiteCertificateAuthoritiesRequest));
    }

    @Override
    public RestoreDomainAccessResponse restoreDomainAccess(RestoreDomainAccessRequest restoreDomainAccessRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreDomainAccessResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RestoreDomainAccessResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreDomainAccess").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)restoreDomainAccessRequest).withMarshaller((Marshaller)new RestoreDomainAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RevokeDomainAccessResponse revokeDomainAccess(RevokeDomainAccessRequest revokeDomainAccessRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RevokeDomainAccessResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RevokeDomainAccessResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RevokeDomainAccess").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)revokeDomainAccessRequest).withMarshaller((Marshaller)new RevokeDomainAccessRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public SignOutUserResponse signOutUser(SignOutUserRequest signOutUserRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SignOutUserResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (SignOutUserResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SignOutUser").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)signOutUserRequest).withMarshaller((Marshaller)new SignOutUserRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateAuditStreamConfigurationResponse updateAuditStreamConfiguration(UpdateAuditStreamConfigurationRequest updateAuditStreamConfigurationRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAuditStreamConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateAuditStreamConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAuditStreamConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAuditStreamConfigurationRequest).withMarshaller((Marshaller)new UpdateAuditStreamConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateCompanyNetworkConfigurationResponse updateCompanyNetworkConfiguration(UpdateCompanyNetworkConfigurationRequest updateCompanyNetworkConfigurationRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCompanyNetworkConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateCompanyNetworkConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCompanyNetworkConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateCompanyNetworkConfigurationRequest).withMarshaller((Marshaller)new UpdateCompanyNetworkConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateDevicePolicyConfigurationResponse updateDevicePolicyConfiguration(UpdateDevicePolicyConfigurationRequest updateDevicePolicyConfigurationRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDevicePolicyConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateDevicePolicyConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDevicePolicyConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDevicePolicyConfigurationRequest).withMarshaller((Marshaller)new UpdateDevicePolicyConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateDomainMetadataResponse updateDomainMetadata(UpdateDomainMetadataRequest updateDomainMetadataRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDomainMetadataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateDomainMetadataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDomainMetadata").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDomainMetadataRequest).withMarshaller((Marshaller)new UpdateDomainMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateFleetMetadataResponse updateFleetMetadata(UpdateFleetMetadataRequest updateFleetMetadataRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFleetMetadataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateFleetMetadataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFleetMetadata").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFleetMetadataRequest).withMarshaller((Marshaller)new UpdateFleetMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateIdentityProviderConfigurationResponse updateIdentityProviderConfiguration(UpdateIdentityProviderConfigurationRequest updateIdentityProviderConfigurationRequest) throws UnauthorizedException, InternalServerErrorException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException, SdkClientException, WorkLinkException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateIdentityProviderConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateIdentityProviderConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateIdentityProviderConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateIdentityProviderConfigurationRequest).withMarshaller((Marshaller)new UpdateIdentityProviderConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(WorkLinkException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnauthorizedException").exceptionBuilderSupplier(UnauthorizedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRequestsException").exceptionBuilderSupplier(TooManyRequestsException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerErrorException").exceptionBuilderSupplier(InternalServerErrorException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends WorkLinkRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.12.0").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((WorkLinkRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

