/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.worklink.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.worklink.model.DeviceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeviceSummary> {
    private static final SdkField<String> DEVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeviceSummary.getter(DeviceSummary::deviceId)).setter(DeviceSummary.setter(Builder::deviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceId").build()}).build();
    private static final SdkField<String> DEVICE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeviceSummary.getter(DeviceSummary::deviceStatusAsString)).setter(DeviceSummary.setter(Builder::deviceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_ID_FIELD, DEVICE_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deviceId;
    private final String deviceStatus;

    private DeviceSummary(BuilderImpl builder) {
        this.deviceId = builder.deviceId;
        this.deviceStatus = builder.deviceStatus;
    }

    public String deviceId() {
        return this.deviceId;
    }

    public DeviceStatus deviceStatus() {
        return DeviceStatus.fromValue(this.deviceStatus);
    }

    public String deviceStatusAsString() {
        return this.deviceStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceSummary)) {
            return false;
        }
        DeviceSummary other = (DeviceSummary)obj;
        return Objects.equals(this.deviceId(), other.deviceId()) && Objects.equals(this.deviceStatusAsString(), other.deviceStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"DeviceSummary").add("DeviceId", (Object)this.deviceId()).add("DeviceStatus", (Object)this.deviceStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceId": {
                return Optional.ofNullable(clazz.cast(this.deviceId()));
            }
            case "DeviceStatus": {
                return Optional.ofNullable(clazz.cast(this.deviceStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeviceSummary, T> g) {
        return obj -> g.apply((DeviceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceId;
        private String deviceStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceSummary model) {
            this.deviceId(model.deviceId);
            this.deviceStatus(model.deviceStatus);
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        @Override
        public final Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = deviceId;
        }

        public final String getDeviceStatus() {
            return this.deviceStatus;
        }

        @Override
        public final Builder deviceStatus(String deviceStatus) {
            this.deviceStatus = deviceStatus;
            return this;
        }

        @Override
        public final Builder deviceStatus(DeviceStatus deviceStatus) {
            this.deviceStatus(deviceStatus == null ? null : deviceStatus.toString());
            return this;
        }

        public final void setDeviceStatus(String deviceStatus) {
            this.deviceStatus = deviceStatus;
        }

        public DeviceSummary build() {
            return new DeviceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeviceSummary> {
        public Builder deviceId(String var1);

        public Builder deviceStatus(String var1);

        public Builder deviceStatus(DeviceStatus var1);
    }
}

