/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.worklink.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.worklink.model.AuthorizationProviderType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WebsiteAuthorizationProviderSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WebsiteAuthorizationProviderSummary> {
    private static final SdkField<String> AUTHORIZATION_PROVIDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WebsiteAuthorizationProviderSummary.getter(WebsiteAuthorizationProviderSummary::authorizationProviderId)).setter(WebsiteAuthorizationProviderSummary.setter(Builder::authorizationProviderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationProviderId").build()}).build();
    private static final SdkField<String> AUTHORIZATION_PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WebsiteAuthorizationProviderSummary.getter(WebsiteAuthorizationProviderSummary::authorizationProviderTypeAsString)).setter(WebsiteAuthorizationProviderSummary.setter(Builder::authorizationProviderType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationProviderType").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WebsiteAuthorizationProviderSummary.getter(WebsiteAuthorizationProviderSummary::domainName)).setter(WebsiteAuthorizationProviderSummary.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(WebsiteAuthorizationProviderSummary.getter(WebsiteAuthorizationProviderSummary::createdTime)).setter(WebsiteAuthorizationProviderSummary.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_PROVIDER_ID_FIELD, AUTHORIZATION_PROVIDER_TYPE_FIELD, DOMAIN_NAME_FIELD, CREATED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String authorizationProviderId;
    private final String authorizationProviderType;
    private final String domainName;
    private final Instant createdTime;

    private WebsiteAuthorizationProviderSummary(BuilderImpl builder) {
        this.authorizationProviderId = builder.authorizationProviderId;
        this.authorizationProviderType = builder.authorizationProviderType;
        this.domainName = builder.domainName;
        this.createdTime = builder.createdTime;
    }

    public String authorizationProviderId() {
        return this.authorizationProviderId;
    }

    public AuthorizationProviderType authorizationProviderType() {
        return AuthorizationProviderType.fromValue(this.authorizationProviderType);
    }

    public String authorizationProviderTypeAsString() {
        return this.authorizationProviderType;
    }

    public String domainName() {
        return this.domainName;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationProviderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebsiteAuthorizationProviderSummary)) {
            return false;
        }
        WebsiteAuthorizationProviderSummary other = (WebsiteAuthorizationProviderSummary)obj;
        return Objects.equals(this.authorizationProviderId(), other.authorizationProviderId()) && Objects.equals(this.authorizationProviderTypeAsString(), other.authorizationProviderTypeAsString()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.createdTime(), other.createdTime());
    }

    public String toString() {
        return ToString.builder((String)"WebsiteAuthorizationProviderSummary").add("AuthorizationProviderId", (Object)this.authorizationProviderId()).add("AuthorizationProviderType", (Object)this.authorizationProviderTypeAsString()).add("DomainName", (Object)this.domainName()).add("CreatedTime", (Object)this.createdTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthorizationProviderId": {
                return Optional.ofNullable(clazz.cast(this.authorizationProviderId()));
            }
            case "AuthorizationProviderType": {
                return Optional.ofNullable(clazz.cast(this.authorizationProviderTypeAsString()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WebsiteAuthorizationProviderSummary, T> g) {
        return obj -> g.apply((WebsiteAuthorizationProviderSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String authorizationProviderId;
        private String authorizationProviderType;
        private String domainName;
        private Instant createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(WebsiteAuthorizationProviderSummary model) {
            this.authorizationProviderId(model.authorizationProviderId);
            this.authorizationProviderType(model.authorizationProviderType);
            this.domainName(model.domainName);
            this.createdTime(model.createdTime);
        }

        public final String getAuthorizationProviderId() {
            return this.authorizationProviderId;
        }

        @Override
        public final Builder authorizationProviderId(String authorizationProviderId) {
            this.authorizationProviderId = authorizationProviderId;
            return this;
        }

        public final void setAuthorizationProviderId(String authorizationProviderId) {
            this.authorizationProviderId = authorizationProviderId;
        }

        public final String getAuthorizationProviderType() {
            return this.authorizationProviderType;
        }

        @Override
        public final Builder authorizationProviderType(String authorizationProviderType) {
            this.authorizationProviderType = authorizationProviderType;
            return this;
        }

        @Override
        public final Builder authorizationProviderType(AuthorizationProviderType authorizationProviderType) {
            this.authorizationProviderType(authorizationProviderType == null ? null : authorizationProviderType.toString());
            return this;
        }

        public final void setAuthorizationProviderType(String authorizationProviderType) {
            this.authorizationProviderType = authorizationProviderType;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public WebsiteAuthorizationProviderSummary build() {
            return new WebsiteAuthorizationProviderSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WebsiteAuthorizationProviderSummary> {
        public Builder authorizationProviderId(String var1);

        public Builder authorizationProviderType(String var1);

        public Builder authorizationProviderType(AuthorizationProviderType var1);

        public Builder domainName(String var1);

        public Builder createdTime(Instant var1);
    }
}

