/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.worklink.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.worklink.model.WebsiteAuthorizationProviderSummary;
import software.amazon.awssdk.services.worklink.model.WebsiteAuthorizationProvidersSummaryListCopier;
import software.amazon.awssdk.services.worklink.model.WorkLinkResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWebsiteAuthorizationProvidersResponse
extends WorkLinkResponse
implements ToCopyableBuilder<Builder, ListWebsiteAuthorizationProvidersResponse> {
    private static final SdkField<List<WebsiteAuthorizationProviderSummary>> WEBSITE_AUTHORIZATION_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListWebsiteAuthorizationProvidersResponse.getter(ListWebsiteAuthorizationProvidersResponse::websiteAuthorizationProviders)).setter(ListWebsiteAuthorizationProvidersResponse.setter(Builder::websiteAuthorizationProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebsiteAuthorizationProviders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WebsiteAuthorizationProviderSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListWebsiteAuthorizationProvidersResponse.getter(ListWebsiteAuthorizationProvidersResponse::nextToken)).setter(ListWebsiteAuthorizationProvidersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEBSITE_AUTHORIZATION_PROVIDERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<WebsiteAuthorizationProviderSummary> websiteAuthorizationProviders;
    private final String nextToken;

    private ListWebsiteAuthorizationProvidersResponse(BuilderImpl builder) {
        super(builder);
        this.websiteAuthorizationProviders = builder.websiteAuthorizationProviders;
        this.nextToken = builder.nextToken;
    }

    public boolean hasWebsiteAuthorizationProviders() {
        return this.websiteAuthorizationProviders != null && !(this.websiteAuthorizationProviders instanceof SdkAutoConstructList);
    }

    public List<WebsiteAuthorizationProviderSummary> websiteAuthorizationProviders() {
        return this.websiteAuthorizationProviders;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.websiteAuthorizationProviders());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWebsiteAuthorizationProvidersResponse)) {
            return false;
        }
        ListWebsiteAuthorizationProvidersResponse other = (ListWebsiteAuthorizationProvidersResponse)((Object)obj);
        return Objects.equals(this.websiteAuthorizationProviders(), other.websiteAuthorizationProviders()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListWebsiteAuthorizationProvidersResponse").add("WebsiteAuthorizationProviders", this.websiteAuthorizationProviders()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WebsiteAuthorizationProviders": {
                return Optional.ofNullable(clazz.cast(this.websiteAuthorizationProviders()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWebsiteAuthorizationProvidersResponse, T> g) {
        return obj -> g.apply((ListWebsiteAuthorizationProvidersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkLinkResponse.BuilderImpl
    implements Builder {
        private List<WebsiteAuthorizationProviderSummary> websiteAuthorizationProviders = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWebsiteAuthorizationProvidersResponse model) {
            super(model);
            this.websiteAuthorizationProviders(model.websiteAuthorizationProviders);
            this.nextToken(model.nextToken);
        }

        public final Collection<WebsiteAuthorizationProviderSummary.Builder> getWebsiteAuthorizationProviders() {
            return this.websiteAuthorizationProviders != null ? (Collection)this.websiteAuthorizationProviders.stream().map(WebsiteAuthorizationProviderSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder websiteAuthorizationProviders(Collection<WebsiteAuthorizationProviderSummary> websiteAuthorizationProviders) {
            this.websiteAuthorizationProviders = WebsiteAuthorizationProvidersSummaryListCopier.copy(websiteAuthorizationProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder websiteAuthorizationProviders(WebsiteAuthorizationProviderSummary ... websiteAuthorizationProviders) {
            this.websiteAuthorizationProviders(Arrays.asList(websiteAuthorizationProviders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder websiteAuthorizationProviders(Consumer<WebsiteAuthorizationProviderSummary.Builder> ... websiteAuthorizationProviders) {
            this.websiteAuthorizationProviders(Stream.of(websiteAuthorizationProviders).map(c -> (WebsiteAuthorizationProviderSummary)((WebsiteAuthorizationProviderSummary.Builder)WebsiteAuthorizationProviderSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setWebsiteAuthorizationProviders(Collection<WebsiteAuthorizationProviderSummary.BuilderImpl> websiteAuthorizationProviders) {
            this.websiteAuthorizationProviders = WebsiteAuthorizationProvidersSummaryListCopier.copyFromBuilder(websiteAuthorizationProviders);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListWebsiteAuthorizationProvidersResponse build() {
            return new ListWebsiteAuthorizationProvidersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkLinkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWebsiteAuthorizationProvidersResponse> {
        public Builder websiteAuthorizationProviders(Collection<WebsiteAuthorizationProviderSummary> var1);

        public Builder websiteAuthorizationProviders(WebsiteAuthorizationProviderSummary ... var1);

        public Builder websiteAuthorizationProviders(Consumer<WebsiteAuthorizationProviderSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

