/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.worklink.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.worklink.model.DomainStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainSummary> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DomainSummary.getter(DomainSummary::domainName)).setter(DomainSummary.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DomainSummary.getter(DomainSummary::displayName)).setter(DomainSummary.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DomainSummary.getter(DomainSummary::createdTime)).setter(DomainSummary.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> DOMAIN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DomainSummary.getter(DomainSummary::domainStatusAsString)).setter(DomainSummary.setter(Builder::domainStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, DISPLAY_NAME_FIELD, CREATED_TIME_FIELD, DOMAIN_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String domainName;
    private final String displayName;
    private final Instant createdTime;
    private final String domainStatus;

    private DomainSummary(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.displayName = builder.displayName;
        this.createdTime = builder.createdTime;
        this.domainStatus = builder.domainStatus;
    }

    public String domainName() {
        return this.domainName;
    }

    public String displayName() {
        return this.displayName;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public DomainStatus domainStatus() {
        return DomainStatus.fromValue(this.domainStatus);
    }

    public String domainStatusAsString() {
        return this.domainStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainSummary)) {
            return false;
        }
        DomainSummary other = (DomainSummary)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.domainStatusAsString(), other.domainStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"DomainSummary").add("DomainName", (Object)this.domainName()).add("DisplayName", (Object)this.displayName()).add("CreatedTime", (Object)this.createdTime()).add("DomainStatus", (Object)this.domainStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "DomainStatus": {
                return Optional.ofNullable(clazz.cast(this.domainStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainSummary, T> g) {
        return obj -> g.apply((DomainSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String displayName;
        private Instant createdTime;
        private String domainStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainSummary model) {
            this.domainName(model.domainName);
            this.displayName(model.displayName);
            this.createdTime(model.createdTime);
            this.domainStatus(model.domainStatus);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final String getDomainStatus() {
            return this.domainStatus;
        }

        @Override
        public final Builder domainStatus(String domainStatus) {
            this.domainStatus = domainStatus;
            return this;
        }

        @Override
        public final Builder domainStatus(DomainStatus domainStatus) {
            this.domainStatus(domainStatus == null ? null : domainStatus.toString());
            return this;
        }

        public final void setDomainStatus(String domainStatus) {
            this.domainStatus = domainStatus;
        }

        public DomainSummary build() {
            return new DomainSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainSummary> {
        public Builder domainName(String var1);

        public Builder displayName(String var1);

        public Builder createdTime(Instant var1);

        public Builder domainStatus(String var1);

        public Builder domainStatus(DomainStatus var1);
    }
}

