/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.worklink.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.worklink.model.DomainStatus;
import software.amazon.awssdk.services.worklink.model.WorkLinkResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDomainResponse
extends WorkLinkResponse
implements ToCopyableBuilder<Builder, DescribeDomainResponse> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(DescribeDomainResponse.getter(DescribeDomainResponse::domainName)).setter(DescribeDomainResponse.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(DescribeDomainResponse.getter(DescribeDomainResponse::displayName)).setter(DescribeDomainResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(DescribeDomainResponse.getter(DescribeDomainResponse::createdTime)).setter(DescribeDomainResponse.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> DOMAIN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainStatus").getter(DescribeDomainResponse.getter(DescribeDomainResponse::domainStatusAsString)).setter(DescribeDomainResponse.setter(Builder::domainStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainStatus").build()}).build();
    private static final SdkField<String> ACM_CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AcmCertificateArn").getter(DescribeDomainResponse.getter(DescribeDomainResponse::acmCertificateArn)).setter(DescribeDomainResponse.setter(Builder::acmCertificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcmCertificateArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, DISPLAY_NAME_FIELD, CREATED_TIME_FIELD, DOMAIN_STATUS_FIELD, ACM_CERTIFICATE_ARN_FIELD));
    private final String domainName;
    private final String displayName;
    private final Instant createdTime;
    private final String domainStatus;
    private final String acmCertificateArn;

    private DescribeDomainResponse(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.displayName = builder.displayName;
        this.createdTime = builder.createdTime;
        this.domainStatus = builder.domainStatus;
        this.acmCertificateArn = builder.acmCertificateArn;
    }

    public String domainName() {
        return this.domainName;
    }

    public String displayName() {
        return this.displayName;
    }

    public Instant createdTime() {
        return this.createdTime;
    }

    public DomainStatus domainStatus() {
        return DomainStatus.fromValue(this.domainStatus);
    }

    public String domainStatusAsString() {
        return this.domainStatus;
    }

    public String acmCertificateArn() {
        return this.acmCertificateArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.acmCertificateArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDomainResponse)) {
            return false;
        }
        DescribeDomainResponse other = (DescribeDomainResponse)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.domainStatusAsString(), other.domainStatusAsString()) && Objects.equals(this.acmCertificateArn(), other.acmCertificateArn());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDomainResponse").add("DomainName", (Object)this.domainName()).add("DisplayName", (Object)this.displayName()).add("CreatedTime", (Object)this.createdTime()).add("DomainStatus", (Object)this.domainStatusAsString()).add("AcmCertificateArn", (Object)this.acmCertificateArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "DomainStatus": {
                return Optional.ofNullable(clazz.cast(this.domainStatusAsString()));
            }
            case "AcmCertificateArn": {
                return Optional.ofNullable(clazz.cast(this.acmCertificateArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDomainResponse, T> g) {
        return obj -> g.apply((DescribeDomainResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkLinkResponse.BuilderImpl
    implements Builder {
        private String domainName;
        private String displayName;
        private Instant createdTime;
        private String domainStatus;
        private String acmCertificateArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDomainResponse model) {
            super(model);
            this.domainName(model.domainName);
            this.displayName(model.displayName);
            this.createdTime(model.createdTime);
            this.domainStatus(model.domainStatus);
            this.acmCertificateArn(model.acmCertificateArn);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final String getDomainStatus() {
            return this.domainStatus;
        }

        @Override
        public final Builder domainStatus(String domainStatus) {
            this.domainStatus = domainStatus;
            return this;
        }

        @Override
        public final Builder domainStatus(DomainStatus domainStatus) {
            this.domainStatus(domainStatus == null ? null : domainStatus.toString());
            return this;
        }

        public final void setDomainStatus(String domainStatus) {
            this.domainStatus = domainStatus;
        }

        public final String getAcmCertificateArn() {
            return this.acmCertificateArn;
        }

        @Override
        public final Builder acmCertificateArn(String acmCertificateArn) {
            this.acmCertificateArn = acmCertificateArn;
            return this;
        }

        public final void setAcmCertificateArn(String acmCertificateArn) {
            this.acmCertificateArn = acmCertificateArn;
        }

        @Override
        public DescribeDomainResponse build() {
            return new DescribeDomainResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkLinkResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDomainResponse> {
        public Builder domainName(String var1);

        public Builder displayName(String var1);

        public Builder createdTime(Instant var1);

        public Builder domainStatus(String var1);

        public Builder domainStatus(DomainStatus var1);

        public Builder acmCertificateArn(String var1);
    }
}

