/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.worklink.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.worklink.model.TagMapCopier;
import software.amazon.awssdk.services.worklink.model.WorkLinkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFleetRequest
extends WorkLinkRequest
implements ToCopyableBuilder<Builder, CreateFleetRequest> {
    private static final SdkField<String> FLEET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetName").getter(CreateFleetRequest.getter(CreateFleetRequest::fleetName)).setter(CreateFleetRequest.setter(Builder::fleetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetName").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(CreateFleetRequest.getter(CreateFleetRequest::displayName)).setter(CreateFleetRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<Boolean> OPTIMIZE_FOR_END_USER_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("OptimizeForEndUserLocation").getter(CreateFleetRequest.getter(CreateFleetRequest::optimizeForEndUserLocation)).setter(CreateFleetRequest.setter(Builder::optimizeForEndUserLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizeForEndUserLocation").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateFleetRequest.getter(CreateFleetRequest::tags)).setter(CreateFleetRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_NAME_FIELD, DISPLAY_NAME_FIELD, OPTIMIZE_FOR_END_USER_LOCATION_FIELD, TAGS_FIELD));
    private final String fleetName;
    private final String displayName;
    private final Boolean optimizeForEndUserLocation;
    private final Map<String, String> tags;

    private CreateFleetRequest(BuilderImpl builder) {
        super(builder);
        this.fleetName = builder.fleetName;
        this.displayName = builder.displayName;
        this.optimizeForEndUserLocation = builder.optimizeForEndUserLocation;
        this.tags = builder.tags;
    }

    public String fleetName() {
        return this.fleetName;
    }

    public String displayName() {
        return this.displayName;
    }

    public Boolean optimizeForEndUserLocation() {
        return this.optimizeForEndUserLocation;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.optimizeForEndUserLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFleetRequest)) {
            return false;
        }
        CreateFleetRequest other = (CreateFleetRequest)((Object)obj);
        return Objects.equals(this.fleetName(), other.fleetName()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.optimizeForEndUserLocation(), other.optimizeForEndUserLocation()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateFleetRequest").add("FleetName", (Object)this.fleetName()).add("DisplayName", (Object)this.displayName()).add("OptimizeForEndUserLocation", (Object)this.optimizeForEndUserLocation()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetName": {
                return Optional.ofNullable(clazz.cast(this.fleetName()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "OptimizeForEndUserLocation": {
                return Optional.ofNullable(clazz.cast(this.optimizeForEndUserLocation()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFleetRequest, T> g) {
        return obj -> g.apply((CreateFleetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkLinkRequest.BuilderImpl
    implements Builder {
        private String fleetName;
        private String displayName;
        private Boolean optimizeForEndUserLocation;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFleetRequest model) {
            super(model);
            this.fleetName(model.fleetName);
            this.displayName(model.displayName);
            this.optimizeForEndUserLocation(model.optimizeForEndUserLocation);
            this.tags(model.tags);
        }

        public final String getFleetName() {
            return this.fleetName;
        }

        @Override
        public final Builder fleetName(String fleetName) {
            this.fleetName = fleetName;
            return this;
        }

        public final void setFleetName(String fleetName) {
            this.fleetName = fleetName;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final Boolean getOptimizeForEndUserLocation() {
            return this.optimizeForEndUserLocation;
        }

        @Override
        public final Builder optimizeForEndUserLocation(Boolean optimizeForEndUserLocation) {
            this.optimizeForEndUserLocation = optimizeForEndUserLocation;
            return this;
        }

        public final void setOptimizeForEndUserLocation(Boolean optimizeForEndUserLocation) {
            this.optimizeForEndUserLocation = optimizeForEndUserLocation;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFleetRequest build() {
            return new CreateFleetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkLinkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFleetRequest> {
        public Builder fleetName(String var1);

        public Builder displayName(String var1);

        public Builder optimizeForEndUserLocation(Boolean var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

