/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.worklink.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateWebsiteCertificateAuthorityRequest extends WorkLinkRequest implements
        ToCopyableBuilder<DisassociateWebsiteCertificateAuthorityRequest.Builder, DisassociateWebsiteCertificateAuthorityRequest> {
    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetArn").getter(getter(DisassociateWebsiteCertificateAuthorityRequest::fleetArn))
            .setter(setter(Builder::fleetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()).build();

    private static final SdkField<String> WEBSITE_CA_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebsiteCaId").getter(getter(DisassociateWebsiteCertificateAuthorityRequest::websiteCaId))
            .setter(setter(Builder::websiteCaId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebsiteCaId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ARN_FIELD,
            WEBSITE_CA_ID_FIELD));

    private final String fleetArn;

    private final String websiteCaId;

    private DisassociateWebsiteCertificateAuthorityRequest(BuilderImpl builder) {
        super(builder);
        this.fleetArn = builder.fleetArn;
        this.websiteCaId = builder.websiteCaId;
    }

    /**
     * <p>
     * The ARN of the fleet.
     * </p>
     * 
     * @return The ARN of the fleet.
     */
    public final String fleetArn() {
        return fleetArn;
    }

    /**
     * <p>
     * A unique identifier for the CA.
     * </p>
     * 
     * @return A unique identifier for the CA.
     */
    public final String websiteCaId() {
        return websiteCaId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(websiteCaId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateWebsiteCertificateAuthorityRequest)) {
            return false;
        }
        DisassociateWebsiteCertificateAuthorityRequest other = (DisassociateWebsiteCertificateAuthorityRequest) obj;
        return Objects.equals(fleetArn(), other.fleetArn()) && Objects.equals(websiteCaId(), other.websiteCaId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateWebsiteCertificateAuthorityRequest").add("FleetArn", fleetArn())
                .add("WebsiteCaId", websiteCaId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FleetArn":
            return Optional.ofNullable(clazz.cast(fleetArn()));
        case "WebsiteCaId":
            return Optional.ofNullable(clazz.cast(websiteCaId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateWebsiteCertificateAuthorityRequest, T> g) {
        return obj -> g.apply((DisassociateWebsiteCertificateAuthorityRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkLinkRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateWebsiteCertificateAuthorityRequest> {
        /**
         * <p>
         * The ARN of the fleet.
         * </p>
         * 
         * @param fleetArn
         *        The ARN of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetArn(String fleetArn);

        /**
         * <p>
         * A unique identifier for the CA.
         * </p>
         * 
         * @param websiteCaId
         *        A unique identifier for the CA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder websiteCaId(String websiteCaId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkLinkRequest.BuilderImpl implements Builder {
        private String fleetArn;

        private String websiteCaId;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateWebsiteCertificateAuthorityRequest model) {
            super(model);
            fleetArn(model.fleetArn);
            websiteCaId(model.websiteCaId);
        }

        public final String getFleetArn() {
            return fleetArn;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        @Override
        @Transient
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final String getWebsiteCaId() {
            return websiteCaId;
        }

        public final void setWebsiteCaId(String websiteCaId) {
            this.websiteCaId = websiteCaId;
        }

        @Override
        @Transient
        public final Builder websiteCaId(String websiteCaId) {
            this.websiteCaId = websiteCaId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateWebsiteCertificateAuthorityRequest build() {
            return new DisassociateWebsiteCertificateAuthorityRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
