/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.worklink.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.worklink.model.WorkLinkRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateWebsiteCertificateAuthorityRequest
extends WorkLinkRequest
implements ToCopyableBuilder<Builder, DisassociateWebsiteCertificateAuthorityRequest> {
    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetArn").getter(DisassociateWebsiteCertificateAuthorityRequest.getter(DisassociateWebsiteCertificateAuthorityRequest::fleetArn)).setter(DisassociateWebsiteCertificateAuthorityRequest.setter(Builder::fleetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetArn").build()}).build();
    private static final SdkField<String> WEBSITE_CA_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebsiteCaId").getter(DisassociateWebsiteCertificateAuthorityRequest.getter(DisassociateWebsiteCertificateAuthorityRequest::websiteCaId)).setter(DisassociateWebsiteCertificateAuthorityRequest.setter(Builder::websiteCaId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebsiteCaId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ARN_FIELD, WEBSITE_CA_ID_FIELD));
    private final String fleetArn;
    private final String websiteCaId;

    private DisassociateWebsiteCertificateAuthorityRequest(BuilderImpl builder) {
        super(builder);
        this.fleetArn = builder.fleetArn;
        this.websiteCaId = builder.websiteCaId;
    }

    public final String fleetArn() {
        return this.fleetArn;
    }

    public final String websiteCaId() {
        return this.websiteCaId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.websiteCaId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateWebsiteCertificateAuthorityRequest)) {
            return false;
        }
        DisassociateWebsiteCertificateAuthorityRequest other = (DisassociateWebsiteCertificateAuthorityRequest)((Object)obj);
        return Objects.equals(this.fleetArn(), other.fleetArn()) && Objects.equals(this.websiteCaId(), other.websiteCaId());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateWebsiteCertificateAuthorityRequest").add("FleetArn", (Object)this.fleetArn()).add("WebsiteCaId", (Object)this.websiteCaId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetArn": {
                return Optional.ofNullable(clazz.cast(this.fleetArn()));
            }
            case "WebsiteCaId": {
                return Optional.ofNullable(clazz.cast(this.websiteCaId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateWebsiteCertificateAuthorityRequest, T> g) {
        return obj -> g.apply((DisassociateWebsiteCertificateAuthorityRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkLinkRequest.BuilderImpl
    implements Builder {
        private String fleetArn;
        private String websiteCaId;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateWebsiteCertificateAuthorityRequest model) {
            super(model);
            this.fleetArn(model.fleetArn);
            this.websiteCaId(model.websiteCaId);
        }

        public final String getFleetArn() {
            return this.fleetArn;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        @Override
        @Transient
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final String getWebsiteCaId() {
            return this.websiteCaId;
        }

        public final void setWebsiteCaId(String websiteCaId) {
            this.websiteCaId = websiteCaId;
        }

        @Override
        @Transient
        public final Builder websiteCaId(String websiteCaId) {
            this.websiteCaId = websiteCaId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateWebsiteCertificateAuthorityRequest build() {
            return new DisassociateWebsiteCertificateAuthorityRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkLinkRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateWebsiteCertificateAuthorityRequest> {
        public Builder fleetArn(String var1);

        public Builder websiteCaId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

