/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.worklink;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.worklink.DefaultWorkLinkBaseClientBuilder;
import software.amazon.awssdk.services.worklink.DefaultWorkLinkClient;
import software.amazon.awssdk.services.worklink.WorkLinkClient;
import software.amazon.awssdk.services.worklink.WorkLinkClientBuilder;
import software.amazon.awssdk.services.worklink.WorkLinkServiceClientConfiguration;
import software.amazon.awssdk.services.worklink.endpoints.WorkLinkEndpointProvider;

@SdkInternalApi
final class DefaultWorkLinkClientBuilder
extends DefaultWorkLinkBaseClientBuilder<WorkLinkClientBuilder, WorkLinkClient>
implements WorkLinkClientBuilder {
    DefaultWorkLinkClientBuilder() {
    }

    @Override
    public DefaultWorkLinkClientBuilder endpointProvider(WorkLinkEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final WorkLinkClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultWorkLinkClientBuilder.validateClientOptions(clientConfiguration);
        WorkLinkServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultWorkLinkClient client = new DefaultWorkLinkClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private WorkLinkServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return WorkLinkServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

