/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.worklink.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.worklink.WorkLinkAsyncClient;
import software.amazon.awssdk.services.worklink.model.ListFleetsRequest;
import software.amazon.awssdk.services.worklink.model.ListFleetsResponse;

public class ListFleetsPublisher
implements SdkPublisher<ListFleetsResponse> {
    private final WorkLinkAsyncClient client;
    private final ListFleetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFleetsPublisher(WorkLinkAsyncClient client, ListFleetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFleetsPublisher(WorkLinkAsyncClient client, ListFleetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFleetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFleetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListFleetsResponseFetcher
    implements AsyncPageFetcher<ListFleetsResponse> {
        private ListFleetsResponseFetcher() {
        }

        public boolean hasNextPage(ListFleetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFleetsResponse> nextPage(ListFleetsResponse previousPage) {
            if (previousPage == null) {
                return ListFleetsPublisher.this.client.listFleets(ListFleetsPublisher.this.firstRequest);
            }
            return ListFleetsPublisher.this.client.listFleets((ListFleetsRequest)((Object)ListFleetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

