/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.worklink.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.worklink.WorkLinkAsyncClient;
import software.amazon.awssdk.services.worklink.model.ListWebsiteAuthorizationProvidersRequest;
import software.amazon.awssdk.services.worklink.model.ListWebsiteAuthorizationProvidersResponse;

public class ListWebsiteAuthorizationProvidersPublisher
implements SdkPublisher<ListWebsiteAuthorizationProvidersResponse> {
    private final WorkLinkAsyncClient client;
    private final ListWebsiteAuthorizationProvidersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWebsiteAuthorizationProvidersPublisher(WorkLinkAsyncClient client, ListWebsiteAuthorizationProvidersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWebsiteAuthorizationProvidersPublisher(WorkLinkAsyncClient client, ListWebsiteAuthorizationProvidersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWebsiteAuthorizationProvidersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWebsiteAuthorizationProvidersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListWebsiteAuthorizationProvidersResponseFetcher
    implements AsyncPageFetcher<ListWebsiteAuthorizationProvidersResponse> {
        private ListWebsiteAuthorizationProvidersResponseFetcher() {
        }

        public boolean hasNextPage(ListWebsiteAuthorizationProvidersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWebsiteAuthorizationProvidersResponse> nextPage(ListWebsiteAuthorizationProvidersResponse previousPage) {
            if (previousPage == null) {
                return ListWebsiteAuthorizationProvidersPublisher.this.client.listWebsiteAuthorizationProviders(ListWebsiteAuthorizationProvidersPublisher.this.firstRequest);
            }
            return ListWebsiteAuthorizationProvidersPublisher.this.client.listWebsiteAuthorizationProviders((ListWebsiteAuthorizationProvidersRequest)((Object)ListWebsiteAuthorizationProvidersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

