/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.worklink;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.worklink.DefaultWorkLinkBaseClientBuilder;
import software.amazon.awssdk.services.worklink.DefaultWorkLinkClient;
import software.amazon.awssdk.services.worklink.WorkLinkClient;
import software.amazon.awssdk.services.worklink.WorkLinkClientBuilder;
import software.amazon.awssdk.services.worklink.WorkLinkServiceClientConfiguration;
import software.amazon.awssdk.services.worklink.endpoints.WorkLinkEndpointProvider;

@SdkInternalApi
final class DefaultWorkLinkClientBuilder
extends DefaultWorkLinkBaseClientBuilder<WorkLinkClientBuilder, WorkLinkClient>
implements WorkLinkClientBuilder {
    DefaultWorkLinkClientBuilder() {
    }

    @Override
    public DefaultWorkLinkClientBuilder endpointProvider(WorkLinkEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final WorkLinkClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultWorkLinkClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        WorkLinkServiceClientConfiguration serviceClientConfiguration = WorkLinkServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultWorkLinkClient(serviceClientConfiguration, clientConfiguration);
    }
}

