/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.worklink;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.worklink.model.AssociateDomainRequest;
import software.amazon.awssdk.services.worklink.model.AssociateDomainResponse;
import software.amazon.awssdk.services.worklink.model.AssociateWebsiteAuthorizationProviderRequest;
import software.amazon.awssdk.services.worklink.model.AssociateWebsiteAuthorizationProviderResponse;
import software.amazon.awssdk.services.worklink.model.AssociateWebsiteCertificateAuthorityRequest;
import software.amazon.awssdk.services.worklink.model.AssociateWebsiteCertificateAuthorityResponse;
import software.amazon.awssdk.services.worklink.model.CreateFleetRequest;
import software.amazon.awssdk.services.worklink.model.CreateFleetResponse;
import software.amazon.awssdk.services.worklink.model.DeleteFleetRequest;
import software.amazon.awssdk.services.worklink.model.DeleteFleetResponse;
import software.amazon.awssdk.services.worklink.model.DescribeAuditStreamConfigurationRequest;
import software.amazon.awssdk.services.worklink.model.DescribeAuditStreamConfigurationResponse;
import software.amazon.awssdk.services.worklink.model.DescribeCompanyNetworkConfigurationRequest;
import software.amazon.awssdk.services.worklink.model.DescribeCompanyNetworkConfigurationResponse;
import software.amazon.awssdk.services.worklink.model.DescribeDevicePolicyConfigurationRequest;
import software.amazon.awssdk.services.worklink.model.DescribeDevicePolicyConfigurationResponse;
import software.amazon.awssdk.services.worklink.model.DescribeDeviceRequest;
import software.amazon.awssdk.services.worklink.model.DescribeDeviceResponse;
import software.amazon.awssdk.services.worklink.model.DescribeDomainRequest;
import software.amazon.awssdk.services.worklink.model.DescribeDomainResponse;
import software.amazon.awssdk.services.worklink.model.DescribeFleetMetadataRequest;
import software.amazon.awssdk.services.worklink.model.DescribeFleetMetadataResponse;
import software.amazon.awssdk.services.worklink.model.DescribeIdentityProviderConfigurationRequest;
import software.amazon.awssdk.services.worklink.model.DescribeIdentityProviderConfigurationResponse;
import software.amazon.awssdk.services.worklink.model.DescribeWebsiteCertificateAuthorityRequest;
import software.amazon.awssdk.services.worklink.model.DescribeWebsiteCertificateAuthorityResponse;
import software.amazon.awssdk.services.worklink.model.DisassociateDomainRequest;
import software.amazon.awssdk.services.worklink.model.DisassociateDomainResponse;
import software.amazon.awssdk.services.worklink.model.DisassociateWebsiteAuthorizationProviderRequest;
import software.amazon.awssdk.services.worklink.model.DisassociateWebsiteAuthorizationProviderResponse;
import software.amazon.awssdk.services.worklink.model.DisassociateWebsiteCertificateAuthorityRequest;
import software.amazon.awssdk.services.worklink.model.DisassociateWebsiteCertificateAuthorityResponse;
import software.amazon.awssdk.services.worklink.model.ListDevicesRequest;
import software.amazon.awssdk.services.worklink.model.ListDevicesResponse;
import software.amazon.awssdk.services.worklink.model.ListDomainsRequest;
import software.amazon.awssdk.services.worklink.model.ListDomainsResponse;
import software.amazon.awssdk.services.worklink.model.ListFleetsRequest;
import software.amazon.awssdk.services.worklink.model.ListFleetsResponse;
import software.amazon.awssdk.services.worklink.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.worklink.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.worklink.model.ListWebsiteAuthorizationProvidersRequest;
import software.amazon.awssdk.services.worklink.model.ListWebsiteAuthorizationProvidersResponse;
import software.amazon.awssdk.services.worklink.model.ListWebsiteCertificateAuthoritiesRequest;
import software.amazon.awssdk.services.worklink.model.ListWebsiteCertificateAuthoritiesResponse;
import software.amazon.awssdk.services.worklink.model.RestoreDomainAccessRequest;
import software.amazon.awssdk.services.worklink.model.RestoreDomainAccessResponse;
import software.amazon.awssdk.services.worklink.model.RevokeDomainAccessRequest;
import software.amazon.awssdk.services.worklink.model.RevokeDomainAccessResponse;
import software.amazon.awssdk.services.worklink.model.SignOutUserRequest;
import software.amazon.awssdk.services.worklink.model.SignOutUserResponse;
import software.amazon.awssdk.services.worklink.model.TagResourceRequest;
import software.amazon.awssdk.services.worklink.model.TagResourceResponse;
import software.amazon.awssdk.services.worklink.model.UntagResourceRequest;
import software.amazon.awssdk.services.worklink.model.UntagResourceResponse;
import software.amazon.awssdk.services.worklink.model.UpdateAuditStreamConfigurationRequest;
import software.amazon.awssdk.services.worklink.model.UpdateAuditStreamConfigurationResponse;
import software.amazon.awssdk.services.worklink.model.UpdateCompanyNetworkConfigurationRequest;
import software.amazon.awssdk.services.worklink.model.UpdateCompanyNetworkConfigurationResponse;
import software.amazon.awssdk.services.worklink.model.UpdateDevicePolicyConfigurationRequest;
import software.amazon.awssdk.services.worklink.model.UpdateDevicePolicyConfigurationResponse;
import software.amazon.awssdk.services.worklink.model.UpdateDomainMetadataRequest;
import software.amazon.awssdk.services.worklink.model.UpdateDomainMetadataResponse;
import software.amazon.awssdk.services.worklink.model.UpdateFleetMetadataRequest;
import software.amazon.awssdk.services.worklink.model.UpdateFleetMetadataResponse;
import software.amazon.awssdk.services.worklink.model.UpdateIdentityProviderConfigurationRequest;
import software.amazon.awssdk.services.worklink.model.UpdateIdentityProviderConfigurationResponse;
import software.amazon.awssdk.services.worklink.paginators.ListDevicesPublisher;
import software.amazon.awssdk.services.worklink.paginators.ListDomainsPublisher;
import software.amazon.awssdk.services.worklink.paginators.ListFleetsPublisher;
import software.amazon.awssdk.services.worklink.paginators.ListWebsiteAuthorizationProvidersPublisher;
import software.amazon.awssdk.services.worklink.paginators.ListWebsiteCertificateAuthoritiesPublisher;

/**
 * Service client for accessing WorkLink asynchronously. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon WorkLink is a cloud-based service that provides secure access to internal websites and web apps from iOS and
 * Android phones. In a single step, your users, such as employees, can access internal websites as efficiently as they
 * access any other public website. They enter a URL in their web browser, or choose a link to an internal website in an
 * email. Amazon WorkLink authenticates the user's access and securely renders authorized internal web content in a
 * secure rendering service in the AWS cloud. Amazon WorkLink doesn't download or store any internal web content on
 * mobile devices.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface WorkLinkAsyncClient extends AwsClient {
    String SERVICE_NAME = "worklink";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "worklink";

    /**
     * <p>
     * Specifies a domain to be associated to Amazon WorkLink.
     * </p>
     *
     * @param associateDomainRequest
     * @return A Java Future containing the result of the AssociateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.AssociateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/AssociateDomain" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<AssociateDomainResponse> associateDomain(AssociateDomainRequest associateDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies a domain to be associated to Amazon WorkLink.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateDomainRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateDomainRequest#builder()}
     * </p>
     *
     * @param associateDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.AssociateDomainRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AssociateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.AssociateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/AssociateDomain" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<AssociateDomainResponse> associateDomain(
            Consumer<AssociateDomainRequest.Builder> associateDomainRequest) {
        return associateDomain(AssociateDomainRequest.builder().applyMutation(associateDomainRequest).build());
    }

    /**
     * <p>
     * Associates a website authorization provider with a specified fleet. This is used to authorize users against
     * associated websites in the company network.
     * </p>
     *
     * @param associateWebsiteAuthorizationProviderRequest
     * @return A Java Future containing the result of the AssociateWebsiteAuthorizationProvider operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.AssociateWebsiteAuthorizationProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/AssociateWebsiteAuthorizationProvider"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<AssociateWebsiteAuthorizationProviderResponse> associateWebsiteAuthorizationProvider(
            AssociateWebsiteAuthorizationProviderRequest associateWebsiteAuthorizationProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a website authorization provider with a specified fleet. This is used to authorize users against
     * associated websites in the company network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateWebsiteAuthorizationProviderRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateWebsiteAuthorizationProviderRequest#builder()}
     * </p>
     *
     * @param associateWebsiteAuthorizationProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.AssociateWebsiteAuthorizationProviderRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AssociateWebsiteAuthorizationProvider operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.AssociateWebsiteAuthorizationProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/AssociateWebsiteAuthorizationProvider"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<AssociateWebsiteAuthorizationProviderResponse> associateWebsiteAuthorizationProvider(
            Consumer<AssociateWebsiteAuthorizationProviderRequest.Builder> associateWebsiteAuthorizationProviderRequest) {
        return associateWebsiteAuthorizationProvider(AssociateWebsiteAuthorizationProviderRequest.builder()
                .applyMutation(associateWebsiteAuthorizationProviderRequest).build());
    }

    /**
     * <p>
     * Imports the root certificate of a certificate authority (CA) used to obtain TLS certificates used by associated
     * websites within the company network.
     * </p>
     *
     * @param associateWebsiteCertificateAuthorityRequest
     * @return A Java Future containing the result of the AssociateWebsiteCertificateAuthority operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.AssociateWebsiteCertificateAuthority
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/AssociateWebsiteCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<AssociateWebsiteCertificateAuthorityResponse> associateWebsiteCertificateAuthority(
            AssociateWebsiteCertificateAuthorityRequest associateWebsiteCertificateAuthorityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports the root certificate of a certificate authority (CA) used to obtain TLS certificates used by associated
     * websites within the company network.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link AssociateWebsiteCertificateAuthorityRequest.Builder} avoiding the need to create one manually via
     * {@link AssociateWebsiteCertificateAuthorityRequest#builder()}
     * </p>
     *
     * @param associateWebsiteCertificateAuthorityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.AssociateWebsiteCertificateAuthorityRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AssociateWebsiteCertificateAuthority operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.AssociateWebsiteCertificateAuthority
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/AssociateWebsiteCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<AssociateWebsiteCertificateAuthorityResponse> associateWebsiteCertificateAuthority(
            Consumer<AssociateWebsiteCertificateAuthorityRequest.Builder> associateWebsiteCertificateAuthorityRequest) {
        return associateWebsiteCertificateAuthority(AssociateWebsiteCertificateAuthorityRequest.builder()
                .applyMutation(associateWebsiteCertificateAuthorityRequest).build());
    }

    /**
     * <p>
     * Creates a fleet. A fleet consists of resources and the configuration that delivers associated websites to
     * authorized users who download and set up the Amazon WorkLink app.
     * </p>
     *
     * @param createFleetRequest
     * @return A Java Future containing the result of the CreateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<CreateFleetResponse> createFleet(CreateFleetRequest createFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a fleet. A fleet consists of resources and the configuration that delivers associated websites to
     * authorized users who download and set up the Amazon WorkLink app.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFleetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFleetRequest#builder()}
     * </p>
     *
     * @param createFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.CreateFleetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<CreateFleetResponse> createFleet(Consumer<CreateFleetRequest.Builder> createFleetRequest) {
        return createFleet(CreateFleetRequest.builder().applyMutation(createFleetRequest).build());
    }

    /**
     * <p>
     * Deletes a fleet. Prevents users from accessing previously associated websites.
     * </p>
     *
     * @param deleteFleetRequest
     * @return A Java Future containing the result of the DeleteFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.DeleteFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<DeleteFleetResponse> deleteFleet(DeleteFleetRequest deleteFleetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a fleet. Prevents users from accessing previously associated websites.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFleetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFleetRequest#builder()}
     * </p>
     *
     * @param deleteFleetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.DeleteFleetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteFleet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.DeleteFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<DeleteFleetResponse> deleteFleet(Consumer<DeleteFleetRequest.Builder> deleteFleetRequest) {
        return deleteFleet(DeleteFleetRequest.builder().applyMutation(deleteFleetRequest).build());
    }

    /**
     * <p>
     * Describes the configuration for delivering audit streams to the customer account.
     * </p>
     *
     * @param describeAuditStreamConfigurationRequest
     * @return A Java Future containing the result of the DescribeAuditStreamConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.DescribeAuditStreamConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeAuditStreamConfiguration"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<DescribeAuditStreamConfigurationResponse> describeAuditStreamConfiguration(
            DescribeAuditStreamConfigurationRequest describeAuditStreamConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the configuration for delivering audit streams to the customer account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAuditStreamConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAuditStreamConfigurationRequest#builder()}
     * </p>
     *
     * @param describeAuditStreamConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.DescribeAuditStreamConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeAuditStreamConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.DescribeAuditStreamConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeAuditStreamConfiguration"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<DescribeAuditStreamConfigurationResponse> describeAuditStreamConfiguration(
            Consumer<DescribeAuditStreamConfigurationRequest.Builder> describeAuditStreamConfigurationRequest) {
        return describeAuditStreamConfiguration(DescribeAuditStreamConfigurationRequest.builder()
                .applyMutation(describeAuditStreamConfigurationRequest).build());
    }

    /**
     * <p>
     * Describes the networking configuration to access the internal websites associated with the specified fleet.
     * </p>
     *
     * @param describeCompanyNetworkConfigurationRequest
     * @return A Java Future containing the result of the DescribeCompanyNetworkConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.DescribeCompanyNetworkConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeCompanyNetworkConfiguration"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<DescribeCompanyNetworkConfigurationResponse> describeCompanyNetworkConfiguration(
            DescribeCompanyNetworkConfigurationRequest describeCompanyNetworkConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the networking configuration to access the internal websites associated with the specified fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCompanyNetworkConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCompanyNetworkConfigurationRequest#builder()}
     * </p>
     *
     * @param describeCompanyNetworkConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.DescribeCompanyNetworkConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeCompanyNetworkConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.DescribeCompanyNetworkConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeCompanyNetworkConfiguration"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<DescribeCompanyNetworkConfigurationResponse> describeCompanyNetworkConfiguration(
            Consumer<DescribeCompanyNetworkConfigurationRequest.Builder> describeCompanyNetworkConfigurationRequest) {
        return describeCompanyNetworkConfiguration(DescribeCompanyNetworkConfigurationRequest.builder()
                .applyMutation(describeCompanyNetworkConfigurationRequest).build());
    }

    /**
     * <p>
     * Provides information about a user's device.
     * </p>
     *
     * @param describeDeviceRequest
     * @return A Java Future containing the result of the DescribeDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.DescribeDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeDevice" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<DescribeDeviceResponse> describeDevice(DescribeDeviceRequest describeDeviceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about a user's device.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeviceRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeDeviceRequest#builder()}
     * </p>
     *
     * @param describeDeviceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.DescribeDeviceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeDevice operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.DescribeDevice
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeDevice" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<DescribeDeviceResponse> describeDevice(Consumer<DescribeDeviceRequest.Builder> describeDeviceRequest) {
        return describeDevice(DescribeDeviceRequest.builder().applyMutation(describeDeviceRequest).build());
    }

    /**
     * <p>
     * Describes the device policy configuration for the specified fleet.
     * </p>
     *
     * @param describeDevicePolicyConfigurationRequest
     * @return A Java Future containing the result of the DescribeDevicePolicyConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.DescribeDevicePolicyConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeDevicePolicyConfiguration"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<DescribeDevicePolicyConfigurationResponse> describeDevicePolicyConfiguration(
            DescribeDevicePolicyConfigurationRequest describeDevicePolicyConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the device policy configuration for the specified fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDevicePolicyConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDevicePolicyConfigurationRequest#builder()}
     * </p>
     *
     * @param describeDevicePolicyConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.DescribeDevicePolicyConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeDevicePolicyConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.DescribeDevicePolicyConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeDevicePolicyConfiguration"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<DescribeDevicePolicyConfigurationResponse> describeDevicePolicyConfiguration(
            Consumer<DescribeDevicePolicyConfigurationRequest.Builder> describeDevicePolicyConfigurationRequest) {
        return describeDevicePolicyConfiguration(DescribeDevicePolicyConfigurationRequest.builder()
                .applyMutation(describeDevicePolicyConfigurationRequest).build());
    }

    /**
     * <p>
     * Provides information about the domain.
     * </p>
     *
     * @param describeDomainRequest
     * @return A Java Future containing the result of the DescribeDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.DescribeDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeDomain" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<DescribeDomainResponse> describeDomain(DescribeDomainRequest describeDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeDomainRequest#builder()}
     * </p>
     *
     * @param describeDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.DescribeDomainRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.DescribeDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeDomain" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<DescribeDomainResponse> describeDomain(Consumer<DescribeDomainRequest.Builder> describeDomainRequest) {
        return describeDomain(DescribeDomainRequest.builder().applyMutation(describeDomainRequest).build());
    }

    /**
     * <p>
     * Provides basic information for the specified fleet, excluding identity provider, networking, and device
     * configuration details.
     * </p>
     *
     * @param describeFleetMetadataRequest
     * @return A Java Future containing the result of the DescribeFleetMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.DescribeFleetMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeFleetMetadata"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<DescribeFleetMetadataResponse> describeFleetMetadata(
            DescribeFleetMetadataRequest describeFleetMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides basic information for the specified fleet, excluding identity provider, networking, and device
     * configuration details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFleetMetadataRequest#builder()}
     * </p>
     *
     * @param describeFleetMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.DescribeFleetMetadataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeFleetMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.DescribeFleetMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeFleetMetadata"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<DescribeFleetMetadataResponse> describeFleetMetadata(
            Consumer<DescribeFleetMetadataRequest.Builder> describeFleetMetadataRequest) {
        return describeFleetMetadata(DescribeFleetMetadataRequest.builder().applyMutation(describeFleetMetadataRequest).build());
    }

    /**
     * <p>
     * Describes the identity provider configuration of the specified fleet.
     * </p>
     *
     * @param describeIdentityProviderConfigurationRequest
     * @return A Java Future containing the result of the DescribeIdentityProviderConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.DescribeIdentityProviderConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeIdentityProviderConfiguration"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<DescribeIdentityProviderConfigurationResponse> describeIdentityProviderConfiguration(
            DescribeIdentityProviderConfigurationRequest describeIdentityProviderConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the identity provider configuration of the specified fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeIdentityProviderConfigurationRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeIdentityProviderConfigurationRequest#builder()}
     * </p>
     *
     * @param describeIdentityProviderConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.DescribeIdentityProviderConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeIdentityProviderConfiguration operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.DescribeIdentityProviderConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeIdentityProviderConfiguration"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<DescribeIdentityProviderConfigurationResponse> describeIdentityProviderConfiguration(
            Consumer<DescribeIdentityProviderConfigurationRequest.Builder> describeIdentityProviderConfigurationRequest) {
        return describeIdentityProviderConfiguration(DescribeIdentityProviderConfigurationRequest.builder()
                .applyMutation(describeIdentityProviderConfigurationRequest).build());
    }

    /**
     * <p>
     * Provides information about the certificate authority.
     * </p>
     *
     * @param describeWebsiteCertificateAuthorityRequest
     * @return A Java Future containing the result of the DescribeWebsiteCertificateAuthority operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.DescribeWebsiteCertificateAuthority
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeWebsiteCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<DescribeWebsiteCertificateAuthorityResponse> describeWebsiteCertificateAuthority(
            DescribeWebsiteCertificateAuthorityRequest describeWebsiteCertificateAuthorityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the certificate authority.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWebsiteCertificateAuthorityRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeWebsiteCertificateAuthorityRequest#builder()}
     * </p>
     *
     * @param describeWebsiteCertificateAuthorityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.DescribeWebsiteCertificateAuthorityRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeWebsiteCertificateAuthority operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.DescribeWebsiteCertificateAuthority
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DescribeWebsiteCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<DescribeWebsiteCertificateAuthorityResponse> describeWebsiteCertificateAuthority(
            Consumer<DescribeWebsiteCertificateAuthorityRequest.Builder> describeWebsiteCertificateAuthorityRequest) {
        return describeWebsiteCertificateAuthority(DescribeWebsiteCertificateAuthorityRequest.builder()
                .applyMutation(describeWebsiteCertificateAuthorityRequest).build());
    }

    /**
     * <p>
     * Disassociates a domain from Amazon WorkLink. End users lose the ability to access the domain with Amazon
     * WorkLink.
     * </p>
     *
     * @param disassociateDomainRequest
     * @return A Java Future containing the result of the DisassociateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.DisassociateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DisassociateDomain" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<DisassociateDomainResponse> disassociateDomain(DisassociateDomainRequest disassociateDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a domain from Amazon WorkLink. End users lose the ability to access the domain with Amazon
     * WorkLink.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateDomainRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateDomainRequest#builder()}
     * </p>
     *
     * @param disassociateDomainRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.DisassociateDomainRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.DisassociateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DisassociateDomain" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<DisassociateDomainResponse> disassociateDomain(
            Consumer<DisassociateDomainRequest.Builder> disassociateDomainRequest) {
        return disassociateDomain(DisassociateDomainRequest.builder().applyMutation(disassociateDomainRequest).build());
    }

    /**
     * <p>
     * Disassociates a website authorization provider from a specified fleet. After the disassociation, users can't load
     * any associated websites that require this authorization provider.
     * </p>
     *
     * @param disassociateWebsiteAuthorizationProviderRequest
     * @return A Java Future containing the result of the DisassociateWebsiteAuthorizationProvider operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.DisassociateWebsiteAuthorizationProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DisassociateWebsiteAuthorizationProvider"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<DisassociateWebsiteAuthorizationProviderResponse> disassociateWebsiteAuthorizationProvider(
            DisassociateWebsiteAuthorizationProviderRequest disassociateWebsiteAuthorizationProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a website authorization provider from a specified fleet. After the disassociation, users can't load
     * any associated websites that require this authorization provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateWebsiteAuthorizationProviderRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateWebsiteAuthorizationProviderRequest#builder()}
     * </p>
     *
     * @param disassociateWebsiteAuthorizationProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.DisassociateWebsiteAuthorizationProviderRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateWebsiteAuthorizationProvider operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>ResourceAlreadyExistsException The resource already exists.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.DisassociateWebsiteAuthorizationProvider
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DisassociateWebsiteAuthorizationProvider"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<DisassociateWebsiteAuthorizationProviderResponse> disassociateWebsiteAuthorizationProvider(
            Consumer<DisassociateWebsiteAuthorizationProviderRequest.Builder> disassociateWebsiteAuthorizationProviderRequest) {
        return disassociateWebsiteAuthorizationProvider(DisassociateWebsiteAuthorizationProviderRequest.builder()
                .applyMutation(disassociateWebsiteAuthorizationProviderRequest).build());
    }

    /**
     * <p>
     * Removes a certificate authority (CA).
     * </p>
     *
     * @param disassociateWebsiteCertificateAuthorityRequest
     * @return A Java Future containing the result of the DisassociateWebsiteCertificateAuthority operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.DisassociateWebsiteCertificateAuthority
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DisassociateWebsiteCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<DisassociateWebsiteCertificateAuthorityResponse> disassociateWebsiteCertificateAuthority(
            DisassociateWebsiteCertificateAuthorityRequest disassociateWebsiteCertificateAuthorityRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a certificate authority (CA).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateWebsiteCertificateAuthorityRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateWebsiteCertificateAuthorityRequest#builder()}
     * </p>
     *
     * @param disassociateWebsiteCertificateAuthorityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.DisassociateWebsiteCertificateAuthorityRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateWebsiteCertificateAuthority operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.DisassociateWebsiteCertificateAuthority
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DisassociateWebsiteCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<DisassociateWebsiteCertificateAuthorityResponse> disassociateWebsiteCertificateAuthority(
            Consumer<DisassociateWebsiteCertificateAuthorityRequest.Builder> disassociateWebsiteCertificateAuthorityRequest) {
        return disassociateWebsiteCertificateAuthority(DisassociateWebsiteCertificateAuthorityRequest.builder()
                .applyMutation(disassociateWebsiteCertificateAuthorityRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of devices registered with the specified fleet.
     * </p>
     *
     * @param listDevicesRequest
     * @return A Java Future containing the result of the ListDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListDevices" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<ListDevicesResponse> listDevices(ListDevicesRequest listDevicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of devices registered with the specified fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDevicesRequest#builder()}
     * </p>
     *
     * @param listDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.ListDevicesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDevices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListDevices" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<ListDevicesResponse> listDevices(Consumer<ListDevicesRequest.Builder> listDevicesRequest) {
        return listDevices(ListDevicesRequest.builder().applyMutation(listDevicesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listDevices(software.amazon.awssdk.services.worklink.model.ListDevicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListDevicesPublisher publisher = client.listDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListDevicesPublisher publisher = client.listDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.worklink.model.ListDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.worklink.model.ListDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevices(software.amazon.awssdk.services.worklink.model.ListDevicesRequest)} operation.</b>
     * </p>
     *
     * @param listDevicesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListDevices" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default ListDevicesPublisher listDevicesPaginator(ListDevicesRequest listDevicesRequest) {
        return new ListDevicesPublisher(this, listDevicesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listDevices(software.amazon.awssdk.services.worklink.model.ListDevicesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListDevicesPublisher publisher = client.listDevicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListDevicesPublisher publisher = client.listDevicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.worklink.model.ListDevicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.worklink.model.ListDevicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDevices(software.amazon.awssdk.services.worklink.model.ListDevicesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDevicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDevicesRequest#builder()}
     * </p>
     *
     * @param listDevicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.ListDevicesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.ListDevices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListDevices" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default ListDevicesPublisher listDevicesPaginator(Consumer<ListDevicesRequest.Builder> listDevicesRequest) {
        return listDevicesPaginator(ListDevicesRequest.builder().applyMutation(listDevicesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of domains associated to a specified fleet.
     * </p>
     *
     * @param listDomainsRequest
     * @return A Java Future containing the result of the ListDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListDomains" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<ListDomainsResponse> listDomains(ListDomainsRequest listDomainsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of domains associated to a specified fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDomainsRequest#builder()}
     * </p>
     *
     * @param listDomainsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.ListDomainsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListDomains" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<ListDomainsResponse> listDomains(Consumer<ListDomainsRequest.Builder> listDomainsRequest) {
        return listDomains(ListDomainsRequest.builder().applyMutation(listDomainsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listDomains(software.amazon.awssdk.services.worklink.model.ListDomainsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListDomainsPublisher publisher = client.listDomainsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListDomainsPublisher publisher = client.listDomainsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.worklink.model.ListDomainsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.worklink.model.ListDomainsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomains(software.amazon.awssdk.services.worklink.model.ListDomainsRequest)} operation.</b>
     * </p>
     *
     * @param listDomainsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListDomains" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default ListDomainsPublisher listDomainsPaginator(ListDomainsRequest listDomainsRequest) {
        return new ListDomainsPublisher(this, listDomainsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listDomains(software.amazon.awssdk.services.worklink.model.ListDomainsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListDomainsPublisher publisher = client.listDomainsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListDomainsPublisher publisher = client.listDomainsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.worklink.model.ListDomainsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.worklink.model.ListDomainsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomains(software.amazon.awssdk.services.worklink.model.ListDomainsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDomainsRequest#builder()}
     * </p>
     *
     * @param listDomainsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.ListDomainsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListDomains" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default ListDomainsPublisher listDomainsPaginator(Consumer<ListDomainsRequest.Builder> listDomainsRequest) {
        return listDomainsPaginator(ListDomainsRequest.builder().applyMutation(listDomainsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of fleets for the current account and Region.
     * </p>
     *
     * @param listFleetsRequest
     * @return A Java Future containing the result of the ListFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListFleets" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<ListFleetsResponse> listFleets(ListFleetsRequest listFleetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of fleets for the current account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFleetsRequest#builder()}
     * </p>
     *
     * @param listFleetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.ListFleetsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListFleets" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<ListFleetsResponse> listFleets(Consumer<ListFleetsRequest.Builder> listFleetsRequest) {
        return listFleets(ListFleetsRequest.builder().applyMutation(listFleetsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of fleets for the current account and Region.
     * </p>
     *
     * @return A Java Future containing the result of the ListFleets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListFleets" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<ListFleetsResponse> listFleets() {
        return listFleets(ListFleetsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.worklink.model.ListFleetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.worklink.model.ListFleetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.worklink.model.ListFleetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.worklink.model.ListFleetsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListFleets" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default ListFleetsPublisher listFleetsPaginator() {
        return listFleetsPaginator(ListFleetsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.worklink.model.ListFleetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.worklink.model.ListFleetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.worklink.model.ListFleetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.worklink.model.ListFleetsRequest)} operation.</b>
     * </p>
     *
     * @param listFleetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListFleets" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default ListFleetsPublisher listFleetsPaginator(ListFleetsRequest listFleetsRequest) {
        return new ListFleetsPublisher(this, listFleetsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.worklink.model.ListFleetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListFleetsPublisher publisher = client.listFleetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.worklink.model.ListFleetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.worklink.model.ListFleetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.worklink.model.ListFleetsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFleetsRequest#builder()}
     * </p>
     *
     * @param listFleetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.ListFleetsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.ListFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListFleets" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default ListFleetsPublisher listFleetsPaginator(Consumer<ListFleetsRequest.Builder> listFleetsRequest) {
        return listFleetsPaginator(ListFleetsRequest.builder().applyMutation(listFleetsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of tags for the specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of website authorization providers associated with a specified fleet.
     * </p>
     *
     * @param listWebsiteAuthorizationProvidersRequest
     * @return A Java Future containing the result of the ListWebsiteAuthorizationProviders operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.ListWebsiteAuthorizationProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListWebsiteAuthorizationProviders"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<ListWebsiteAuthorizationProvidersResponse> listWebsiteAuthorizationProviders(
            ListWebsiteAuthorizationProvidersRequest listWebsiteAuthorizationProvidersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of website authorization providers associated with a specified fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWebsiteAuthorizationProvidersRequest.Builder}
     * avoiding the need to create one manually via {@link ListWebsiteAuthorizationProvidersRequest#builder()}
     * </p>
     *
     * @param listWebsiteAuthorizationProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.ListWebsiteAuthorizationProvidersRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListWebsiteAuthorizationProviders operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.ListWebsiteAuthorizationProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListWebsiteAuthorizationProviders"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<ListWebsiteAuthorizationProvidersResponse> listWebsiteAuthorizationProviders(
            Consumer<ListWebsiteAuthorizationProvidersRequest.Builder> listWebsiteAuthorizationProvidersRequest) {
        return listWebsiteAuthorizationProviders(ListWebsiteAuthorizationProvidersRequest.builder()
                .applyMutation(listWebsiteAuthorizationProvidersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWebsiteAuthorizationProviders(software.amazon.awssdk.services.worklink.model.ListWebsiteAuthorizationProvidersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListWebsiteAuthorizationProvidersPublisher publisher = client.listWebsiteAuthorizationProvidersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListWebsiteAuthorizationProvidersPublisher publisher = client.listWebsiteAuthorizationProvidersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.worklink.model.ListWebsiteAuthorizationProvidersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.worklink.model.ListWebsiteAuthorizationProvidersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWebsiteAuthorizationProviders(software.amazon.awssdk.services.worklink.model.ListWebsiteAuthorizationProvidersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWebsiteAuthorizationProvidersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.ListWebsiteAuthorizationProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListWebsiteAuthorizationProviders"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default ListWebsiteAuthorizationProvidersPublisher listWebsiteAuthorizationProvidersPaginator(
            ListWebsiteAuthorizationProvidersRequest listWebsiteAuthorizationProvidersRequest) {
        return new ListWebsiteAuthorizationProvidersPublisher(this, listWebsiteAuthorizationProvidersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWebsiteAuthorizationProviders(software.amazon.awssdk.services.worklink.model.ListWebsiteAuthorizationProvidersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListWebsiteAuthorizationProvidersPublisher publisher = client.listWebsiteAuthorizationProvidersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListWebsiteAuthorizationProvidersPublisher publisher = client.listWebsiteAuthorizationProvidersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.worklink.model.ListWebsiteAuthorizationProvidersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.worklink.model.ListWebsiteAuthorizationProvidersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWebsiteAuthorizationProviders(software.amazon.awssdk.services.worklink.model.ListWebsiteAuthorizationProvidersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWebsiteAuthorizationProvidersRequest.Builder}
     * avoiding the need to create one manually via {@link ListWebsiteAuthorizationProvidersRequest#builder()}
     * </p>
     *
     * @param listWebsiteAuthorizationProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.ListWebsiteAuthorizationProvidersRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.ListWebsiteAuthorizationProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListWebsiteAuthorizationProviders"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default ListWebsiteAuthorizationProvidersPublisher listWebsiteAuthorizationProvidersPaginator(
            Consumer<ListWebsiteAuthorizationProvidersRequest.Builder> listWebsiteAuthorizationProvidersRequest) {
        return listWebsiteAuthorizationProvidersPaginator(ListWebsiteAuthorizationProvidersRequest.builder()
                .applyMutation(listWebsiteAuthorizationProvidersRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of certificate authorities added for the current account and Region.
     * </p>
     *
     * @param listWebsiteCertificateAuthoritiesRequest
     * @return A Java Future containing the result of the ListWebsiteCertificateAuthorities operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.ListWebsiteCertificateAuthorities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListWebsiteCertificateAuthorities"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<ListWebsiteCertificateAuthoritiesResponse> listWebsiteCertificateAuthorities(
            ListWebsiteCertificateAuthoritiesRequest listWebsiteCertificateAuthoritiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of certificate authorities added for the current account and Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWebsiteCertificateAuthoritiesRequest.Builder}
     * avoiding the need to create one manually via {@link ListWebsiteCertificateAuthoritiesRequest#builder()}
     * </p>
     *
     * @param listWebsiteCertificateAuthoritiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.ListWebsiteCertificateAuthoritiesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListWebsiteCertificateAuthorities operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.ListWebsiteCertificateAuthorities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListWebsiteCertificateAuthorities"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<ListWebsiteCertificateAuthoritiesResponse> listWebsiteCertificateAuthorities(
            Consumer<ListWebsiteCertificateAuthoritiesRequest.Builder> listWebsiteCertificateAuthoritiesRequest) {
        return listWebsiteCertificateAuthorities(ListWebsiteCertificateAuthoritiesRequest.builder()
                .applyMutation(listWebsiteCertificateAuthoritiesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWebsiteCertificateAuthorities(software.amazon.awssdk.services.worklink.model.ListWebsiteCertificateAuthoritiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListWebsiteCertificateAuthoritiesPublisher publisher = client.listWebsiteCertificateAuthoritiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListWebsiteCertificateAuthoritiesPublisher publisher = client.listWebsiteCertificateAuthoritiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.worklink.model.ListWebsiteCertificateAuthoritiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.worklink.model.ListWebsiteCertificateAuthoritiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWebsiteCertificateAuthorities(software.amazon.awssdk.services.worklink.model.ListWebsiteCertificateAuthoritiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWebsiteCertificateAuthoritiesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.ListWebsiteCertificateAuthorities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListWebsiteCertificateAuthorities"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default ListWebsiteCertificateAuthoritiesPublisher listWebsiteCertificateAuthoritiesPaginator(
            ListWebsiteCertificateAuthoritiesRequest listWebsiteCertificateAuthoritiesRequest) {
        return new ListWebsiteCertificateAuthoritiesPublisher(this, listWebsiteCertificateAuthoritiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWebsiteCertificateAuthorities(software.amazon.awssdk.services.worklink.model.ListWebsiteCertificateAuthoritiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListWebsiteCertificateAuthoritiesPublisher publisher = client.listWebsiteCertificateAuthoritiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.worklink.paginators.ListWebsiteCertificateAuthoritiesPublisher publisher = client.listWebsiteCertificateAuthoritiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.worklink.model.ListWebsiteCertificateAuthoritiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.worklink.model.ListWebsiteCertificateAuthoritiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWebsiteCertificateAuthorities(software.amazon.awssdk.services.worklink.model.ListWebsiteCertificateAuthoritiesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWebsiteCertificateAuthoritiesRequest.Builder}
     * avoiding the need to create one manually via {@link ListWebsiteCertificateAuthoritiesRequest#builder()}
     * </p>
     *
     * @param listWebsiteCertificateAuthoritiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.ListWebsiteCertificateAuthoritiesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.ListWebsiteCertificateAuthorities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListWebsiteCertificateAuthorities"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default ListWebsiteCertificateAuthoritiesPublisher listWebsiteCertificateAuthoritiesPaginator(
            Consumer<ListWebsiteCertificateAuthoritiesRequest.Builder> listWebsiteCertificateAuthoritiesRequest) {
        return listWebsiteCertificateAuthoritiesPaginator(ListWebsiteCertificateAuthoritiesRequest.builder()
                .applyMutation(listWebsiteCertificateAuthoritiesRequest).build());
    }

    /**
     * <p>
     * Moves a domain to ACTIVE status if it was in the INACTIVE status.
     * </p>
     *
     * @param restoreDomainAccessRequest
     * @return A Java Future containing the result of the RestoreDomainAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.RestoreDomainAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/RestoreDomainAccess" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<RestoreDomainAccessResponse> restoreDomainAccess(
            RestoreDomainAccessRequest restoreDomainAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Moves a domain to ACTIVE status if it was in the INACTIVE status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreDomainAccessRequest.Builder} avoiding the
     * need to create one manually via {@link RestoreDomainAccessRequest#builder()}
     * </p>
     *
     * @param restoreDomainAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.RestoreDomainAccessRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RestoreDomainAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.RestoreDomainAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/RestoreDomainAccess" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<RestoreDomainAccessResponse> restoreDomainAccess(
            Consumer<RestoreDomainAccessRequest.Builder> restoreDomainAccessRequest) {
        return restoreDomainAccess(RestoreDomainAccessRequest.builder().applyMutation(restoreDomainAccessRequest).build());
    }

    /**
     * <p>
     * Moves a domain to INACTIVE status if it was in the ACTIVE status.
     * </p>
     *
     * @param revokeDomainAccessRequest
     * @return A Java Future containing the result of the RevokeDomainAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.RevokeDomainAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/RevokeDomainAccess" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<RevokeDomainAccessResponse> revokeDomainAccess(RevokeDomainAccessRequest revokeDomainAccessRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Moves a domain to INACTIVE status if it was in the ACTIVE status.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RevokeDomainAccessRequest.Builder} avoiding the
     * need to create one manually via {@link RevokeDomainAccessRequest#builder()}
     * </p>
     *
     * @param revokeDomainAccessRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.RevokeDomainAccessRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RevokeDomainAccess operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.RevokeDomainAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/RevokeDomainAccess" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<RevokeDomainAccessResponse> revokeDomainAccess(
            Consumer<RevokeDomainAccessRequest.Builder> revokeDomainAccessRequest) {
        return revokeDomainAccess(RevokeDomainAccessRequest.builder().applyMutation(revokeDomainAccessRequest).build());
    }

    /**
     * <p>
     * Signs the user out from all of their devices. The user can sign in again if they have valid credentials.
     * </p>
     *
     * @param signOutUserRequest
     * @return A Java Future containing the result of the SignOutUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.SignOutUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/SignOutUser" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<SignOutUserResponse> signOutUser(SignOutUserRequest signOutUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Signs the user out from all of their devices. The user can sign in again if they have valid credentials.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SignOutUserRequest.Builder} avoiding the need to
     * create one manually via {@link SignOutUserRequest#builder()}
     * </p>
     *
     * @param signOutUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.SignOutUserRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SignOutUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.SignOutUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/SignOutUser" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<SignOutUserResponse> signOutUser(Consumer<SignOutUserRequest.Builder> signOutUserRequest) {
        return signOutUser(SignOutUserRequest.builder().applyMutation(signOutUserRequest).build());
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified resource, such as a fleet. Each tag consists of a key and
     * an optional value. If a resource already has a tag with the same key, this operation updates its value.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/TagResource" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified resource, such as a fleet. Each tag consists of a key and
     * an optional value. If a resource already has a tag with the same key, this operation updates its value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/TagResource" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UntagResource" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UntagResource" target="_top">AWS API
     *      Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the audit stream configuration for the fleet.
     * </p>
     *
     * @param updateAuditStreamConfigurationRequest
     * @return A Java Future containing the result of the UpdateAuditStreamConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.UpdateAuditStreamConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateAuditStreamConfiguration"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<UpdateAuditStreamConfigurationResponse> updateAuditStreamConfiguration(
            UpdateAuditStreamConfigurationRequest updateAuditStreamConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the audit stream configuration for the fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAuditStreamConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateAuditStreamConfigurationRequest#builder()}
     * </p>
     *
     * @param updateAuditStreamConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.UpdateAuditStreamConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateAuditStreamConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.UpdateAuditStreamConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateAuditStreamConfiguration"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<UpdateAuditStreamConfigurationResponse> updateAuditStreamConfiguration(
            Consumer<UpdateAuditStreamConfigurationRequest.Builder> updateAuditStreamConfigurationRequest) {
        return updateAuditStreamConfiguration(UpdateAuditStreamConfigurationRequest.builder()
                .applyMutation(updateAuditStreamConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates the company network configuration for the fleet.
     * </p>
     *
     * @param updateCompanyNetworkConfigurationRequest
     * @return A Java Future containing the result of the UpdateCompanyNetworkConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.UpdateCompanyNetworkConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateCompanyNetworkConfiguration"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<UpdateCompanyNetworkConfigurationResponse> updateCompanyNetworkConfiguration(
            UpdateCompanyNetworkConfigurationRequest updateCompanyNetworkConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the company network configuration for the fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCompanyNetworkConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCompanyNetworkConfigurationRequest#builder()}
     * </p>
     *
     * @param updateCompanyNetworkConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.UpdateCompanyNetworkConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateCompanyNetworkConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.UpdateCompanyNetworkConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateCompanyNetworkConfiguration"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<UpdateCompanyNetworkConfigurationResponse> updateCompanyNetworkConfiguration(
            Consumer<UpdateCompanyNetworkConfigurationRequest.Builder> updateCompanyNetworkConfigurationRequest) {
        return updateCompanyNetworkConfiguration(UpdateCompanyNetworkConfigurationRequest.builder()
                .applyMutation(updateCompanyNetworkConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates the device policy configuration for the fleet.
     * </p>
     *
     * @param updateDevicePolicyConfigurationRequest
     * @return A Java Future containing the result of the UpdateDevicePolicyConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.UpdateDevicePolicyConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateDevicePolicyConfiguration"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<UpdateDevicePolicyConfigurationResponse> updateDevicePolicyConfiguration(
            UpdateDevicePolicyConfigurationRequest updateDevicePolicyConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the device policy configuration for the fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDevicePolicyConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateDevicePolicyConfigurationRequest#builder()}
     * </p>
     *
     * @param updateDevicePolicyConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.UpdateDevicePolicyConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateDevicePolicyConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.UpdateDevicePolicyConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateDevicePolicyConfiguration"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<UpdateDevicePolicyConfigurationResponse> updateDevicePolicyConfiguration(
            Consumer<UpdateDevicePolicyConfigurationRequest.Builder> updateDevicePolicyConfigurationRequest) {
        return updateDevicePolicyConfiguration(UpdateDevicePolicyConfigurationRequest.builder()
                .applyMutation(updateDevicePolicyConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates domain metadata, such as DisplayName.
     * </p>
     *
     * @param updateDomainMetadataRequest
     * @return A Java Future containing the result of the UpdateDomainMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.UpdateDomainMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateDomainMetadata" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<UpdateDomainMetadataResponse> updateDomainMetadata(
            UpdateDomainMetadataRequest updateDomainMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates domain metadata, such as DisplayName.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDomainMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDomainMetadataRequest#builder()}
     * </p>
     *
     * @param updateDomainMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.UpdateDomainMetadataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateDomainMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.UpdateDomainMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateDomainMetadata" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<UpdateDomainMetadataResponse> updateDomainMetadata(
            Consumer<UpdateDomainMetadataRequest.Builder> updateDomainMetadataRequest) {
        return updateDomainMetadata(UpdateDomainMetadataRequest.builder().applyMutation(updateDomainMetadataRequest).build());
    }

    /**
     * <p>
     * Updates fleet metadata, such as DisplayName.
     * </p>
     *
     * @param updateFleetMetadataRequest
     * @return A Java Future containing the result of the UpdateFleetMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.UpdateFleetMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateFleetMetadata" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<UpdateFleetMetadataResponse> updateFleetMetadata(
            UpdateFleetMetadataRequest updateFleetMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates fleet metadata, such as DisplayName.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFleetMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateFleetMetadataRequest#builder()}
     * </p>
     *
     * @param updateFleetMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.UpdateFleetMetadataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateFleetMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.UpdateFleetMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateFleetMetadata" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<UpdateFleetMetadataResponse> updateFleetMetadata(
            Consumer<UpdateFleetMetadataRequest.Builder> updateFleetMetadataRequest) {
        return updateFleetMetadata(UpdateFleetMetadataRequest.builder().applyMutation(updateFleetMetadataRequest).build());
    }

    /**
     * <p>
     * Updates the identity provider configuration for the fleet.
     * </p>
     *
     * @param updateIdentityProviderConfigurationRequest
     * @return A Java Future containing the result of the UpdateIdentityProviderConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.UpdateIdentityProviderConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateIdentityProviderConfiguration"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<UpdateIdentityProviderConfigurationResponse> updateIdentityProviderConfiguration(
            UpdateIdentityProviderConfigurationRequest updateIdentityProviderConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the identity provider configuration for the fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIdentityProviderConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateIdentityProviderConfigurationRequest#builder()}
     * </p>
     *
     * @param updateIdentityProviderConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.worklink.model.UpdateIdentityProviderConfigurationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateIdentityProviderConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException You are not authorized to perform this action.</li>
     *         <li>InternalServerErrorException The service is temporarily unavailable.</li>
     *         <li>InvalidRequestException The request is not valid.</li>
     *         <li>ResourceNotFoundException The requested resource was not found.</li>
     *         <li>TooManyRequestsException The number of requests exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkLinkException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkLinkAsyncClient.UpdateIdentityProviderConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/UpdateIdentityProviderConfiguration"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated Amazon WorkLink is no longer supported. This will be removed in a future version of the SDK.
     */
    @Deprecated
    default CompletableFuture<UpdateIdentityProviderConfigurationResponse> updateIdentityProviderConfiguration(
            Consumer<UpdateIdentityProviderConfigurationRequest.Builder> updateIdentityProviderConfigurationRequest) {
        return updateIdentityProviderConfiguration(UpdateIdentityProviderConfigurationRequest.builder()
                .applyMutation(updateIdentityProviderConfigurationRequest).build());
    }

    @Override
    default WorkLinkServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link WorkLinkAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static WorkLinkAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link WorkLinkAsyncClient}.
     */
    static WorkLinkAsyncClientBuilder builder() {
        return new DefaultWorkLinkAsyncClientBuilder();
    }
}
