/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.worklink.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DomainStatus {
    PENDING_VALIDATION("PENDING_VALIDATION"),
    ASSOCIATING("ASSOCIATING"),
    ACTIVE("ACTIVE"),
    INACTIVE("INACTIVE"),
    DISASSOCIATING("DISASSOCIATING"),
    DISASSOCIATED("DISASSOCIATED"),
    FAILED_TO_ASSOCIATE("FAILED_TO_ASSOCIATE"),
    FAILED_TO_DISASSOCIATE("FAILED_TO_DISASSOCIATE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DomainStatus> VALUE_MAP;
    private final String value;

    private DomainStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DomainStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DomainStatus> knownValues() {
        EnumSet<DomainStatus> knownValues = EnumSet.allOf(DomainStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DomainStatus.class, DomainStatus::toString);
    }
}

