/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Permission granted to a user, group, or resource to access a certain aspect of another user, group, or resource
 * mailbox.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Permission implements SdkPojo, Serializable, ToCopyableBuilder<Permission.Builder, Permission> {
    private static final SdkField<String> GRANTEE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Permission::granteeId)).setter(setter(Builder::granteeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GranteeId").build()).build();

    private static final SdkField<String> GRANTEE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Permission::granteeTypeAsString)).setter(setter(Builder::granteeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GranteeType").build()).build();

    private static final SdkField<List<String>> PERMISSION_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Permission::permissionValuesAsStrings))
            .setter(setter(Builder::permissionValuesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRANTEE_ID_FIELD,
            GRANTEE_TYPE_FIELD, PERMISSION_VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String granteeId;

    private final String granteeType;

    private final List<String> permissionValues;

    private Permission(BuilderImpl builder) {
        this.granteeId = builder.granteeId;
        this.granteeType = builder.granteeType;
        this.permissionValues = builder.permissionValues;
    }

    /**
     * <p>
     * The identifier of the user, group, or resource to which the permissions are granted.
     * </p>
     * 
     * @return The identifier of the user, group, or resource to which the permissions are granted.
     */
    public String granteeId() {
        return granteeId;
    }

    /**
     * <p>
     * The type of user, group, or resource referred to in GranteeId.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #granteeType} will
     * return {@link MemberType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #granteeTypeAsString}.
     * </p>
     * 
     * @return The type of user, group, or resource referred to in GranteeId.
     * @see MemberType
     */
    public MemberType granteeType() {
        return MemberType.fromValue(granteeType);
    }

    /**
     * <p>
     * The type of user, group, or resource referred to in GranteeId.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #granteeType} will
     * return {@link MemberType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #granteeTypeAsString}.
     * </p>
     * 
     * @return The type of user, group, or resource referred to in GranteeId.
     * @see MemberType
     */
    public String granteeTypeAsString() {
        return granteeType;
    }

    /**
     * <p>
     * The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox (the
     * grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of the owner
     * of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS allows the
     * grantee full access to the mailbox, irrespective of other folder-level permissions set on the mailbox.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the
     *         mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email
     *         on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of these
     *         emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other folder-level
     *         permissions set on the mailbox.
     */
    public List<PermissionType> permissionValues() {
        return PermissionValuesCopier.copyStringToEnum(permissionValues);
    }

    /**
     * <p>
     * The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox (the
     * grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of the owner
     * of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS allows the
     * grantee full access to the mailbox, irrespective of other folder-level permissions set on the mailbox.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the
     *         mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email
     *         on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of these
     *         emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other folder-level
     *         permissions set on the mailbox.
     */
    public List<String> permissionValuesAsStrings() {
        return permissionValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(granteeId());
        hashCode = 31 * hashCode + Objects.hashCode(granteeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(permissionValuesAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Permission)) {
            return false;
        }
        Permission other = (Permission) obj;
        return Objects.equals(granteeId(), other.granteeId())
                && Objects.equals(granteeTypeAsString(), other.granteeTypeAsString())
                && Objects.equals(permissionValuesAsStrings(), other.permissionValuesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Permission").add("GranteeId", granteeId()).add("GranteeType", granteeTypeAsString())
                .add("PermissionValues", permissionValuesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GranteeId":
            return Optional.ofNullable(clazz.cast(granteeId()));
        case "GranteeType":
            return Optional.ofNullable(clazz.cast(granteeTypeAsString()));
        case "PermissionValues":
            return Optional.ofNullable(clazz.cast(permissionValuesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Permission, T> g) {
        return obj -> g.apply((Permission) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Permission> {
        /**
         * <p>
         * The identifier of the user, group, or resource to which the permissions are granted.
         * </p>
         * 
         * @param granteeId
         *        The identifier of the user, group, or resource to which the permissions are granted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder granteeId(String granteeId);

        /**
         * <p>
         * The type of user, group, or resource referred to in GranteeId.
         * </p>
         * 
         * @param granteeType
         *        The type of user, group, or resource referred to in GranteeId.
         * @see MemberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberType
         */
        Builder granteeType(String granteeType);

        /**
         * <p>
         * The type of user, group, or resource referred to in GranteeId.
         * </p>
         * 
         * @param granteeType
         *        The type of user, group, or resource referred to in GranteeId.
         * @see MemberType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberType
         */
        Builder granteeType(MemberType granteeType);

        /**
         * <p>
         * The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox
         * (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of
         * the owner of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS
         * allows the grantee full access to the mailbox, irrespective of other folder-level permissions set on the
         * mailbox.
         * </p>
         * 
         * @param permissionValues
         *        The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the
         *        mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send
         *        email on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of
         *        these emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other
         *        folder-level permissions set on the mailbox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionValuesWithStrings(Collection<String> permissionValues);

        /**
         * <p>
         * The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox
         * (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of
         * the owner of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS
         * allows the grantee full access to the mailbox, irrespective of other folder-level permissions set on the
         * mailbox.
         * </p>
         * 
         * @param permissionValues
         *        The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the
         *        mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send
         *        email on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of
         *        these emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other
         *        folder-level permissions set on the mailbox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionValuesWithStrings(String... permissionValues);

        /**
         * <p>
         * The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox
         * (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of
         * the owner of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS
         * allows the grantee full access to the mailbox, irrespective of other folder-level permissions set on the
         * mailbox.
         * </p>
         * 
         * @param permissionValues
         *        The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the
         *        mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send
         *        email on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of
         *        these emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other
         *        folder-level permissions set on the mailbox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionValues(Collection<PermissionType> permissionValues);

        /**
         * <p>
         * The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox
         * (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of
         * the owner of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS
         * allows the grantee full access to the mailbox, irrespective of other folder-level permissions set on the
         * mailbox.
         * </p>
         * 
         * @param permissionValues
         *        The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the
         *        mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send
         *        email on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of
         *        these emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other
         *        folder-level permissions set on the mailbox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionValues(PermissionType... permissionValues);
    }

    static final class BuilderImpl implements Builder {
        private String granteeId;

        private String granteeType;

        private List<String> permissionValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Permission model) {
            granteeId(model.granteeId);
            granteeType(model.granteeType);
            permissionValuesWithStrings(model.permissionValues);
        }

        public final String getGranteeId() {
            return granteeId;
        }

        @Override
        public final Builder granteeId(String granteeId) {
            this.granteeId = granteeId;
            return this;
        }

        public final void setGranteeId(String granteeId) {
            this.granteeId = granteeId;
        }

        public final String getGranteeTypeAsString() {
            return granteeType;
        }

        @Override
        public final Builder granteeType(String granteeType) {
            this.granteeType = granteeType;
            return this;
        }

        @Override
        public final Builder granteeType(MemberType granteeType) {
            this.granteeType(granteeType == null ? null : granteeType.toString());
            return this;
        }

        public final void setGranteeType(String granteeType) {
            this.granteeType = granteeType;
        }

        public final Collection<String> getPermissionValuesAsStrings() {
            return permissionValues;
        }

        @Override
        public final Builder permissionValuesWithStrings(Collection<String> permissionValues) {
            this.permissionValues = PermissionValuesCopier.copy(permissionValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionValuesWithStrings(String... permissionValues) {
            permissionValuesWithStrings(Arrays.asList(permissionValues));
            return this;
        }

        @Override
        public final Builder permissionValues(Collection<PermissionType> permissionValues) {
            this.permissionValues = PermissionValuesCopier.copyEnumToString(permissionValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionValues(PermissionType... permissionValues) {
            permissionValues(Arrays.asList(permissionValues));
            return this;
        }

        public final void setPermissionValuesWithStrings(Collection<String> permissionValues) {
            this.permissionValues = PermissionValuesCopier.copy(permissionValues);
        }

        @Override
        public Permission build() {
            return new Permission(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
