/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.workmail.model.PermissionType;
import software.amazon.awssdk.services.workmail.model.PermissionValuesCopier;
import software.amazon.awssdk.services.workmail.model.WorkMailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutMailboxPermissionsRequest
extends WorkMailRequest
implements ToCopyableBuilder<Builder, PutMailboxPermissionsRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutMailboxPermissionsRequest.getter(PutMailboxPermissionsRequest::organizationId)).setter(PutMailboxPermissionsRequest.setter(Builder::organizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()}).build();
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutMailboxPermissionsRequest.getter(PutMailboxPermissionsRequest::entityId)).setter(PutMailboxPermissionsRequest.setter(Builder::entityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()}).build();
    private static final SdkField<String> GRANTEE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutMailboxPermissionsRequest.getter(PutMailboxPermissionsRequest::granteeId)).setter(PutMailboxPermissionsRequest.setter(Builder::granteeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GranteeId").build()}).build();
    private static final SdkField<List<String>> PERMISSION_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PutMailboxPermissionsRequest.getter(PutMailboxPermissionsRequest::permissionValuesAsStrings)).setter(PutMailboxPermissionsRequest.setter(Builder::permissionValuesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD, ENTITY_ID_FIELD, GRANTEE_ID_FIELD, PERMISSION_VALUES_FIELD));
    private final String organizationId;
    private final String entityId;
    private final String granteeId;
    private final List<String> permissionValues;

    private PutMailboxPermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.entityId = builder.entityId;
        this.granteeId = builder.granteeId;
        this.permissionValues = builder.permissionValues;
    }

    public String organizationId() {
        return this.organizationId;
    }

    public String entityId() {
        return this.entityId;
    }

    public String granteeId() {
        return this.granteeId;
    }

    public List<PermissionType> permissionValues() {
        return PermissionValuesCopier.copyStringToEnum(this.permissionValues);
    }

    public List<String> permissionValuesAsStrings() {
        return this.permissionValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.granteeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionValuesAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMailboxPermissionsRequest)) {
            return false;
        }
        PutMailboxPermissionsRequest other = (PutMailboxPermissionsRequest)((Object)obj);
        return Objects.equals(this.organizationId(), other.organizationId()) && Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.granteeId(), other.granteeId()) && Objects.equals(this.permissionValuesAsStrings(), other.permissionValuesAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"PutMailboxPermissionsRequest").add("OrganizationId", (Object)this.organizationId()).add("EntityId", (Object)this.entityId()).add("GranteeId", (Object)this.granteeId()).add("PermissionValues", this.permissionValuesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationId": {
                return Optional.ofNullable(clazz.cast(this.organizationId()));
            }
            case "EntityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "GranteeId": {
                return Optional.ofNullable(clazz.cast(this.granteeId()));
            }
            case "PermissionValues": {
                return Optional.ofNullable(clazz.cast(this.permissionValuesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutMailboxPermissionsRequest, T> g) {
        return obj -> g.apply((PutMailboxPermissionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailRequest.BuilderImpl
    implements Builder {
        private String organizationId;
        private String entityId;
        private String granteeId;
        private List<String> permissionValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutMailboxPermissionsRequest model) {
            super(model);
            this.organizationId(model.organizationId);
            this.entityId(model.entityId);
            this.granteeId(model.granteeId);
            this.permissionValuesWithStrings(model.permissionValues);
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public final String getEntityId() {
            return this.entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public final String getGranteeId() {
            return this.granteeId;
        }

        @Override
        public final Builder granteeId(String granteeId) {
            this.granteeId = granteeId;
            return this;
        }

        public final void setGranteeId(String granteeId) {
            this.granteeId = granteeId;
        }

        public final Collection<String> getPermissionValuesAsStrings() {
            return this.permissionValues;
        }

        @Override
        public final Builder permissionValuesWithStrings(Collection<String> permissionValues) {
            this.permissionValues = PermissionValuesCopier.copy(permissionValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionValuesWithStrings(String ... permissionValues) {
            this.permissionValuesWithStrings(Arrays.asList(permissionValues));
            return this;
        }

        @Override
        public final Builder permissionValues(Collection<PermissionType> permissionValues) {
            this.permissionValues = PermissionValuesCopier.copyEnumToString(permissionValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionValues(PermissionType ... permissionValues) {
            this.permissionValues(Arrays.asList(permissionValues));
            return this;
        }

        public final void setPermissionValuesWithStrings(Collection<String> permissionValues) {
            this.permissionValues = PermissionValuesCopier.copy(permissionValues);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutMailboxPermissionsRequest build() {
            return new PutMailboxPermissionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkMailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutMailboxPermissionsRequest> {
        public Builder organizationId(String var1);

        public Builder entityId(String var1);

        public Builder granteeId(String var1);

        public Builder permissionValuesWithStrings(Collection<String> var1);

        public Builder permissionValuesWithStrings(String ... var1);

        public Builder permissionValues(Collection<PermissionType> var1);

        public Builder permissionValues(PermissionType ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

