/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAliasRequest extends WorkMailRequest implements
        ToCopyableBuilder<DeleteAliasRequest.Builder, DeleteAliasRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteAliasRequest::organizationId)).setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteAliasRequest::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()).build();

    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteAliasRequest::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD,
            ENTITY_ID_FIELD, ALIAS_FIELD));

    private final String organizationId;

    private final String entityId;

    private final String alias;

    private DeleteAliasRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.entityId = builder.entityId;
        this.alias = builder.alias;
    }

    /**
     * <p>
     * The identifier for the organization under which the user exists.
     * </p>
     * 
     * @return The identifier for the organization under which the user exists.
     */
    public String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * The identifier for the member (user or group) from which to have the aliases removed.
     * </p>
     * 
     * @return The identifier for the member (user or group) from which to have the aliases removed.
     */
    public String entityId() {
        return entityId;
    }

    /**
     * <p>
     * The aliases to be removed from the user's set of aliases. Duplicate entries in the list are collapsed into single
     * entries (the list is transformed into a set).
     * </p>
     * 
     * @return The aliases to be removed from the user's set of aliases. Duplicate entries in the list are collapsed
     *         into single entries (the list is transformed into a set).
     */
    public String alias() {
        return alias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAliasRequest)) {
            return false;
        }
        DeleteAliasRequest other = (DeleteAliasRequest) obj;
        return Objects.equals(organizationId(), other.organizationId()) && Objects.equals(entityId(), other.entityId())
                && Objects.equals(alias(), other.alias());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteAliasRequest").add("OrganizationId", organizationId()).add("EntityId", entityId())
                .add("Alias", alias()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "EntityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "Alias":
            return Optional.ofNullable(clazz.cast(alias()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAliasRequest, T> g) {
        return obj -> g.apply((DeleteAliasRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteAliasRequest> {
        /**
         * <p>
         * The identifier for the organization under which the user exists.
         * </p>
         * 
         * @param organizationId
         *        The identifier for the organization under which the user exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * The identifier for the member (user or group) from which to have the aliases removed.
         * </p>
         * 
         * @param entityId
         *        The identifier for the member (user or group) from which to have the aliases removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * The aliases to be removed from the user's set of aliases. Duplicate entries in the list are collapsed into
         * single entries (the list is transformed into a set).
         * </p>
         * 
         * @param alias
         *        The aliases to be removed from the user's set of aliases. Duplicate entries in the list are collapsed
         *        into single entries (the list is transformed into a set).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkMailRequest.BuilderImpl implements Builder {
        private String organizationId;

        private String entityId;

        private String alias;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAliasRequest model) {
            super(model);
            organizationId(model.organizationId);
            entityId(model.entityId);
            alias(model.alias);
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public final String getEntityId() {
            return entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public final String getAlias() {
            return alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAliasRequest build() {
            return new DeleteAliasRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
