/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeOrganizationResponse extends WorkMailResponse implements
        ToCopyableBuilder<DescribeOrganizationResponse.Builder, DescribeOrganizationResponse> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeOrganizationResponse::organizationId)).setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<String> ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeOrganizationResponse::alias)).setter(setter(Builder::alias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeOrganizationResponse::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeOrganizationResponse::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> DIRECTORY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeOrganizationResponse::directoryType)).setter(setter(Builder::directoryType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryType").build()).build();

    private static final SdkField<String> DEFAULT_MAIL_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeOrganizationResponse::defaultMailDomain)).setter(setter(Builder::defaultMailDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultMailDomain").build()).build();

    private static final SdkField<Instant> COMPLETED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeOrganizationResponse::completedDate)).setter(setter(Builder::completedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedDate").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeOrganizationResponse::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD,
            ALIAS_FIELD, STATE_FIELD, DIRECTORY_ID_FIELD, DIRECTORY_TYPE_FIELD, DEFAULT_MAIL_DOMAIN_FIELD, COMPLETED_DATE_FIELD,
            ERROR_MESSAGE_FIELD));

    private final String organizationId;

    private final String alias;

    private final String state;

    private final String directoryId;

    private final String directoryType;

    private final String defaultMailDomain;

    private final Instant completedDate;

    private final String errorMessage;

    private DescribeOrganizationResponse(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.alias = builder.alias;
        this.state = builder.state;
        this.directoryId = builder.directoryId;
        this.directoryType = builder.directoryType;
        this.defaultMailDomain = builder.defaultMailDomain;
        this.completedDate = builder.completedDate;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The identifier of an organization.
     * </p>
     * 
     * @return The identifier of an organization.
     */
    public String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * The alias for an organization.
     * </p>
     * 
     * @return The alias for an organization.
     */
    public String alias() {
        return alias;
    }

    /**
     * <p>
     * The state of an organization.
     * </p>
     * 
     * @return The state of an organization.
     */
    public String state() {
        return state;
    }

    /**
     * <p>
     * The identifier for the directory associated with an Amazon WorkMail organization.
     * </p>
     * 
     * @return The identifier for the directory associated with an Amazon WorkMail organization.
     */
    public String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The type of directory associated with the WorkMail organization.
     * </p>
     * 
     * @return The type of directory associated with the WorkMail organization.
     */
    public String directoryType() {
        return directoryType;
    }

    /**
     * <p>
     * The default mail domain associated with the organization.
     * </p>
     * 
     * @return The default mail domain associated with the organization.
     */
    public String defaultMailDomain() {
        return defaultMailDomain;
    }

    /**
     * <p>
     * The date at which the organization became usable in the WorkMail context, in UNIX epoch time format.
     * </p>
     * 
     * @return The date at which the organization became usable in the WorkMail context, in UNIX epoch time format.
     */
    public Instant completedDate() {
        return completedDate;
    }

    /**
     * <p>
     * (Optional) The error message indicating if unexpected behavior was encountered with regards to the organization.
     * </p>
     * 
     * @return (Optional) The error message indicating if unexpected behavior was encountered with regards to the
     *         organization.
     */
    public String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(alias());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(directoryType());
        hashCode = 31 * hashCode + Objects.hashCode(defaultMailDomain());
        hashCode = 31 * hashCode + Objects.hashCode(completedDate());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrganizationResponse)) {
            return false;
        }
        DescribeOrganizationResponse other = (DescribeOrganizationResponse) obj;
        return Objects.equals(organizationId(), other.organizationId()) && Objects.equals(alias(), other.alias())
                && Objects.equals(state(), other.state()) && Objects.equals(directoryId(), other.directoryId())
                && Objects.equals(directoryType(), other.directoryType())
                && Objects.equals(defaultMailDomain(), other.defaultMailDomain())
                && Objects.equals(completedDate(), other.completedDate()) && Objects.equals(errorMessage(), other.errorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeOrganizationResponse").add("OrganizationId", organizationId()).add("Alias", alias())
                .add("State", state()).add("DirectoryId", directoryId()).add("DirectoryType", directoryType())
                .add("DefaultMailDomain", defaultMailDomain()).add("CompletedDate", completedDate())
                .add("ErrorMessage", errorMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "Alias":
            return Optional.ofNullable(clazz.cast(alias()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "DirectoryType":
            return Optional.ofNullable(clazz.cast(directoryType()));
        case "DefaultMailDomain":
            return Optional.ofNullable(clazz.cast(defaultMailDomain()));
        case "CompletedDate":
            return Optional.ofNullable(clazz.cast(completedDate()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrganizationResponse, T> g) {
        return obj -> g.apply((DescribeOrganizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeOrganizationResponse> {
        /**
         * <p>
         * The identifier of an organization.
         * </p>
         * 
         * @param organizationId
         *        The identifier of an organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * The alias for an organization.
         * </p>
         * 
         * @param alias
         *        The alias for an organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alias(String alias);

        /**
         * <p>
         * The state of an organization.
         * </p>
         * 
         * @param state
         *        The state of an organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The identifier for the directory associated with an Amazon WorkMail organization.
         * </p>
         * 
         * @param directoryId
         *        The identifier for the directory associated with an Amazon WorkMail organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The type of directory associated with the WorkMail organization.
         * </p>
         * 
         * @param directoryType
         *        The type of directory associated with the WorkMail organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryType(String directoryType);

        /**
         * <p>
         * The default mail domain associated with the organization.
         * </p>
         * 
         * @param defaultMailDomain
         *        The default mail domain associated with the organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultMailDomain(String defaultMailDomain);

        /**
         * <p>
         * The date at which the organization became usable in the WorkMail context, in UNIX epoch time format.
         * </p>
         * 
         * @param completedDate
         *        The date at which the organization became usable in the WorkMail context, in UNIX epoch time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedDate(Instant completedDate);

        /**
         * <p>
         * (Optional) The error message indicating if unexpected behavior was encountered with regards to the
         * organization.
         * </p>
         * 
         * @param errorMessage
         *        (Optional) The error message indicating if unexpected behavior was encountered with regards to the
         *        organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl extends WorkMailResponse.BuilderImpl implements Builder {
        private String organizationId;

        private String alias;

        private String state;

        private String directoryId;

        private String directoryType;

        private String defaultMailDomain;

        private Instant completedDate;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrganizationResponse model) {
            super(model);
            organizationId(model.organizationId);
            alias(model.alias);
            state(model.state);
            directoryId(model.directoryId);
            directoryType(model.directoryType);
            defaultMailDomain(model.defaultMailDomain);
            completedDate(model.completedDate);
            errorMessage(model.errorMessage);
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public final String getAlias() {
            return alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final String getDirectoryType() {
            return directoryType;
        }

        @Override
        public final Builder directoryType(String directoryType) {
            this.directoryType = directoryType;
            return this;
        }

        public final void setDirectoryType(String directoryType) {
            this.directoryType = directoryType;
        }

        public final String getDefaultMailDomain() {
            return defaultMailDomain;
        }

        @Override
        public final Builder defaultMailDomain(String defaultMailDomain) {
            this.defaultMailDomain = defaultMailDomain;
            return this;
        }

        public final void setDefaultMailDomain(String defaultMailDomain) {
            this.defaultMailDomain = defaultMailDomain;
        }

        public final Instant getCompletedDate() {
            return completedDate;
        }

        @Override
        public final Builder completedDate(Instant completedDate) {
            this.completedDate = completedDate;
            return this;
        }

        public final void setCompletedDate(Instant completedDate) {
            this.completedDate = completedDate;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public DescribeOrganizationResponse build() {
            return new DescribeOrganizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
